/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.command.EnumArgument;
import nonamecrackers2.witherstormmod.common.config.ConfigHolder;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.BlockClusterEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.entity.ai.witherstorm.ultimatetarget.UltimateTargetManager;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModFeatures;
import nonamecrackers2.witherstormmod.common.init.WitherStormModPacketHandlers;
import nonamecrackers2.witherstormmod.common.packet.CreateDebrisMessage;
import nonamecrackers2.witherstormmod.common.util.EvolutionProfiler;
import nonamecrackers2.witherstormmod.common.world.gen.feature.CommandBlockPodiumFeature;

public class DebugCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder setPhaseCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"witherstormmod").requires(commandSource -> commandSource.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"podium").then(Commands.m_82127_((String)"place").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(DebugCommands::placePodium))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(DebugCommands::removePodium)))))).then(Commands.m_82127_((String)"debris").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"witherstorm", (ArgumentType)EntityArgument.m_91449_()).executes(DebugCommands::createDebris))))).then(Commands.m_82127_((String)"deathClusters").then(Commands.m_82127_((String)"drop").then(Commands.m_82129_((String)"storm", (ArgumentType)EntityArgument.m_91449_()).executes(DebugCommands::dropDeathClusters))))).then(Commands.m_82127_((String)"beacon").then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(DebugCommands::resetPlayerBeaconData))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"evolutionProfiler").then(Commands.m_82127_((String)"begin").executes(DebugCommands::beginEvolutionProfiler))).then(Commands.m_82127_((String)"query").then(Commands.m_82129_((String)"witherstorm", (ArgumentType)EntityArgument.m_91449_()).executes(DebugCommands::queryEvolutionProfiler))))).then(Commands.m_82127_((String)"splitCluster").then(Commands.m_82129_((String)"blockcluster", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"axis", (ArgumentType)EnumArgument.enumArgument(Direction.Axis.class)).executes(DebugCommands::splitBlockCluster)))));
        dispatcher.register(setPhaseCommand);
    }

    private static int placePodium(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = DimensionArgument.m_88808_(context, (String)"dimension");
        BlockPos pos = BlockPosArgument.m_118242_(context, (String)"pos");
        int result = 0;
        try {
            if (((ConfiguredFeature)WitherStormModFeatures.getConfiguredFeature(world, WitherStormModFeatures.COMMAND_BLOCK_PODIUM_FEATURE.getId()).m_203334_()).m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), RandomSource.m_216327_(), pos)) {
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static int removePodium(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = DimensionArgument.m_88808_(context, (String)"dimension");
        BlockPos pos = BlockPosArgument.m_118242_(context, (String)"pos");
        int result = 0;
        try {
            ConfiguredFeature configured = (ConfiguredFeature)WitherStormModFeatures.getConfiguredFeature(world, WitherStormModFeatures.COMMAND_BLOCK_PODIUM_FEATURE.getId()).m_203334_();
            if (((CommandBlockPodiumFeature)configured.f_65377_()).remove((WorldGenLevel)world, world.m_7726_().m_8481_(), RandomSource.m_216327_(), pos, (FeatureConfiguration)((NoneFeatureConfiguration)configured.f_65378_()))) {
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static int createDebris(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = EntityArgument.m_91452_(context, (String)"witherstorm");
        int phase = 0;
        if (entity != null) {
            if (entity instanceof WitherStormEntity) {
                WitherStormEntity storm = (WitherStormEntity)entity;
                phase = storm.getPhase();
                WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> storm.m_9236_().m_46472_()), (Object)new CreateDebrisMessage(storm, storm.isDeadOrPlayingDead()));
                source.m_288197_(() -> Component.m_237110_((String)"commands.witherstormmod.createDebris.success", (Object[])new Object[]{storm.m_5446_()}), true);
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.entity.arg.invalid"));
            }
        }
        return phase;
    }

    private static int dropDeathClusters(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = EntityArgument.m_91452_(context, (String)"storm");
        int phase = 0;
        if (entity != null) {
            if (entity instanceof WitherStormEntity) {
                WitherStormEntity storm = (WitherStormEntity)entity;
                phase = storm.getPhase();
                storm.dropMassCluster(phase);
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.entity.arg.invalid"));
            }
        }
        return phase;
    }

    private static int resetPlayerBeaconData(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        player.getCapability(WitherStormModCapabilities.PLAYER_WITHER_STORM_DATA).ifPresent(data -> data.setActivatedSuperBeacon(false));
        return 0;
    }

    private static int beginEvolutionProfiler(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        WitherStormEntity storm = (WitherStormEntity)((EntityType)WitherStormModEntityTypes.WITHER_STORM.get()).m_20615_(player.m_9236_());
        storm.m_20219_(player.m_20182_().m_82520_(0.0, 10.0, 0.0));
        storm.getEvolutionProfiler().begin();
        player.m_9236_().m_7967_((Entity)storm);
        WitherStormModConfig.SERVER.ultimateTargetingType.set((Object)UltimateTargetManager.TargetingType.NONE);
        ConfigHolder.setToDefault(WitherStormModConfig.SERVER.evolutionAttributeModifier);
        return 0;
    }

    private static int queryEvolutionProfiler(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = EntityArgument.m_91452_(context, (String)"witherstorm");
        if (entity != null) {
            if (entity instanceof WitherStormEntity) {
                WitherStormEntity storm = (WitherStormEntity)entity;
                EvolutionProfiler profiler = storm.getEvolutionProfiler();
                if (profiler.isProfiling()) {
                    source.m_288197_(() -> Component.m_237113_((String)("Consumed entities per second: " + (double)Math.round(storm.getEvolutionProfiler().getConsumedEntitiesPerSecond() * 10.0) / 10.0)), false);
                }
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.entity.arg.invalid"));
            }
        }
        return 0;
    }

    private static int splitBlockCluster(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockClusterEntity cluster;
        BlockClusterEntity split;
        Entity entity = EntityArgument.m_91452_(context, (String)"blockcluster");
        Direction.Axis axis = (Direction.Axis)context.getArgument("axis", Direction.Axis.class);
        if (entity instanceof BlockClusterEntity && (split = (cluster = (BlockClusterEntity)entity).splitAt(axis)) != null) {
            entity.m_9236_().m_7967_((Entity)split);
        }
        return 0;
    }
}

