/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.capability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.ibm.icu.impl.locale.XCldrStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.ChunkLoader;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.util.WitherStormModNBTUtil;

public class WitherStormModChunkLoader {
    public static final TicketType<ChunkPos> WITHER_STORM = TicketType.m_9462_((String)"witherstormmod:wither_storm", Comparator.comparingLong(ChunkPos::m_45588_));
    public static final TicketType<ChunkPos> LOAD = TicketType.m_9465_((String)"witherstormmod:load", Comparator.comparingLong(ChunkPos::m_45588_), (int)1);
    private final ServerLevel level;
    private final Map<UUID, Instance> instances = Maps.newHashMap();
    private List<ChunkPos> lastKnownPositions = Lists.newArrayList();
    private boolean loadedLastKnown;

    public WitherStormModChunkLoader(ServerLevel level) {
        this.level = level;
    }

    @Nullable
    public Instance getInstance(UUID id) {
        return this.instances.get(id);
    }

    public Map<UUID, Instance> getInstances() {
        return XCldrStub.ImmutableMap.copyOf(this.instances);
    }

    public void refreshAllLoaders() {
        for (Instance instance : this.instances.values()) {
            instance.unloadNotIn(null);
            instance.createChunkQueue();
        }
    }

    public void tick() {
        if (!this.loadedLastKnown) {
            for (ChunkPos pos : this.lastKnownPositions) {
                this.level.m_7726_().m_8387_(LOAD, pos, 2, (Object)pos);
            }
            this.loadedLastKnown = true;
        }
        for (Entity entity : this.level.m_8583_()) {
            ChunkLoader loader;
            if (!(entity instanceof ChunkLoader) || !(loader = (ChunkLoader)entity).shouldLoad()) continue;
            Instance instance = this.instances.computeIfAbsent(entity.m_20148_(), id -> {
                ChunkPos pos = entity.m_146902_();
                return new Instance(loader, pos, loader.totalChunksToLoad());
            });
            instance.updateCurrentPosition(entity.m_146902_());
        }
        Iterator<Map.Entry<UUID, Instance>> iterator = this.instances.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Instance> entry = iterator.next();
            Instance instance = entry.getValue();
            if (instance.loader.isStillValidForChunkLoading()) {
                if (((Boolean)WitherStormModConfig.SERVER.shouldChunkLoadWhenNoPlayers.get()).booleanValue() || this.level.m_7654_().m_7416_() > 0) {
                    if (instance.checkAndClearNeedsInit()) {
                        instance.createChunkQueue();
                    }
                    instance.tick();
                    continue;
                }
                instance.unloadNotIn(null);
                instance.needsInit = true;
                continue;
            }
            instance.unloadNotIn(null);
            iterator.remove();
        }
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        if (!this.instances.isEmpty()) {
            tag.m_128365_("LastKnownPositions", (Tag)WitherStormModNBTUtil.writeChunkPosList(this.instances.values().stream().map(Instance::getPos).toList()));
        }
        return tag;
    }

    public void read(CompoundTag tag) {
        if (tag.m_128441_("LastKnownPositions")) {
            this.lastKnownPositions = WitherStormModNBTUtil.readChunkPosList(tag.m_128469_("LastKnownPositions"));
        }
    }

    public class Instance {
        private ChunkPos current;
        private final Queue<ChunkPos> queue = Queues.newArrayDeque();
        private List<ChunkPos> loadedChunks = Lists.newArrayList();
        private int maxToLoad;
        private boolean needsInit = true;
        private final ChunkLoader loader;

        public Instance(ChunkLoader loader, ChunkPos current, int total) {
            this.loader = loader;
            this.current = current;
            this.maxToLoad = total;
        }

        public int getTotalLoaded() {
            return this.loadedChunks.size();
        }

        public int getTotalToLoad() {
            return this.maxToLoad;
        }

        public ChunkPos getPos() {
            return this.current;
        }

        private List<ChunkPos> getChunksToLoadList() {
            int currentSize = 0;
            ArrayList positions = Lists.newArrayList();
            positions.add(this.current);
            ++currentSize;
            int radius = 1;
            while (currentSize < this.maxToLoad) {
                int q;
                for (q = -radius + 1; q <= radius && currentSize < this.maxToLoad; ++currentSize, ++q) {
                    positions.add(new ChunkPos(this.current.f_45578_ + radius, this.current.f_45579_ + q));
                }
                for (q = radius - 1; q >= -radius && currentSize < this.maxToLoad; ++currentSize, --q) {
                    positions.add(new ChunkPos(this.current.f_45578_ + q, this.current.f_45579_ + radius));
                }
                for (q = radius - 1; q >= -radius && currentSize < this.maxToLoad; ++currentSize, --q) {
                    positions.add(new ChunkPos(this.current.f_45578_ - radius, this.current.f_45579_ + q));
                }
                for (q = -radius + 1; q <= radius && currentSize < this.maxToLoad; ++currentSize, ++q) {
                    positions.add(new ChunkPos(this.current.f_45578_ + q, this.current.f_45579_ - radius));
                }
                ++radius;
            }
            return positions;
        }

        public void createChunkQueue(List<ChunkPos> chunks) {
            this.queue.clear();
            for (ChunkPos pos : chunks) {
                if (this.loadedChunks.contains(pos)) continue;
                this.queue.add(pos);
            }
        }

        public void createChunkQueue() {
            this.createChunkQueue(this.getChunksToLoadList());
        }

        public void tick() {
            if (this.queue.size() > 0) {
                ChunkPos pos = this.queue.poll();
                this.loadChunk(pos);
                this.loadedChunks.add(pos);
            }
        }

        public void updateCurrentPosition(ChunkPos pos) {
            if (!this.current.equals((Object)pos)) {
                this.current = pos;
                List<ChunkPos> chunks = this.getChunksToLoadList();
                this.unloadNotIn(chunks);
                this.createChunkQueue(chunks);
            }
        }

        public void unloadNotIn(@Nullable Collection<ChunkPos> collection) {
            Iterator<ChunkPos> iterator = this.loadedChunks.iterator();
            while (iterator.hasNext()) {
                ChunkPos loaded = iterator.next();
                boolean flag = true;
                if (collection != null) {
                    for (ChunkPos pos : collection) {
                        if (!pos.equals((Object)loaded)) continue;
                        flag = false;
                        break;
                    }
                }
                if (!flag) continue;
                this.unloadChunk(loaded);
                iterator.remove();
            }
        }

        public boolean checkAndClearNeedsInit() {
            boolean flag = this.needsInit;
            if (flag) {
                this.needsInit = false;
            }
            return flag;
        }

        private void loadChunk(ChunkPos pos) {
            WitherStormModChunkLoader.this.level.m_7726_().addRegionTicket(WITHER_STORM, pos, 11, (Object)pos, true);
        }

        private void unloadChunk(ChunkPos pos) {
            WitherStormModChunkLoader.this.level.m_7726_().removeRegionTicket(WITHER_STORM, pos, 11, (Object)pos, true);
        }
    }

    public static class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void onLevelTick(TickEvent.LevelTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                event.level.getCapability(WitherStormModCapabilities.CHUNK_LOADER).ifPresent(WitherStormModChunkLoader::tick);
            }
        }
    }
}

