/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Contributors {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String CONTRIBUTORS_URL = "https://drive.google.com/uc?export=view&id=1GAFSqpBucUPP_d5QCEfBD7bwkSCRYU5O";
    private static final Gson GSON = new Gson();
    private static List<String> DEVELOPERS = ImmutableList.of();
    private static List<String> PATRONS = ImmutableList.of();
    private static boolean IS_PATRON_ONLY_BUILD = false;

    public static void getContributors() {
        try {
            URL url = new URL(CONTRIBUTORS_URL);
            Scanner s = new Scanner(url.openStream());
            ImmutableList.Builder devs = ImmutableList.builder();
            ImmutableList.Builder patrons = ImmutableList.builder();
            while (s.hasNextLine()) {
                String line = s.nextLine();
                String[] split = line.split(Pattern.quote("."));
                if (split.length == 2) {
                    if (split[0].equals("dev")) {
                        devs.add((Object)split[1]);
                    }
                    if (!split[0].equals("patron")) continue;
                    patrons.add((Object)split[1]);
                    continue;
                }
                LOGGER.warn("Entry must be of format 'type.username'");
            }
            DEVELOPERS = devs.build();
            PATRONS = patrons.build();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to fetch contributors.txt");
            e.printStackTrace();
        }
    }

    public static boolean isDeveloper(String name) {
        return DEVELOPERS.contains(name);
    }

    public static boolean isPatron(String name) {
        return PATRONS.contains(name);
    }

    public static boolean currentPlayerHasCosmetic() {
        Minecraft mc = Minecraft.m_91087_();
        String name = mc.m_91094_().m_92546_();
        return Contributors.isDeveloper(name) || Contributors.isPatron(name);
    }

    public static Result getAccess(String uuid) {
        if (IS_PATRON_ONLY_BUILD && FMLEnvironment.production) {
            try {
                String line;
                URL url = new URL("https://patronauthenticator-sp4uwbgqwa-uc.a.run.app/validate?mc_uuid=" + uuid);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int status = connection.getResponseCode();
                InputStreamReader streamReader = status >= 300 ? new InputStreamReader(connection.getErrorStream()) : new InputStreamReader(connection.getInputStream());
                BufferedReader in = new BufferedReader(streamReader);
                Result result = Result.NOT_VALIDATED;
                while ((line = in.readLine()) != null) {
                    JsonObject object = (JsonObject)GSON.fromJson(line, JsonObject.class);
                    LOGGER.info("Received: " + object);
                    if (object.has("result")) {
                        if (!GsonHelper.m_13906_((JsonObject)object, (String)"result").equals("validated")) continue;
                        result = Result.VALIDATED;
                        break;
                    }
                    result = Result.ERROR;
                    break;
                }
                in.close();
                connection.disconnect();
                return result;
            }
            catch (Exception e) {
                LOGGER.error("Failed to validate user", (Throwable)e);
                return Result.ERROR;
            }
        }
        return Result.NO_RESTRICTIONS;
    }

    public static enum Result {
        VALIDATED(true),
        NO_RESTRICTIONS(true),
        NOT_VALIDATED(false),
        ERROR(false);

        private boolean canLaunchGame;

        private Result(boolean canLaunchGame) {
            this.canLaunchGame = canLaunchGame;
        }

        public boolean canLaunchGame() {
            return this.canLaunchGame;
        }
    }
}

