/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import nonamecrackers2.witherstormmod.client.util.SkyColorSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WitherStormResourceConfigManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String COLOR_CONFIG = "colors";
    private static final Gson GSON = new GsonBuilder().create();
    public static final WitherStormResourceConfigManager INSTANCE = new WitherStormResourceConfigManager();
    private Color tractorBeamColor;
    private Color tractorBeamNightColor;
    private Color nightShineColor;
    private Int2ObjectMap<SkyColorSet> skyColors = new Int2ObjectOpenHashMap();

    public WitherStormResourceConfigManager() {
        super(GSON, "config");
        this.defaultConfig();
    }

    private void defaultConfig() {
        this.populateSkyColors(SkyColorSet.DEFAULT_SKY_COLORS);
        this.tractorBeamColor = new Color(128, 77, 204);
        this.tractorBeamNightColor = new Color(128, 77, 204);
        this.nightShineColor = new Color(150, 59, 255, 75);
    }

    protected void apply(Map<ResourceLocation, JsonElement> files, ResourceManager manager, ProfilerFiller profiler) {
        try {
            block8: for (Map.Entry<ResourceLocation, JsonElement> entry : files.entrySet()) {
                JsonObject obj = entry.getValue().getAsJsonObject();
                switch (entry.getKey().m_135815_()) {
                    case "colors": {
                        if (obj.has("tractor_beams")) {
                            this.tractorBeamColor = WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)obj, (String)"tractor_beams"));
                        }
                        this.tractorBeamNightColor = obj.has("tractor_beams_night") ? WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)obj, (String)"tractor_beams_night")) : this.tractorBeamColor;
                        if (obj.has("night_shine")) {
                            this.nightShineColor = WitherStormResourceConfigManager.colorFromJsonAlpha(GsonHelper.m_13930_((JsonObject)obj, (String)"night_shine"));
                        }
                        if (obj.has("sky_colors")) {
                            JsonObject phases = GsonHelper.m_13930_((JsonObject)obj, (String)"sky_colors");
                            for (int i = 5; i <= 7; ++i) {
                                JsonObject phase = GsonHelper.m_13930_((JsonObject)phases, (String)String.valueOf(i));
                                this.skyColors.put(i, (Object)WitherStormResourceConfigManager.getColorSetFromJson(phase));
                            }
                            continue block8;
                        }
                        this.populateSkyColors(WitherStormResourceConfigManager.getColorSetFromJson(obj));
                    }
                }
            }
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Failed to read 'colors.json'", (Throwable)e);
        }
        if (files.isEmpty()) {
            this.defaultConfig();
        }
    }

    private void populateSkyColors(SkyColorSet set) {
        for (int i = 5; i <= 7; ++i) {
            this.skyColors.put(i, (Object)set);
        }
    }

    public Color getTractorBeamColor() {
        return this.tractorBeamColor;
    }

    public Color getTractorBeamNightColor() {
        return this.tractorBeamNightColor;
    }

    public Color getNightShineColor() {
        return this.nightShineColor;
    }

    public SkyColorSet getSkyColorsForPhase(int phase) {
        return (SkyColorSet)this.skyColors.get(phase);
    }

    private static Color colorFromJsonNoAlpha(JsonObject object) {
        int r = GsonHelper.m_13927_((JsonObject)object, (String)"red");
        int g = GsonHelper.m_13927_((JsonObject)object, (String)"green");
        int b = GsonHelper.m_13927_((JsonObject)object, (String)"blue");
        return new Color(r, g, b);
    }

    private static Color colorFromJsonAlpha(JsonObject object) {
        int r = GsonHelper.m_13927_((JsonObject)object, (String)"red");
        int g = GsonHelper.m_13927_((JsonObject)object, (String)"green");
        int b = GsonHelper.m_13927_((JsonObject)object, (String)"blue");
        int a = 255;
        if (object.has("alpha")) {
            a = GsonHelper.m_13927_((JsonObject)object, (String)"alpha");
        }
        return new Color(r, g, b, a);
    }

    private static SkyColorSet getColorSetFromJson(JsonObject object) {
        SkyColorSet.Builder builder = SkyColorSet.builder();
        if (object.has("night") && !object.has("day") || !object.has("night") && object.has("day")) {
            throw new JsonSyntaxException("Must contain both 'day' and 'night' entries, not just one");
        }
        if (object.has("night") && object.has("day")) {
            JsonObject night = GsonHelper.m_13930_((JsonObject)object, (String)"night");
            JsonObject day = GsonHelper.m_13930_((JsonObject)object, (String)"day");
            if (day.has("sky_darken")) {
                builder.setSkyColor(WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)day, (String)"sky_darken")));
            }
            if (day.has("sky_darken_clouds")) {
                builder.setCloudColor(WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)day, (String)"sky_darken_clouds")));
            }
            if (day.has("sky_darken_fog")) {
                builder.setFogColor(WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)day, (String)"sky_darken_fog")));
            }
            if (night.has("sky_darken")) {
                builder.setNightSkyColor(WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)night, (String)"sky_darken")));
            }
            if (night.has("sky_darken_clouds")) {
                builder.setNightCloudColor(WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)night, (String)"sky_darken_clouds")));
            }
            if (night.has("sky_darken_fog")) {
                builder.setNightFogColor(WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)night, (String)"sky_darken_fog")));
            }
        } else {
            if (object.has("sky_darken")) {
                builder.setSkyColor(WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)object, (String)"sky_darken")));
            }
            if (object.has("sky_darken_clouds")) {
                builder.setCloudColor(WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)object, (String)"sky_darken_clouds")));
            }
            if (object.has("sky_darken_fog")) {
                builder.setFogColor(WitherStormResourceConfigManager.colorFromJsonNoAlpha(GsonHelper.m_13930_((JsonObject)object, (String)"sky_darken_fog")));
            }
        }
        return builder.build();
    }
}

