/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.RandomSource;
import nonamecrackers2.witherstormmod.client.instancing.RenderBufferer;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.HeadModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.TentacleModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.mass.MassModel;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.util.WitherStormModCompat;
import nonamecrackers2.witherstormmod.mixin.IMixinModelPart;

public abstract class AbstractWitherStormModel<T extends WitherStormEntity>
extends EntityModel<T> {
    public static final String MASS = "mass";
    public static final String LOWRESMASS = "lowResMass";
    public static final String TENTACLES = "tentacles";
    public static final String HEADSROOT = "heads";
    public static final String[] HEADS = new String[]{"head0", "head1", "head2"};
    protected MassModel body;
    protected MassModel lowResBody;
    protected TentacleModel[] tentacles = new TentacleModel[0];
    public final Int2ObjectMap<HeadModel<T>> heads = new Int2ObjectOpenHashMap();
    public boolean otherHeadsDisabled;
    protected boolean renderHeadsOnly;
    protected int renderHeadOnly;
    public boolean shouldRenderAdditional = true;
    public boolean mirrored;
    public MultiBufferSource buffer;
    public RenderType massRenderType;
    public RenderType massRenderTypeEmissive;
    public T entity;
    public final float headScale;

    protected AbstractWitherStormModel(ModelPart root, float headScale) {
        this.body = new MassModel(root.m_171324_(MASS));
        this.lowResBody = new MassModel(root.m_171324_(LOWRESMASS));
        this.getTentacles(root.m_171324_(TENTACLES));
        this.getHeads(root.m_171324_(HEADSROOT), headScale);
        this.headScale = headScale;
    }

    protected abstract void getTentacles(ModelPart var1);

    protected abstract void getHeads(ModelPart var1, float var2);

    protected static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_(MASS, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_(LOWRESMASS, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_(TENTACLES, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_(HEADSROOT, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return mesh;
    }

    public void setupAnim(T entity, float p_225597_2_, float p_225597_3_, float p_225597_4_, float p_225597_5_, float p_225597_6_) {
        for (Int2ObjectMap.Entry entry : this.heads.int2ObjectEntrySet()) {
            ((HeadModel)entry.getValue()).setupAnim(entity, p_225597_2_, p_225597_3_, p_225597_4_, p_225597_5_, p_225597_6_, entry.getIntKey());
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer consumer, int packedLight, int overlayTexture, float p_225598_5_, float p_225598_6_, float p_225598_7_, float alpha) {
        stack.m_85836_();
        for (Int2ObjectMap.Entry entry : this.heads.int2ObjectEntrySet()) {
            int overlay;
            boolean flag = true;
            if (this.renderHeadsOnly && this.renderHeadOnly >= 0) {
                flag = false;
                if (this.renderHeadOnly == entry.getIntKey()) {
                    flag = true;
                }
            }
            if (!flag) continue;
            HeadModel head = (HeadModel)entry.getValue();
            stack.m_85836_();
            stack.m_85841_(head.scale, head.scale, head.scale);
            int hurtDir = ((WitherStormEntity)this.entity).getHeadHurtDuration(entry.getIntKey());
            int n = overlay = hurtDir > 0 ? 3 : overlayTexture;
            if (!this.otherHeadsDisabled || this.otherHeadsDisabled && entry.getIntKey() == 0) {
                head.head.m_104306_(stack, consumer, packedLight, overlay, 1.0f, 1.0f, 1.0f, alpha);
            }
            stack.m_85849_();
        }
        stack.m_85841_(this.mirrored ? -1.0f : 1.0f, 1.0f, 1.0f);
        if (!this.renderHeadsOnly) {
            for (int i = 0; i < this.tentacles.length; ++i) {
                stack.m_85836_();
                this.scaleTentacles(stack, this.tentacles[i]);
                this.tentacles[i].tentacle.m_104306_(stack, consumer, packedLight, overlayTexture, 1.0f, 1.0f, 1.0f, alpha);
                stack.m_85849_();
            }
            stack.m_85836_();
            this.scaleMass(stack);
            boolean flag = RenderBufferer.shouldUse();
            if (flag && this.entity.m_21224_() && WitherStormModCompat.isShadersRunning()) {
                flag = false;
            }
            RenderBufferer.buildAndOrRender(this + ", " + this.massRenderType + ", " + this.lowResModelsEnabled(), this.massRenderType, () -> false, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7) -> ((ModelPart)this.getMassModel()).m_104306_(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7), stack, packedLight, overlayTexture, 1.0f, 1.0f, 1.0f, alpha, flag);
            if (flag) {
                RenderBufferer.pushNoFog();
                RenderBufferer.buildAndOrRender(this + ", " + this.massRenderTypeEmissive + ", " + this.lowResModelsEnabled() + ", emissive", this.massRenderTypeEmissive, () -> false, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7) -> ((ModelPart)this.getMassModel()).m_104306_(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7), stack, packedLight, overlayTexture, 1.0f, 1.0f, 1.0f, alpha, true);
            }
            if (this.shouldRenderAdditional) {
                this.renderAdditional(stack, this.buffer, packedLight, overlayTexture, p_225598_5_, p_225598_6_, p_225598_7_, alpha);
            }
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    public void prepareMobModel(T entity, float p_212843_2_, float p_212843_3_, float partialTicks) {
        for (Int2ObjectMap.Entry entry : this.heads.int2ObjectEntrySet()) {
            ((HeadModel)entry.getValue()).prepareMobModel(entity, p_212843_2_, p_212843_3_, partialTicks, entry.getIntKey());
        }
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].prepareModel(((WitherStormEntity)entity).getTentacleAnimation(partialTicks), p_212843_2_, p_212843_3_, partialTicks);
        }
    }

    public void setMirrored(boolean mirrored) {
        this.mirrored = mirrored;
    }

    public void pushHeadsOnly() {
        this.renderHeadsOnly = true;
    }

    public void renderHeadOnly(int head) {
        this.pushHeadsOnly();
        this.renderHeadOnly = head;
    }

    public void popHeadsOnly() {
        this.renderHeadsOnly = false;
        this.renderHeadOnly = -1;
    }

    public ModelPart getMassModel() {
        return this.getMass().getMass();
    }

    public MassModel getMass() {
        if (this.lowResMassPresent()) {
            return this.lowResModelsEnabled() ? this.lowResBody : this.body;
        }
        return this.body;
    }

    public boolean lowResModelsEnabled() {
        return this.lowResMassPresent() && ((Boolean)WitherStormModConfig.CLIENT.lowResModels.get() != false || (Boolean)WitherStormModConfig.CLIENT.witherStormLOD.get() != false && ((WitherStormEntity)this.entity).isOnDistantRenderer());
    }

    public void scaleMass(PoseStack stack) {
        stack.m_85841_(10.0f, 10.0f, 10.0f);
    }

    public void scaleTentacles(PoseStack stack, TentacleModel model) {
        stack.m_85841_(model.scale, model.scale, model.scale);
    }

    public boolean massPresent() {
        return this.body != null;
    }

    public boolean lowResMassPresent() {
        return !this.lowResBody.getMass().m_171326_();
    }

    public ModelPart getRandomPart(RandomSource random) {
        ModelPart potential;
        ModelPart model = this.getMassModel();
        ArrayList<ModelPart> children = new ArrayList<ModelPart>(((IMixinModelPart)model).getChildren().values());
        if (!children.isEmpty() && !(potential = (ModelPart)children.get(random.m_188503_(children.size()))).m_171326_()) {
            model = potential;
        }
        return model;
    }

    public void renderAdditional(PoseStack stack, MultiBufferSource buffer, int packedLight, int overlayCoords, float r, float g, float b, float a) {
    }
}

