/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.renderer.entity.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import nonamecrackers2.witherstormmod.client.renderer.entity.AbstractWitherStormRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.AbstractWitherStormModel;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import org.joml.Vector3f;

public class WitherStormPulseLayer<T extends WitherStormEntity, M extends AbstractWitherStormModel<T>>
extends RenderLayer<T, M> {
    private final AbstractWitherStormRenderer<T, M> renderer;

    public WitherStormPulseLayer(AbstractWitherStormRenderer<T, M> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, T entity, float p_225628_5_, float p_225628_6_, float partialTicks, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        AbstractWitherStormModel model = (AbstractWitherStormModel)this.m_117386_();
        if (((Boolean)WitherStormModConfig.CLIENT.renderPulse.get()).booleanValue() && ((WitherStormEntity)entity).isBeingTornApart() && model.getMass() != null && !entity.m_21224_()) {
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.renderer.getPulseTextureLocation(entity)));
            for (int k = 0; k < this.renderer.getPulseAmount(entity); ++k) {
                float tick = (float)(((WitherStormEntity)entity).f_19797_ + k) + partialTicks;
                long seed = (long)(tick / 20.0f);
                RandomSource random = RandomSource.m_216335_((long)(seed + (long)((double)k * Math.PI)));
                ModelPart part = model.getRandomPart(random);
                Vector3f pos = WitherStormPulseLayer.getRandomPoint(part.m_233558_(random), random);
                ModelPart mirror = new ModelPart(CubeListBuilder.m_171558_().m_171514_(random.m_188503_(28), Math.max(16, random.m_188503_(30))).m_171488_(pos.x(), pos.y(), pos.z(), 1.0f, 1.0f, 1.0f, new CubeDeformation(0.01f)).m_171557_().stream().map(def -> def.m_171455_(32, 32)).collect(Collectors.toList()), (Map)Maps.newHashMap());
                ModelPart mass = model.getMassModel();
                mirror.f_104200_ = mass.f_104200_;
                mirror.f_104201_ = mass.f_104201_;
                mirror.f_104202_ = mass.f_104202_;
                if (part != mass) {
                    mirror.f_104200_ += part.f_104200_;
                    mirror.f_104201_ += part.f_104201_;
                    mirror.f_104202_ += part.f_104202_;
                }
                mirror.f_104203_ = part.f_104203_;
                mirror.f_104204_ = part.f_104204_;
                mirror.f_104205_ = part.f_104205_;
                stack.m_85836_();
                stack.m_85841_(model.mirrored ? -1.0f : 1.0f, 1.0f, 1.0f);
                model.scaleMass(stack);
                float fade = 1.0f - tick % 20.0f * 0.1f / 2.0f;
                int overlayCoords = LivingEntityRenderer.m_115338_(entity, (float)0.0f);
                mirror.m_104306_(stack, builder, packedLight, overlayCoords, 1.0f, 1.0f, 1.0f, fade);
                stack.m_85849_();
            }
        }
    }

    public static Vector3f getRandomPoint(ModelPart.Cube box, RandomSource random) {
        boolean flag;
        Vector3f pos = new Vector3f(box.f_104335_, box.f_104336_, box.f_104337_);
        float xDif = box.f_104338_ - pos.x();
        float yDif = box.f_104339_ - pos.y();
        float zDif = box.f_104340_ - pos.z();
        boolean bl = flag = xDif > 0.0f && yDif > 0.0f && zDif > 0.0f;
        if (flag) {
            Direction direction = Direction.m_235672_((RandomSource)random);
            if (direction.m_122434_().equals((Object)Direction.Axis.X)) {
                pos.set(direction.equals((Object)Direction.WEST) ? box.f_104335_ : box.f_104338_ - 1.0f, pos.y, pos.z);
                pos.set(pos.x, pos.y() + (float)random.m_188503_((int)yDif), pos.z);
                pos.set(pos.x, pos.y, pos.z() + (float)random.m_188503_((int)zDif));
            } else if (direction.m_122434_().equals((Object)Direction.Axis.Y)) {
                pos.set(pos.x() + (float)random.m_188503_((int)xDif), pos.y, pos.z);
                pos.set(pos.x, direction.equals((Object)Direction.DOWN) ? box.f_104336_ : box.f_104339_ - 1.0f, pos.z);
                pos.set(pos.x, pos.y, pos.z() + (float)random.m_188503_((int)zDif));
            } else if (direction.m_122434_().equals((Object)Direction.Axis.Z)) {
                pos.set(pos.x() + (float)random.m_188503_((int)xDif), pos.y, pos.z);
                pos.set(pos.x, pos.y() + (float)random.m_188503_((int)yDif), pos.z);
                pos.set(pos.x, pos.y, direction.equals((Object)Direction.NORTH) ? box.f_104337_ : box.f_104340_ - 1.0f);
            }
        }
        return pos;
    }
}

