/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.awt.Color;
import java.time.temporal.ChronoField;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.witherstormmod.WitherStormMod;
import nonamecrackers2.witherstormmod.client.instancing.RenderBufferer;
import nonamecrackers2.witherstormmod.client.renderer.entity.layer.WitherStormEmissiveDecalLayer;
import nonamecrackers2.witherstormmod.client.renderer.entity.layer.WitherStormExplodingLayer;
import nonamecrackers2.witherstormmod.client.renderer.entity.layer.WitherStormPulseLayer;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.AbstractWitherStormModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.HeadModel;
import nonamecrackers2.witherstormmod.client.resources.WitherStormResourceConfigManager;
import nonamecrackers2.witherstormmod.client.util.UtilRenderTypes;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormSegmentEntity;
import nonamecrackers2.witherstormmod.common.util.DebrisCluster;
import nonamecrackers2.witherstormmod.common.util.DebrisRingSettings;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public abstract class AbstractWitherStormRenderer<T extends WitherStormEntity, M extends AbstractWitherStormModel<T>>
extends LivingEntityRenderer<T, M> {
    public static final ResourceLocation WITHER_STORM_INVULNERABLE_LOCATION = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_invulnerable.png");
    public static final ResourceLocation WITHER_STORM_LOCATION = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm.png");
    public static final ResourceLocation WITHER_STORM_EXPLODING_LOCATION = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_exploding.png");
    public static final ResourceLocation EMISSIVE_DECAL = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_emissive_decal.png");
    public static final ResourceLocation EMISSIVE_DECAL_HURT = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_emissive_decal_hurt.png");
    public static final ResourceLocation PULSE = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/wither_storm_pulse.png");
    public static final ResourceLocation DEBRIS_RING = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/debris.png");
    public static final ResourceLocation SHINE = new ResourceLocation("witherstormmod", "textures/entity/wither_storm/shine.png");
    public static final ResourceLocation PINK_WITHER_STORM_LOCATION = new ResourceLocation("witherstormmod", "textures/misc/pink_wither_storm.png");

    public AbstractWitherStormRenderer(EntityRendererProvider.Context context, M model) {
        super(context, model, 1.0f);
        this.m_115326_(new WitherStormExplodingLayer(this));
        this.m_115326_(new WitherStormEmissiveDecalLayer(this));
        this.m_115326_(new WitherStormPulseLayer(this));
    }

    public void updateModel(T entity) {
        this.f_115290_ = this.getModel(entity);
        ((AbstractWitherStormModel)this.f_115290_).setMirrored(((WitherStormEntity)entity).isMirrored());
    }

    public abstract M getModel(T var1);

    protected int getBlockLightLevel(T entity, BlockPos pos) {
        return Math.max(0, (int)((100.0f - ((WitherStormEntity)entity).getFadeAnimation()) / 4.0f - 10.0f));
    }

    public void render(T entity, float p_225623_2_, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        this.updateModel(entity);
        ((AbstractWitherStormModel)this.f_115290_).buffer = buffer;
        ((AbstractWitherStormModel)this.f_115290_).shouldRenderAdditional = !entity.m_21224_();
        ((AbstractWitherStormModel)this.f_115290_).entity = entity;
        ((AbstractWitherStormModel)this.f_115290_).otherHeadsDisabled = ((WitherStormEntity)entity).areOtherHeadsDisabled();
        ((AbstractWitherStormModel)this.f_115290_).massRenderTypeEmissive = UtilRenderTypes.emissiveNoCull(this.getEmissiveDecalLocation(entity));
        AbstractWitherStormRenderer.renderDebrisClusters(this.getTextureLocation(entity), entity, stack, buffer, partialTicks, packedLight);
        super.m_7392_(entity, p_225623_2_, partialTicks, stack, buffer, packedLight);
    }

    public void renderTractorBeams(T entity, PoseStack stack, MultiBufferSource buffer, float partialTicks, int packedLight) {
        if (!(!((Boolean)WitherStormModConfig.CLIENT.renderTractorBeams.get()).booleanValue() || entity.m_20096_() && ((WitherStormEntity)entity).isPlayingDead())) {
            for (Int2ObjectMap.Entry entry : ((AbstractWitherStormModel)this.m_7200_()).heads.int2ObjectEntrySet()) {
                HeadModel head = (HeadModel)entry.getValue();
                stack.m_85836_();
                if (head.shouldRenderTractorBeam(entity, entry.getIntKey())) {
                    double cutoff;
                    float b;
                    float g;
                    float r;
                    WitherStormSegmentEntity segment;
                    WitherStormEntity parent;
                    boolean rainbow;
                    Minecraft mc = Minecraft.m_91087_();
                    Vec3 pos = mc.f_91063_.m_109153_().m_90583_();
                    double distance = pos.m_82554_(entity.m_20182_());
                    float renderDistance = (float)((Integer)mc.f_91066_.m_231984_().m_231551_()).intValue() / 16.0f;
                    float distLerp = AbstractWitherStormRenderer.getDistanceLerp(distance, renderDistance);
                    float nightLerp = AbstractWitherStormRenderer.getNightTimeLerp(entity.m_9236_(), partialTicks);
                    float alpha = distLerp * (1.0f - nightLerp);
                    int month = WitherStormMod.DATE.get(ChronoField.MONTH_OF_YEAR);
                    int day = WitherStormMod.DATE.get(ChronoField.DAY_OF_MONTH);
                    boolean flag = month == 10 && day == 31;
                    boolean bl = rainbow = entity.m_8077_() && entity.m_7755_().getString().equals("jeb_");
                    if (!rainbow && entity instanceof WitherStormSegmentEntity && (parent = (segment = (WitherStormSegmentEntity)entity).getParent()) != null && parent.m_8077_() && parent.m_7755_().getString().equals("jeb_")) {
                        rainbow = true;
                    }
                    if (rainbow) {
                        float[] rainbowColor = AbstractWitherStormRenderer.getRainbowColor(entity, entry.getIntKey(), partialTicks);
                        r = rainbowColor[0];
                        g = rainbowColor[1];
                        b = rainbowColor[2];
                    } else {
                        Color color = WitherStormResourceConfigManager.INSTANCE.getTractorBeamColor();
                        Color night = WitherStormResourceConfigManager.INSTANCE.getTractorBeamNightColor();
                        r = flag ? 0.5294118f : Mth.m_14179_((float)nightLerp, (float)color.getRed(), (float)night.getRed()) / 255.0f;
                        g = flag ? 0.32156864f : Mth.m_14179_((float)nightLerp, (float)color.getGreen(), (float)night.getGreen()) / 255.0f;
                        float f = b = flag ? 0.10980392f : Mth.m_14179_((float)nightLerp, (float)color.getBlue(), (float)night.getBlue()) / 255.0f;
                    }
                    if (((Boolean)WitherStormModConfig.CLIENT.distantFog.get()).booleanValue()) {
                        float rDelta = 0.3f - r;
                        float gDelta = 0.3f - g;
                        float bDelta = 0.3f - b;
                        r += rDelta * alpha;
                        g += gDelta * alpha;
                        b += bDelta * alpha;
                    }
                    if ((cutoff = ((WitherStormEntity)entity).getTractorBeamCutoffDistance(entry.getIntKey())) != -1.0) {
                        cutoff = cutoff / (double)((AbstractWitherStormModel)this.f_115290_).headScale + 10.0;
                    }
                    head.renderTractorBeam(entity, stack, buffer, packedLight, r, g, b, 0.5f, partialTicks, cutoff, 0.5f * (1.0f - distLerp));
                }
                stack.m_85849_();
            }
        }
    }

    private static float[] getRainbowColor(WitherStormEntity entity, int offset, float partialTicks) {
        int tickCount = entity.f_19797_ / 25 + entity.m_19879_() + offset;
        int allDyeColors = DyeColor.values().length;
        int k = tickCount % allDyeColors;
        int l = (tickCount + 1) % allDyeColors;
        float f3 = ((float)(entity.f_19797_ % 25) + partialTicks) / 25.0f;
        float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
        float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
        float r = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
        float g = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
        float b = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
        return new float[]{r, g, b};
    }

    public void prepareHeadAnimsForTractorBeams(T entity, float partialTicks) {
        if (!(!((Boolean)WitherStormModConfig.CLIENT.renderTractorBeams.get()).booleanValue() || entity.m_20096_() && ((WitherStormEntity)entity).isPlayingDead())) {
            for (Int2ObjectMap.Entry entry : ((AbstractWitherStormModel)this.m_7200_()).heads.int2ObjectEntrySet()) {
                boolean shouldSit;
                HeadModel head = (HeadModel)entry.getValue();
                float f8 = 0.0f;
                float f5 = 0.0f;
                boolean bl = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
                if (!shouldSit && entity.m_6084_()) {
                    f8 = ((WitherStormEntity)entity).f_267362_.m_267711_(partialTicks);
                    f5 = ((WitherStormEntity)entity).f_267362_.m_267590_(partialTicks);
                }
                float f7 = this.m_6930_((LivingEntity)entity, partialTicks);
                float f = Mth.m_14189_((float)partialTicks, (float)((WitherStormEntity)entity).f_20884_, (float)((WitherStormEntity)entity).f_20883_);
                float f1 = Mth.m_14189_((float)partialTicks, (float)((WitherStormEntity)entity).f_20886_, (float)((WitherStormEntity)entity).f_20885_);
                float f2 = f1 - f;
                if (shouldSit && entity.m_20202_() instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity.m_20202_();
                    f = Mth.m_14189_((float)partialTicks, (float)living.f_20884_, (float)living.f_20883_);
                    f2 = f1 - f;
                    float f3 = Mth.m_14177_((float)f2);
                    if (f3 < -85.0f) {
                        f3 = -85.0f;
                    }
                    if (f3 >= 85.0f) {
                        f3 = 85.0f;
                    }
                    f = f1 - f3;
                    if (f3 * f3 > 2500.0f) {
                        f += f3 * 0.2f;
                    }
                    f2 = f1 - f;
                }
                float f6 = Mth.m_14179_((float)partialTicks, (float)((WitherStormEntity)entity).f_19860_, (float)entity.m_146909_());
                head.prepareMobModel(entity, f5, f8, partialTicks, entry.getIntKey());
                head.setupAnim(entity, f5, f8, f7, f2, f6, entry.getIntKey());
            }
        }
    }

    public boolean shouldRender(T entity, Frustum clipping, double x, double y, double z) {
        if (!entity.m_6000_(x, y, z)) {
            return false;
        }
        if (!((WitherStormEntity)entity).isOnDistantRenderer() && ((WitherStormEntity)entity).f_19811_) {
            return true;
        }
        AABB box = ((WitherStormEntity)entity).m_6921_().m_82400_(0.5);
        if (box.m_82392_() || box.m_82309_() == 0.0) {
            box = new AABB(entity.m_20185_() - 2.0, entity.m_20186_() - 2.0, entity.m_20189_() - 2.0, entity.m_20185_() + 2.0, entity.m_20186_() + 2.0, entity.m_20189_() + 2.0);
        }
        return clipping.m_113029_(box);
    }

    protected boolean shouldShowName(T entity) {
        return super.m_6512_(entity) && (entity.m_6052_() || entity.m_8077_() && entity == this.f_114476_.f_114359_);
    }

    public static void renderDebrisRings(WitherStormEntity entity, PoseStack stack, MultiBufferSource buffer, float partialTicks, int packedLightIn) {
        if (((Boolean)WitherStormModConfig.CLIENT.renderDebrisRings.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            Vec3 pos = mc.f_91063_.m_109153_().m_90583_();
            double distance = pos.m_82554_(entity.m_20182_());
            float baseAlpha = Mth.m_14036_((float)((float)(400.0 - distance) * 0.005f), (float)0.2f, (float)0.5f);
            VertexConsumer debrisBuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)DEBRIS_RING));
            for (DebrisRingSettings settings : entity.getDebrisRings()) {
                if (!(settings.alpha() > 0.0f) || entity.getPhase() < settings.getPhaseRequirement()) continue;
                stack.m_85836_();
                int segments = settings.getSegments();
                float bottomRadius = settings.getBottomRadius();
                float topRadius = settings.getTopRadius();
                float y = settings.getY();
                float height = settings.getHeight();
                float alpha = settings.alpha() * baseAlpha;
                PoseStack.Pose entry = stack.m_85850_();
                Matrix4f matrix4f = entry.m_252922_();
                Matrix3f matrix3f = entry.m_252943_();
                float u = 0.0f;
                float v = 0.0f;
                float uMax = 1.0f;
                float vMax = 1.0f;
                float tickCount = ((float)entity.f_19797_ + partialTicks) * (settings.getSpeedModifier() * (settings.clockwise() ? 1.0f : -1.0f));
                for (int i = 0; i < segments; ++i) {
                    float theta = (float)(Math.PI * 2 / (double)segments);
                    float angle = theta * (float)i + tickCount;
                    float x = Mth.m_14089_((float)angle);
                    float z = Mth.m_14031_((float)angle);
                    float angle2 = theta * (float)(i + 1) + tickCount;
                    float x2 = Mth.m_14089_((float)angle2);
                    float z2 = Mth.m_14031_((float)angle2);
                    debrisBuilder.m_252986_(matrix4f, x * bottomRadius, y, z * bottomRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                    debrisBuilder.m_252986_(matrix4f, x * topRadius, height, z * topRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                    debrisBuilder.m_252986_(matrix4f, x2 * topRadius, height, z2 * topRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                    debrisBuilder.m_252986_(matrix4f, x2 * bottomRadius, y, z2 * bottomRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                    debrisBuilder.m_252986_(matrix4f, x2 * bottomRadius, y, z2 * bottomRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(uMax, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                    debrisBuilder.m_252986_(matrix4f, x2 * topRadius, height, z2 * topRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(uMax, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                    debrisBuilder.m_252986_(matrix4f, x * topRadius, height, z * topRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                    debrisBuilder.m_252986_(matrix4f, x * bottomRadius, y, z * bottomRadius).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                }
                stack.m_85849_();
            }
        }
    }

    public static void renderDebrisClusters(ResourceLocation tex, WitherStormEntity entity, PoseStack stack, MultiBufferSource bufferSource, float partialTicks, int packedLight) {
        if (((Boolean)WitherStormModConfig.CLIENT.renderDebrisCloud.get()).booleanValue() && (!((Boolean)WitherStormModConfig.CLIENT.renderDistantDebris.get()).booleanValue() && !entity.isOnDistantRenderer() || ((Boolean)WitherStormModConfig.CLIENT.renderDistantDebris.get()).booleanValue())) {
            for (DebrisCluster cluster : entity.getDebrisClusters()) {
                float vMax;
                float uMax;
                float v;
                float u;
                boolean flag;
                if (cluster.isDisabled() || cluster.getRenderPhase() > entity.getPhase()) continue;
                float orbitalAngle = cluster.getOrbitalAngle(partialTicks);
                stack.m_85836_();
                stack.m_85837_(0.0, (double)cluster.getVerticalOffset(), 0.0);
                stack.m_252781_(Axis.f_252436_.m_252977_(orbitalAngle));
                stack.m_85837_((double)cluster.getRadiusFromCenter(), 0.0, 0.0);
                stack.m_252781_(Axis.f_252529_.m_252977_(cluster.getXRot(partialTicks)));
                stack.m_252781_(Axis.f_252436_.m_252977_(cluster.getYRot(partialTicks)));
                boolean bl = flag = cluster.isGlowing() && entity.getPhase() > 5;
                if (flag) {
                    u = 0.3125f;
                    v = 0.3125f;
                    uMax = 0.375f;
                    vMax = 0.375f;
                } else {
                    u = 0.9f;
                    v = 0.8f;
                    uMax = 1.0f;
                    vMax = 0.9f;
                }
                if (flag) {
                    RenderBufferer.pushNoFog();
                }
                RenderBufferer.buildAndOrRender(cluster.toString() + flag, RenderType.m_110458_((ResourceLocation)tex), (bstack, consumer, bpackedLight, boverlayTexture, br, bg, bb, ba) -> AbstractWitherStormRenderer.renderPieces(cluster, bstack, consumer, br, bg, bb, ba, boverlayTexture, bpackedLight, u, v, uMax, vMax), stack, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                if (flag) {
                    RenderBufferer.pushNoFog();
                    RenderBufferer.buildAndOrRender(cluster.toString() + ", " + flag + ", emissive", RenderType.m_110488_((ResourceLocation)tex), (bstack, consumer, bpackedLight, boverlayTexture, br, bg, bb, ba) -> AbstractWitherStormRenderer.renderPieces(cluster, bstack, consumer, br, bg, bb, ba, boverlayTexture, bpackedLight, u, v, uMax, vMax), stack, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                stack.m_85849_();
            }
        }
    }

    private static void renderPieces(DebrisCluster cluster, PoseStack bstack, VertexConsumer consumer, float br, float bg, float bb, float ba, int boverlayTexture, int bpackedLight, float u, float v, float uMax, float vMax) {
        for (DebrisCluster.Piece piece : cluster.getPieces()) {
            bstack.m_85836_();
            bstack.m_252880_(piece.x(), piece.y(), piece.z());
            Matrix4f matrix4f = bstack.m_85850_().m_252922_();
            Matrix3f matrix3f = bstack.m_85850_().m_252943_();
            float startSize = piece.size();
            float endSize = -piece.size();
            consumer.m_252986_(matrix4f, startSize, startSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(u, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, endSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(u, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, endSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, startSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, startSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(u, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, endSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(u, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, endSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, startSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, startSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(u, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, endSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(u, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, endSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, startSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, startSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(u, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, endSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(u, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, endSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, startSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, startSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(u, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, startSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(u, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, startSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, startSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, endSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(u, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, endSize, startSize).m_85950_(br, bg, bb, ba).m_7421_(u, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, endSize, endSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, vMax).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, startSize, endSize, endSize).m_85950_(br, bg, bb, ba).m_7421_(uMax, v).m_86008_(boverlayTexture).m_85969_(bpackedLight).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            bstack.m_85849_();
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        boolean flag = WitherStormMod.isAprilFools() && (Boolean)WitherStormModConfig.CLIENT.aprilFools.get() != false;
        int i = ((WitherStormEntity)entity).getInvulnerableTicks();
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? WITHER_STORM_INVULNERABLE_LOCATION : (flag ? PINK_WITHER_STORM_LOCATION : WITHER_STORM_LOCATION);
    }

    public ResourceLocation getExplodingTextureLocation(T entity) {
        return WITHER_STORM_EXPLODING_LOCATION;
    }

    public ResourceLocation getPulseTextureLocation(T entity) {
        return PULSE;
    }

    public ResourceLocation getEmissiveDecalLocation(T entity) {
        return EMISSIVE_DECAL;
    }

    public ResourceLocation getHurtEmissiveDecalLocation(T entity) {
        return EMISSIVE_DECAL_HURT;
    }

    protected void scale(T entity, PoseStack stack, float p_225620_3_) {
        float f = 2.0f;
        int i = ((WitherStormEntity)entity).getInvulnerableTicks();
        int j = Math.max(0, i - 750);
        if (j > 0) {
            f -= ((float)j - p_225620_3_) / (float)Math.max(0, ((WitherStormEntity)entity).getStartingInvulnerableTicks() - 750) * 0.5f;
        }
        stack.m_85841_(f, f, f);
    }

    protected void setupRotations(T entity, PoseStack stack, float p_225621_3_, float yBodyRot, float partialTicks) {
        super.m_7523_(entity, stack, p_225621_3_, yBodyRot, partialTicks);
        Pose pose = entity.m_20089_();
        if (pose != Pose.SLEEPING) {
            float xBodyRot = Mth.m_14189_((float)partialTicks, (float)((WitherStormEntity)entity).xBodyRotO, (float)((WitherStormEntity)entity).xBodyRot);
            stack.m_252781_(Axis.f_252529_.m_252977_(xBodyRot));
        }
    }

    public int getPulseAmount(T entity) {
        return (int)((float)((WitherStormEntity)entity).getPhase() * 15.0f / 2.0f * ((Boolean)WitherStormModConfig.CLIENT.lowResModels.get() != false ? 3.0f : 1.0f));
    }

    protected RenderType getRenderType(T entity, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        RenderType type;
        if (((WitherStormEntity)entity).getDeathTime() > 0) {
            return null;
        }
        ((AbstractWitherStormModel)this.f_115290_).massRenderType = type = super.m_7225_(entity, p_230496_2_, p_230496_3_, p_230496_4_);
        return type;
    }

    public static void renderExtra(WitherStormEntity storm, EntityRenderDispatcher manager, PoseStack stack, MultiBufferSource buffer, float partialTicks) {
        EntityRenderer raw = manager.m_114382_((Entity)storm);
        int packedLight = manager.m_114394_((Entity)storm, partialTicks);
        if (raw instanceof AbstractWitherStormRenderer) {
            AbstractWitherStormRenderer renderer = (AbstractWitherStormRenderer)raw;
            renderer.updateModel(storm);
        }
        AbstractWitherStormRenderer.renderDebrisRings(storm, stack, buffer, partialTicks, packedLight);
    }

    public static void renderTractorBeams(WitherStormEntity storm, EntityRenderDispatcher manager, PoseStack stack, MultiBufferSource buffer, float partialTicks) {
        EntityRenderer raw = manager.m_114382_((Entity)storm);
        if (raw instanceof AbstractWitherStormRenderer) {
            AbstractWitherStormRenderer renderer = (AbstractWitherStormRenderer)raw;
            renderer.updateModel(storm);
            int packedLight = manager.m_114394_((Entity)storm, partialTicks);
            renderer.prepareHeadAnimsForTractorBeams(storm, partialTicks);
            renderer.renderTractorBeams(storm, stack, buffer, partialTicks, packedLight);
        }
    }

    public static void orientAndScale(WitherStormEntity storm, PoseStack stack, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderer raw = mc.m_91290_().m_114382_((Entity)storm);
        if (raw instanceof AbstractWitherStormRenderer) {
            AbstractWitherStormRenderer renderer = (AbstractWitherStormRenderer)raw;
            float bob = renderer.m_6930_((LivingEntity)storm, partialTicks);
            float yBodyRot = Mth.m_14189_((float)partialTicks, (float)storm.f_20884_, (float)storm.f_20883_);
            renderer.setupRotations(storm, stack, bob, yBodyRot, partialTicks);
            stack.m_85841_(-1.0f, -1.0f, 1.0f);
            renderer.scale(storm, stack, partialTicks);
        }
    }

    public static void renderShine(WitherStormEntity storm, PoseStack stack, float partialTicks, Camera camera, MultiBufferSource buffer) {
        if (((Boolean)WitherStormModConfig.CLIENT.renderShine.get()).booleanValue() && storm.shouldShine()) {
            int[] color;
            WitherStormSegmentEntity segment;
            WitherStormEntity parent;
            boolean rainbow;
            Minecraft mc = Minecraft.m_91087_();
            Color configColor = WitherStormResourceConfigManager.INSTANCE.getNightShineColor();
            boolean bl = rainbow = storm.m_8077_() && storm.m_7755_().getString().equals("jeb_");
            if (!rainbow && storm instanceof WitherStormSegmentEntity && (parent = (segment = (WitherStormSegmentEntity)storm).getParent()) != null && parent.m_8077_() && parent.m_7755_().getString().equals("jeb_")) {
                rainbow = true;
            }
            if (!rainbow) {
                color = new int[]{configColor.getRed(), configColor.getGreen(), configColor.getBlue(), configColor.getAlpha()};
            } else {
                float[] rainbowColor = AbstractWitherStormRenderer.getRainbowColor(storm, 0, partialTicks);
                color = new int[]{(int)(rainbowColor[0] * 255.0f), (int)(rainbowColor[1] * 255.0f), (int)(rainbowColor[2] * 255.0f), 75};
            }
            float distanceLerp = 1.0f;
            if (storm.getPhase() > 5 || storm.getConsumptionAmountForPhase(5) <= storm.getConsumedEntities()) {
                distanceLerp = AbstractWitherStormRenderer.getDistanceLerp(storm.m_146892_().m_82554_(camera.m_90583_()), (float)((Integer)mc.f_91066_.m_231984_().m_231551_()).intValue() / 8.0f);
            }
            float f1 = AbstractWitherStormRenderer.getNightTimeLerp(storm.m_9236_(), partialTicks) * distanceLerp * storm.getShineAlpha(partialTicks);
            color[3] = Mth.m_14143_((float)((float)color[3] * f1));
            if (color[3] > 0) {
                VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)SHINE));
                Matrix4f matrix = stack.m_85850_().m_252922_();
                Vec3 dir = camera.m_90583_().m_82546_(storm.m_20299_(partialTicks)).m_82541_();
                float pitch = (float)Math.asin(dir.f_82480_);
                float yaw = (float)Math.atan2(dir.f_82479_, dir.f_82481_);
                stack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252436_.m_252961_(yaw));
                stack.m_252781_(Axis.f_252529_.m_252961_(pitch));
                float scale = storm.getShineScale();
                float xStretch = scale * (storm.getPhase() > 5 ? 1.5f : 1.0f);
                stack.m_252880_(-xStretch / 2.0f, storm.getUnmodifiedHeight() / 2.0f - scale / 2.0f, scale / 2.0f);
                stack.m_85841_(xStretch, scale, 1.0f);
                consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 1.0f).m_5752_();
                consumer.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 1.0f).m_5752_();
                consumer.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 1.0f).m_5752_();
                consumer.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 1.0f).m_5752_();
            }
        }
    }

    public static float getNightTimeLerp(Level level, float partialTicks) {
        float f1 = Mth.m_14089_((float)(level.m_46942_(partialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        return 1.0f - Mth.m_14036_((float)(f1 + 0.5f), (float)0.0f, (float)1.0f);
    }

    public static float getDistanceLerp(double distance, float renderDistance) {
        return Mth.m_14036_((float)((float)(distance - (double)(200.0f * renderDistance)) * 0.005f), (float)0.0f, (float)1.0f);
    }
}

