/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.instancing;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Mth;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nonamecrackers2.witherstormmod.client.instancing.AsyncBufferedInstance;
import nonamecrackers2.witherstormmod.client.instancing.BufferedInstance;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.util.WitherStormModCompat;
import nonamecrackers2.witherstormmod.mixin.IMixinLightTexture;
import nonamecrackers2.witherstormmod.mixin.IMixinOverlayTexture;
import org.joml.Matrix3f;

public class RenderBufferer {
    public static final RenderBufferer INSTANCE = new RenderBufferer(Minecraft.m_91087_());
    private final Minecraft mc;
    private final Map<Object, BufferedInstance> instances = Maps.newHashMap();
    private boolean noFog;
    private boolean tempDisabled;
    private boolean useAsyncBuilder;

    private RenderBufferer(Minecraft mc) {
        this.mc = mc;
    }

    public int getTotalInstances() {
        return this.instances.size();
    }

    public void tick() {
        Iterator<BufferedInstance> iterator = this.instances.values().iterator();
        while (iterator.hasNext()) {
            BufferedInstance instance = iterator.next();
            if (!instance.shouldRemove()) continue;
            iterator.remove();
        }
    }

    public void renderTick() {
        Iterator<BufferedInstance> iterator = this.instances.values().iterator();
        while (iterator.hasNext()) {
            BufferedInstance instance = iterator.next();
            if (!instance.hasRemoveSupplier() && !instance.wasRenderedLastFrame()) {
                iterator.remove();
            }
            instance.setRenderedLastFrame(false);
        }
    }

    private void render(Object key, RenderType type, @Nullable Supplier<Boolean> shouldRemove, BufferedInstance.Bufferable bufferer, PoseStack stack, int packedLight, int overlayTexture, float r, float g, float b, float a, boolean renderBuffered) {
        if (renderBuffered && !this.tempDisabled) {
            BufferedInstance instance = this.instances.computeIfAbsent(key, e -> {
                if (this.useAsyncBuilder) {
                    return new AsyncBufferedInstance(type, bufferer, shouldRemove);
                }
                return new BufferedInstance(type, bufferer, shouldRemove);
            });
            if (instance != null) {
                if (instance.requiresComputing()) {
                    PoseStack s = new PoseStack();
                    s.m_85841_(-1.0f, -1.0f, 1.0f);
                    instance.buildBuffer(s);
                }
                if (instance instanceof AsyncBufferedInstance) {
                    AsyncBufferedInstance async = (AsyncBufferedInstance)instance;
                    async.checkBufferBuilderStatus();
                }
                instance.setBufferer(bufferer);
                VertexBuffer buffer = instance.getBuffer();
                if (buffer != null) {
                    buffer.m_85921_();
                    stack.m_85836_();
                    stack.m_85841_(-1.0f, -1.0f, 1.0f);
                    RenderType renderType = instance.getRenderType();
                    renderType.m_110185_();
                    Matrix3f prevIView = RenderSystem.getInverseViewRotationMatrix();
                    Matrix3f newIView = new Matrix3f();
                    newIView.identity();
                    RenderSystem.setInverseViewRotationMatrix((Matrix3f)newIView);
                    this.applyOverlays(packedLight, overlayTexture, r, g, b, a);
                    float prevStart = RenderSystem.getShaderFogStart();
                    if (this.noFog) {
                        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
                    }
                    buffer.m_253207_(stack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                    instance.setRenderedLastFrame(true);
                    if (this.noFog) {
                        RenderSystem.setShaderFogStart((float)prevStart);
                    }
                    RenderSystem.setInverseViewRotationMatrix((Matrix3f)prevIView);
                    renderType.m_110188_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    stack.m_85849_();
                    VertexBuffer.m_85931_();
                }
            }
        } else {
            bufferer.bufferInto(stack, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(type), packedLight, overlayTexture, r, g, b, a);
        }
        this.noFog = false;
        this.tempDisabled = false;
        this.useAsyncBuilder = false;
    }

    private void applyOverlays(int packedLight, int overlayTexture, float r, float g, float b, float a) {
        IMixinLightTexture lightTexture = (IMixinLightTexture)this.mc.f_91063_.m_109154_();
        IMixinOverlayTexture overlay = (IMixinOverlayTexture)this.mc.f_91063_.m_109155_();
        float[] packedLightCol = RenderBufferer.getRGB(lightTexture.getLightTexture(), (packedLight & 0xFFFF) / 16, (packedLight >> 16 & 0xFFFF) / 16);
        float[] overlayCol = RenderBufferer.getRGB(overlay.getTexture(), overlayTexture & 0xFFFF, overlayTexture >> 16 & 0xFFFF);
        r = Mth.m_14179_((float)overlayCol[3], (float)overlayCol[0], (float)r);
        g = Mth.m_14179_((float)overlayCol[3], (float)overlayCol[1], (float)g);
        b = Mth.m_14179_((float)overlayCol[3], (float)overlayCol[2], (float)b);
        RenderSystem.setShaderColor((float)(r * packedLightCol[0]), (float)(g * packedLightCol[1]), (float)(b * packedLightCol[2]), (float)(a * packedLightCol[3]));
    }

    private static float[] getRGB(DynamicTexture texture, int u, int v) {
        int color = texture.m_117991_().m_84985_(u, v);
        float r = (float)(color >> 0 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 16 & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        return new float[]{r, g, b, a};
    }

    public static boolean shouldUse() {
        return (Boolean)WitherStormModConfig.CLIENT.vertexBufferRendering.get() != false && (!WitherStormModCompat.isOptifineLoaded() || !WitherStormModCompat.isShadersRunning());
    }

    public static void buildAndOrRender(Object key, RenderType type, BufferedInstance.Bufferable bufferer, PoseStack stack, int packedLight, int overlayTexture, float r, float g, float b, float a, boolean renderBuffered) {
        INSTANCE.render(key, type, null, bufferer, stack, packedLight, overlayTexture, r, g, b, a, renderBuffered);
    }

    public static void buildAndOrRender(Object key, RenderType type, Supplier<Boolean> shouldRemove, BufferedInstance.Bufferable bufferer, PoseStack stack, int packedLight, int overlayTexture, float r, float g, float b, float a, boolean renderBuffered) {
        INSTANCE.render(key, type, shouldRemove, bufferer, stack, packedLight, overlayTexture, r, g, b, a, renderBuffered);
    }

    public static void buildAndOrRender(Object key, RenderType type, BufferedInstance.Bufferable bufferer, PoseStack stack, int packedLight, int overlayTexture, float r, float g, float b, float a) {
        INSTANCE.render(key, type, null, bufferer, stack, packedLight, overlayTexture, r, g, b, a, RenderBufferer.shouldUse());
    }

    public static void buildAndOrRender(Object key, RenderType type, Supplier<Boolean> shouldRemove, BufferedInstance.Bufferable bufferer, PoseStack stack, int packedLight, int overlayTexture, float r, float g, float b, float a) {
        INSTANCE.render(key, type, shouldRemove, bufferer, stack, packedLight, overlayTexture, r, g, b, a, RenderBufferer.shouldUse());
    }

    public static void pushNoFog() {
        RenderBufferer.INSTANCE.noFog = true;
    }

    public static void pushTempDisabled() {
        RenderBufferer.INSTANCE.tempDisabled = true;
    }

    public static void pushUseAsyncBuilder() {
        if (((Boolean)WitherStormModConfig.CLIENT.asyncBufferBuilders.get()).booleanValue()) {
            RenderBufferer.INSTANCE.useAsyncBuilder = true;
        }
    }

    public void levelReload() {
        Iterator<Map.Entry<Object, BufferedInstance>> iterator = this.instances.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public static class Events {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            Minecraft mc = Minecraft.m_91087_();
            if (event.phase == TickEvent.Phase.START && !mc.m_91104_() && mc.f_91073_ != null) {
                INSTANCE.tick();
            }
        }

        @SubscribeEvent
        public static void onRender(TickEvent.RenderTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                INSTANCE.renderTick();
            }
        }
    }
}

