/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.gui.widget.config.entry;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.common.ForgeConfigSpec;
import nonamecrackers2.witherstormmod.client.gui.widget.config.ConfigListItem;
import nonamecrackers2.witherstormmod.common.config.ConfigHolder;
import nonamecrackers2.witherstormmod.common.config.ReloadType;
import nonamecrackers2.witherstormmod.common.config.preset.ConfigPreset;
import org.apache.commons.lang3.StringUtils;

public abstract class ConfigEntry<T, W extends AbstractWidget>
implements ConfigListItem {
    protected final Minecraft mc;
    protected final ForgeConfigSpec.ConfigValue<T> value;
    protected final ReloadType reloadType;
    protected final String rawName;
    protected final Component name;
    protected final Component description;
    private final Runnable onValueUpdated;
    protected W widget;

    public ConfigEntry(Minecraft mc, ForgeConfigSpec.ConfigValue<T> value, Runnable onValueUpdated) {
        this.mc = mc;
        this.value = value;
        this.reloadType = ConfigHolder.getReloadType(value);
        this.rawName = StringUtils.join((Iterable)value.getPath(), (String)".");
        List path = value.getPath();
        this.name = Component.m_237115_((String)("gui.witherstormmod.config." + (String)path.get(path.size() - 1) + ".title"));
        ForgeConfigSpec.ValueSpec spec = ConfigHolder.getValueSpec(value);
        String key = spec.getTranslationKey();
        this.description = key.isEmpty() ? Component.m_237113_((String)spec.getComment()) : Component.m_237115_((String)key);
        this.onValueUpdated = onValueUpdated;
    }

    protected Runnable getValueUpdatedResponder() {
        return this.onValueUpdated;
    }

    public ForgeConfigSpec.ConfigValue<T> getConfigValue() {
        return this.value;
    }

    public Component getName() {
        return this.name;
    }

    public Component getDescription() {
        return this.description;
    }

    protected abstract W buildWidget(int var1, int var2, int var3, int var4);

    protected abstract T getCurrentValue();

    protected abstract void setCurrentValue(T var1);

    @Override
    public void resetValue() {
        this.setCurrentValue(this.value.get());
    }

    @Override
    public void setFromPreset(ConfigPreset preset) {
        if (preset.getValues().containsKey(this.value)) {
            this.setCurrentValue(preset.getPresetValue(this.value));
        }
    }

    @Override
    public boolean isValueReset() {
        return this.value.get().equals(this.getCurrentValue());
    }

    @Override
    public boolean matchesPreset(ConfigPreset preset) {
        return preset.doesValueMatch(this.value, this.getCurrentValue());
    }

    @Override
    public void onSavedAndClosed() {
        T current = this.getCurrentValue();
        if (ConfigHolder.isValid(this.value, current)) {
            this.value.set(current);
        }
    }

    @Override
    public void init(List<AbstractWidget> widgets, int x, int y, int width, int height) {
        if (this.widget == null) {
            this.widget = this.buildWidget(x, y, width, height);
        }
        widgets.add((AbstractWidget)this.widget);
    }

    @Override
    public void render(GuiGraphics stack, int x, int y, int width, int height, int mouseX, int mouseY, float partialTicks) {
        Component text = this.getName();
        if (this.widget.m_93696_()) {
            text = text.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.YELLOW));
        }
        Font font = this.mc.f_91062_;
        int n = x + 5 + (this.widget.m_252754_() - x) + this.widget.m_5711_();
        int n2 = y + height / 2;
        Objects.requireNonNull(this.mc.f_91062_);
        stack.m_280430_(font, text, n, n2 - 9 / 2, -1);
        this.widget.m_253211_(y + height / 2 - this.widget.m_93694_() / 2);
        this.widget.m_88315_(stack, mouseX, mouseY, partialTicks);
        if (this.reloadType != ReloadType.NONE) {
            MutableComponent reloadType = Component.m_237113_((String)"Reload: ").m_7220_((Component)Component.m_237113_((String)this.reloadType.toString()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED))).m_130940_(ChatFormatting.DARK_GRAY);
            Font font2 = this.mc.f_91062_;
            int n3 = x + width - this.mc.f_91062_.m_92852_((FormattedText)reloadType) - 5;
            int n4 = y + height / 2;
            Objects.requireNonNull(this.mc.f_91062_);
            stack.m_280430_(font2, (Component)reloadType, n3, n4 - 9 / 2, -1);
        }
    }

    @Override
    @Nullable
    public Tooltip getTooltip(ConfigPreset preset) {
        return this.createConfigTooltip(preset);
    }

    protected Tooltip createConfigTooltip(ConfigPreset preset) {
        Object object;
        MutableComponent comment = this.description.m_6881_();
        comment.m_130946_("\n");
        comment.m_7220_((Component)Component.m_237113_((String)this.rawName).m_130940_(ChatFormatting.GRAY));
        Object defaultName = "Default: ";
        if (!preset.getValues().isEmpty() && !preset.isDefault() && preset.getValues().containsKey(this.value)) {
            defaultName = "Default (" + preset.getTranslationName().getString() + "): ";
            object = preset.getPresetValue(this.value);
        } else {
            object = this.value.getDefault();
        }
        comment.m_130946_("\n");
        comment.m_7220_((Component)Component.m_237113_((String)((String)defaultName + object)).m_130940_(ChatFormatting.GREEN));
        if (this.reloadType != ReloadType.NONE) {
            comment.m_130946_("\n");
            comment.m_7220_((Component)Component.m_237113_((String)("Requires reload of " + this.reloadType.toString())).m_130940_(ChatFormatting.YELLOW));
        }
        return Tooltip.m_257550_((Component)comment);
    }

    @Override
    public int compareTo(ConfigListItem item) {
        if (item instanceof ConfigEntry) {
            ConfigEntry entry = (ConfigEntry)item;
            return this.rawName.compareTo(entry.rawName);
        }
        return -1;
    }

    @Override
    public boolean matchesSearch(String text) {
        String lowerCase = text.toLowerCase();
        return this.rawName.toLowerCase().replace("_", " ").contains(lowerCase) || this.getName().getString().toLowerCase().contains(lowerCase);
    }
}

