/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.gui.widget.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.common.ForgeConfigSpec;
import nonamecrackers2.witherstormmod.client.gui.widget.config.ConfigCategory;
import nonamecrackers2.witherstormmod.client.gui.widget.config.ConfigListItem;
import nonamecrackers2.witherstormmod.client.gui.widget.config.entry.ConfigEntry;
import nonamecrackers2.witherstormmod.common.config.preset.ConfigPreset;

public class ConfigOptionList
extends ContainerObjectSelectionList<Entry> {
    private static final int ROW_HEIGHT = 30;
    private final List<ConfigListItem> items = Lists.newArrayList();
    private final List<ConfigCategory> categories = Lists.newArrayList();
    private String lastSearch = "";
    private final Runnable valuesChangedResponder;

    public ConfigOptionList(Minecraft mc, int width, int height, int top, int bottom, Runnable valuesChangedResponder) {
        super(mc, width, height, top, bottom, 30);
        this.m_93488_(false);
        this.m_93496_(true);
        this.valuesChangedResponder = valuesChangedResponder;
    }

    public <T> void addConfigValue(ForgeConfigSpec.ConfigValue<T> value, ConfigEntryBuilder<T> itemBuilder) {
        ConfigCategory category = this.getOrCreateCategoryFor(value);
        if (category != null) {
            category.addChild(itemBuilder.build(this.f_93386_, value, this.valuesChangedResponder));
        } else {
            this.items.add(itemBuilder.build(this.f_93386_, value, this.valuesChangedResponder));
        }
    }

    @Nullable
    private ConfigCategory getOrCreateCategoryFor(ForgeConfigSpec.ConfigValue<?> value) {
        List rawPath = value.getPath();
        rawPath.remove(rawPath.size() - 1);
        String beginning = (String)rawPath.get(0);
        rawPath.remove(0);
        if (!rawPath.isEmpty()) {
            Object current = beginning;
            ConfigCategory prevCategory = null;
            for (int i = 0; i < rawPath.size(); ++i) {
                String str = (String)rawPath.get(i);
                ConfigCategory category = this.getCategoryByPath((String)(current = (String)current + "." + str));
                if (category == null) {
                    category = new ConfigCategory(this.f_93386_, (String)current, this);
                    this.categories.add(category);
                    if (prevCategory == null) {
                        this.items.add(category);
                    } else {
                        prevCategory.addCategory(category);
                    }
                }
                prevCategory = category;
            }
            return prevCategory;
        }
        return null;
    }

    @Nullable
    private ConfigCategory getCategoryByPath(String path) {
        for (ConfigCategory category : this.categories) {
            if (!path.equals(category.getPath())) continue;
            return category;
        }
        return null;
    }

    public void buildList() {
        this.buildList("");
    }

    public void buildList(String text) {
        this.m_93516_();
        Collections.sort(this.items);
        ArrayList items = Lists.newArrayList();
        for (ConfigListItem item : this.items) {
            ConfigCategory category;
            items.add(item);
            if (!(item instanceof ConfigCategory) || !(category = (ConfigCategory)item).isExpanded()) continue;
            items.addAll(category.getChildren());
        }
        for (ConfigListItem item : items) {
            Entry entry = new Entry(item);
            if (!text.isEmpty() && !item.matchesSearch(text)) continue;
            this.m_7085_((AbstractSelectionList.Entry)entry);
        }
        this.lastSearch = text;
    }

    public void onClosed() {
        for (ConfigListItem item : this.items) {
            item.onSavedAndClosed();
        }
    }

    public void resetValues() {
        for (ConfigListItem item : this.items) {
            item.resetValue();
        }
    }

    public boolean areValuesReset() {
        for (ConfigListItem item : this.items) {
            if (item.isValueReset()) continue;
            return false;
        }
        return true;
    }

    public ConfigPreset getMatchingPreset(List<ConfigPreset> presets) {
        ConfigPreset empty = null;
        for (ConfigPreset preset : presets) {
            if (!preset.getValues().isEmpty()) {
                boolean matches = true;
                for (ConfigListItem item : this.items) {
                    if (item.matchesPreset(preset)) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                return preset;
            }
            empty = preset;
        }
        if (empty == null) {
            throw new NullPointerException("This shouldn't happen! Could not find matching preset.");
        }
        return empty;
    }

    public void setFromPreset(ConfigPreset preset) {
        for (ConfigListItem item : this.items) {
            item.setFromPreset(preset);
        }
    }

    public int m_5759_() {
        return this.getWidth() - 40;
    }

    protected int m_5756_() {
        return this.getLeft() + this.getWidth() - 5;
    }

    protected void m_7733_(GuiGraphics stack) {
        if (this.f_93386_.f_91073_ != null) {
            stack.m_280024_(0, 0, this.f_93388_, this.f_93389_, -1072689136, -804253680);
        } else {
            stack.m_280246_(0.15f, 0.15f, 0.15f, 1.0f);
            stack.m_280398_(Screen.f_279548_, 0, 0, 0, 0.0f, 0.0f, this.f_93388_, this.f_93389_, 32, 32);
            stack.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Nullable
    public ConfigListItem getItemAt(int mouseX, int mouseY) {
        Entry entry = (Entry)this.m_93412_(mouseX, mouseY);
        if (entry != null && entry.children.stream().anyMatch(w -> !w.m_274382_())) {
            return entry.item;
        }
        return null;
    }

    @Nullable
    private ConfigCategory getCategoryFor(ConfigListItem item) {
        for (ConfigCategory category : this.categories) {
            if (!category.getImmediateChildren().contains(item)) continue;
            return category;
        }
        return null;
    }

    public String getLastSearchingFor() {
        return this.lastSearch;
    }

    @FunctionalInterface
    public static interface ConfigEntryBuilder<T> {
        public ConfigEntry<T, ?> build(Minecraft var1, ForgeConfigSpec.ConfigValue<T> var2, Runnable var3);
    }

    public class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final List<AbstractWidget> children = Lists.newArrayList();
        private final ConfigListItem item;
        private final int x;

        public Entry(ConfigListItem item) {
            this.item = item;
            ConfigCategory category = ConfigOptionList.this.getCategoryFor(item);
            int x = (ConfigOptionList.this.getWidth() - ConfigOptionList.this.m_5759_()) / 2;
            if (category != null) {
                x = category.getX() + 20;
            }
            this.item.init(this.children, x, ConfigOptionList.this.getTop(), ConfigOptionList.this.m_5759_(), ConfigOptionList.this.f_93387_);
            this.x = x;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }

        public void m_6311_(GuiGraphics stack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            stack.m_280637_(this.x, top, width - (this.x - left), height, -1426063361);
            if (this.x > left) {
                stack.m_280509_(this.x - 20, top + height / 2, this.x - 4, top + height / 2 + 1, 0x55FFFFFF);
                stack.m_280509_(this.x - 20, top - height / 2 - 3, this.x - 19, top + height / 2, 0x55FFFFFF);
            }
            this.item.render(stack, left, top, width, height, mouseX, mouseY, partialTicks);
        }
    }
}

