/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.gui.widget.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import nonamecrackers2.witherstormmod.client.gui.widget.config.ConfigListItem;
import nonamecrackers2.witherstormmod.client.gui.widget.config.ConfigOptionList;
import nonamecrackers2.witherstormmod.common.config.preset.ConfigPreset;

public class ConfigCategory
implements ConfigListItem {
    private final Minecraft mc;
    private final List<ConfigListItem> children = Lists.newArrayList();
    private final List<ConfigCategory> categories = Lists.newArrayList();
    private final String path;
    private final Component name;
    private final ConfigOptionList list;
    private Button expand;
    private boolean isExpanded;
    private int x;

    public ConfigCategory(Minecraft mc, String path, ConfigOptionList list) {
        this.mc = mc;
        this.path = path;
        this.name = Component.m_237115_((String)("gui.witherstormmod.config.category." + path + ".title")).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.YELLOW));
        this.list = list;
    }

    public void addChild(ConfigListItem item) {
        if (!this.children.contains(item)) {
            this.children.add(item);
        }
    }

    @Override
    public void init(List<AbstractWidget> widgets, int x, int y, int width, int height) {
        MutableComponent text = this.isExpanded ? Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED) : Component.m_237113_((String)"+").m_130940_(ChatFormatting.GREEN);
        this.expand = Button.m_253074_((Component)text, b -> {
            this.isExpanded = !this.isExpanded;
            this.list.buildList(this.list.getLastSearchingFor());
        }).m_252987_(x + 6, y, 20, 20).m_253136_();
        widgets.add((AbstractWidget)this.expand);
        Collections.sort(this.children);
        if (!this.isExpanded) {
            this.children.forEach(child -> child.init(Lists.newArrayList(), x + 20, y, width, height));
        }
        this.x = x;
    }

    @Override
    public void render(GuiGraphics stack, int x, int y, int width, int height, int mouseX, int mouseY, float partialTicks) {
        this.expand.m_253211_(y + height / 2 - this.expand.m_93694_() / 2);
        this.expand.m_88315_(stack, mouseX, mouseY, partialTicks);
        Font font = this.mc.f_91062_;
        int n = x + 5 + (this.expand.m_252754_() - x) + this.expand.m_5711_();
        int n2 = y + height / 2;
        Objects.requireNonNull(this.mc.f_91062_);
        stack.m_280430_(font, this.name, n, n2 - 9 / 2, -1);
    }

    @Override
    public void onSavedAndClosed() {
        this.children.forEach(child -> child.onSavedAndClosed());
    }

    @Override
    public void resetValue() {
        this.children.forEach(child -> child.resetValue());
    }

    @Override
    public boolean isValueReset() {
        return this.children.stream().allMatch(ConfigListItem::isValueReset);
    }

    @Override
    public boolean matchesPreset(ConfigPreset preset) {
        return this.children.stream().allMatch(child -> child.matchesPreset(preset));
    }

    @Override
    public void setFromPreset(ConfigPreset preset) {
        this.children.forEach(child -> child.setFromPreset(preset));
    }

    @Override
    public Tooltip getTooltip(ConfigPreset preset) {
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public List<ConfigListItem> getChildren() {
        ArrayList items = Lists.newArrayList();
        for (ConfigListItem item : this.children) {
            ConfigCategory category;
            items.add(item);
            if (!(item instanceof ConfigCategory) || !(category = (ConfigCategory)item).isExpanded()) continue;
            items.addAll(category.getChildren());
        }
        return items;
    }

    public List<ConfigListItem> getImmediateChildren() {
        return this.children;
    }

    public int getX() {
        return this.x;
    }

    @Override
    public int compareTo(ConfigListItem item) {
        return 1;
    }

    @Override
    public boolean matchesSearch(String text) {
        return this.children.stream().anyMatch(c -> c.matchesSearch(text));
    }

    public void addCategory(ConfigCategory category) {
        this.categories.add(category);
        this.children.add(category);
    }
}

