/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.gui;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import nonamecrackers2.witherstormmod.WitherStormMod;
import nonamecrackers2.witherstormmod.client.audio.SoundManagersRefresher;
import nonamecrackers2.witherstormmod.client.gui.widget.RefreshSoundsButton;
import nonamecrackers2.witherstormmod.client.gui.widget.config.ConfigListItem;
import nonamecrackers2.witherstormmod.client.gui.widget.config.ConfigOptionList;
import nonamecrackers2.witherstormmod.client.gui.widget.config.entry.BooleanConfigEntry;
import nonamecrackers2.witherstormmod.client.gui.widget.config.entry.DoubleConfigEntry;
import nonamecrackers2.witherstormmod.client.gui.widget.config.entry.EnumConfigEntry;
import nonamecrackers2.witherstormmod.client.gui.widget.config.entry.IntegerConfigEntry;
import nonamecrackers2.witherstormmod.client.util.Contributors;
import nonamecrackers2.witherstormmod.common.config.ConfigHolder;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.config.preset.ConfigPreset;
import nonamecrackers2.witherstormmod.common.util.WitherStormModCompat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigScreen
extends Screen {
    private static final int TITLE_HEIGHT = 12;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final int EXIT_BUTTON_OFFSET = 26;
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConfigHolder config;
    private final Consumer<ConfigOptionList> itemGenerator;
    private final boolean isWorldLoaded;
    private final boolean hasSinglePlayerServer;
    @Nullable
    private final Screen previous;
    private final List<ConfigPreset> presets;
    private ConfigOptionList list;
    private Button exit;
    private Button changePreset;
    private Button reset;
    private ConfigPreset preset;
    private ConfigListItem currentHovered;
    private Tooltip currentHoveredTooltip;
    private EditBox searchBox;

    public ConfigScreen(ModConfig.Type type, Consumer<ConfigOptionList> itemGenerator, boolean isWorldLoaded, boolean hasSinglePlayerServer, @Nullable Screen previous) {
        super((Component)Component.m_237115_((String)("gui.witherstormmod.screen." + type.extension() + "Options.title")));
        this.config = WitherStormModConfig.getAllConfigs().get(type);
        if (this.config == null) {
            throw new NullPointerException("Could not find config of type '" + type + "'");
        }
        this.itemGenerator = itemGenerator;
        this.isWorldLoaded = isWorldLoaded;
        this.hasSinglePlayerServer = hasSinglePlayerServer;
        this.previous = previous;
        this.presets = this.config.getPresets();
    }

    protected void m_7856_() {
        if (this.list == null) {
            this.list = new ConfigOptionList(this.f_96541_, this.f_96543_, this.f_96544_, 30, this.f_96544_ - 30, this::onValueChanged);
            this.itemGenerator.accept(this.list);
            this.list.buildList();
        }
        this.list.m_93437_(this.f_96543_, this.f_96544_, 30, this.f_96544_ - 30);
        this.m_142416_((GuiEventListener)this.list);
        this.exit = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.button.exitAndSave.title"), button -> this.closeMenu()).m_252794_((this.f_96543_ - 100) / 2, this.f_96544_ - 26).m_253046_(100, 20).m_253136_();
        this.preset = this.list.getMatchingPreset(this.presets);
        this.changePreset = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.button.preset.title").m_130946_(": " + this.preset.getTranslationName().getString()), button -> this.changePreset()).m_252794_(10, this.f_96544_ - 26).m_253046_((int)Math.round(133.33333333333334), 20).m_257505_(Tooltip.m_257550_((Component)this.preset.getTooltip(false))).m_253136_();
        this.reset = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.button.reset.title"), button -> this.resetValues()).m_252794_(this.f_96543_ - 133 - 10, this.f_96544_ - 26).m_253046_((int)Math.round(133.33333333333334), 20).m_253136_();
        this.reset.f_93623_ = false;
        MutableComponent searchText = Component.m_237115_((String)"gui.witherstormmod.screen.config.search");
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ - this.f_96543_ / 3 - 5, 5, this.f_96543_ / 3, 20, (Component)searchText);
        this.searchBox.m_257771_((Component)searchText);
        this.searchBox.m_94151_(text -> {
            this.list.buildList((String)text);
            this.list.m_93410_(0.0);
        });
        this.searchBox.m_94199_(100);
        this.m_264313_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)this.exit);
        this.m_142416_((GuiEventListener)this.changePreset);
        this.m_142416_((GuiEventListener)this.reset);
        this.m_142416_((GuiEventListener)this.searchBox);
    }

    private void closeMenu() {
        this.list.onClosed();
        this.f_96541_.m_91152_((Screen)new Home(this.isWorldLoaded, this.hasSinglePlayerServer, this.previous));
    }

    private void resetValues() {
        this.list.resetValues();
        this.preset = this.list.getMatchingPreset(this.presets);
        this.changePreset.m_93666_((Component)Component.m_237115_((String)"gui.witherstormmod.button.preset.title").m_130946_(": " + this.preset.getTranslationName().getString()));
        this.reset.f_93623_ = false;
    }

    private void changePreset() {
        int index = this.presets.indexOf(this.preset) + 1;
        if (index >= this.presets.size()) {
            index = 0;
        }
        this.preset = this.presets.get(index);
        this.list.setFromPreset(this.preset);
        this.changePreset.m_93666_((Component)Component.m_237115_((String)"gui.witherstormmod.button.preset.title").m_130946_(": " + this.preset.getTranslationName().getString()));
        this.reset.f_93623_ = !this.list.areValuesReset();
    }

    public void m_88315_(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(stack, mouseX, mouseY, partialTicks);
        stack.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 12, 0xFFFFFF);
        this.changePreset.m_257544_(Tooltip.m_257550_((Component)this.preset.getTooltip(ConfigScreen.m_96638_())));
        ConfigListItem item = this.list.getItemAt(mouseX, mouseY);
        if (this.currentHovered != item) {
            this.currentHovered = item;
            this.currentHoveredTooltip = item != null ? item.getTooltip(this.preset) : null;
        }
        if (!this.m_6702_().stream().anyMatch(c -> !c.equals((Object)this.list) && c.m_5953_((double)mouseX, (double)mouseY)) && this.currentHoveredTooltip != null) {
            stack.m_280245_(this.f_96547_, this.currentHoveredTooltip.m_257408_(this.f_96541_), mouseX, mouseY);
        }
    }

    private void onValueChanged() {
        this.preset = this.list.getMatchingPreset(this.presets);
        this.changePreset.m_93666_((Component)Component.m_237115_((String)"gui.witherstormmod.button.preset.title").m_130946_(": " + this.preset.getTranslationName().getString()));
        this.reset.f_93623_ = !this.list.areValuesReset();
    }

    public static boolean canAddConfigToGui(ForgeConfigSpec.ConfigValue<?> value) {
        if (value == WitherStormModConfig.CLIENT.optifineWarning) {
            return WitherStormModCompat.isOptifineLoaded();
        }
        if (value == WitherStormModConfig.CLIENT.aprilFools) {
            return WitherStormMod.isAprilFools();
        }
        if (value == WitherStormModConfig.CLIENT.patronCosmetic) {
            return Contributors.currentPlayerHasCosmetic();
        }
        return true;
    }

    public static class Home
    extends Screen {
        private static final ResourceLocation TITLE = new ResourceLocation("witherstormmod", "textures/gui/config/wither_storm_mod_title_outline.png");
        private static final int TITLE_WIDTH = 230;
        private static final int TITLE_HEIGHT = 94;
        private static final int BUTTON_WIDTH = 200;
        private static final int BUTTON_HEIGHT = 20;
        private static final int EXIT_BUTTON_OFFSET = 26;
        private final boolean isWorldLoaded;
        private final boolean hasSinglePlayerServer;
        @Nullable
        private final Screen previous;
        private Button clientButton;
        private Button commonButton;
        private Button worldButton;
        private Button exit;
        private Button refreshSoundsButton;
        private Button discordButton;
        private Button patreonButton;
        private Button githubButton;
        private Button nazaKofiButton;

        public Home(boolean isWorldLoaded, boolean hasSinglePlayerServer, @Nullable Screen previous) {
            super((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.title"));
            this.isWorldLoaded = isWorldLoaded;
            this.hasSinglePlayerServer = hasSinglePlayerServer;
            this.previous = previous;
        }

        public Home(boolean isWorldLoaded, boolean hasSinglePlayerServer) {
            this(isWorldLoaded, hasSinglePlayerServer, null);
        }

        protected void m_7856_() {
            int ySpacing = 24;
            this.clientButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.clientOptions.title"), button -> this.openConfigMenu(ModConfig.Type.CLIENT)).m_252794_((this.f_96543_ - 200) / 2, (this.f_96544_ - 60) / 2).m_253046_(200, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.clientOptions.info"))).m_253136_();
            this.commonButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.commonOptions.title"), button -> this.openConfigMenu(ModConfig.Type.COMMON)).m_252794_((this.f_96543_ - 200) / 2, this.clientButton.m_252907_() + ySpacing).m_253046_(200, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.commonOptions.info"))).m_253136_();
            this.worldButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.serverOptions.title"), button -> this.openConfigMenu(ModConfig.Type.SERVER)).m_252794_((this.f_96543_ - 200) / 2, this.commonButton.m_252907_() + ySpacing).m_253046_(200, 20).m_253136_();
            this.exit = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.button.exit.title"), button -> this.m_7379_()).m_252794_((this.f_96543_ - 200) / 2, this.f_96544_ - 26).m_253046_(200, 20).m_253136_();
            this.refreshSoundsButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.button.refreshSounds.title"), button -> SoundManagersRefresher.INSTANCE.refresh()).m_252794_(5, 5).m_253046_(20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.witherstormmod.button.refreshSounds.title"))).build(RefreshSoundsButton::new);
            this.m_142416_((GuiEventListener)this.refreshSoundsButton);
            this.refreshSoundsButton.f_93623_ = this.f_96541_.f_91073_ != null;
            int socialsY = this.worldButton.m_252907_() + ySpacing;
            this.discordButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.discord").m_130948_(Style.f_131099_.m_178520_(-10983950)), button -> this.openLink("https://discord.com/invite/cracker-s-modded-community-987817685293355028")).m_252794_((this.f_96543_ - 200) / 2, socialsY).m_253046_(98, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.discord.info"))).m_253136_();
            this.patreonButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.patreon").m_130940_(ChatFormatting.RED), button -> this.openLink("https://www.patreon.com/user?u=87070090")).m_252794_((this.f_96543_ - 200) / 2 + 102, socialsY).m_253046_(98, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.patreon.info"))).m_253136_();
            this.githubButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.github").m_130948_(Style.f_131099_.m_178520_(-5526613)), button -> this.openLink("https://github.com/nonamecrackers2/crackers-wither-storm-mod/issues")).m_252794_((this.f_96543_ - 200) / 2, this.discordButton.m_252907_() + ySpacing).m_253046_(98, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.github.info"))).m_253136_();
            this.nazaKofiButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.nazaKofi").m_130940_(ChatFormatting.GREEN), button -> this.openLink("https://ko-fi.com/nazaru")).m_252794_((this.f_96543_ - 200) / 2 + 102, this.patreonButton.m_252907_() + ySpacing).m_253046_(98, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.witherstormmod.screen.wsmoptions.nazaKofi.info"))).m_253136_();
            this.m_142416_((GuiEventListener)this.discordButton);
            this.m_142416_((GuiEventListener)this.patreonButton);
            this.m_142416_((GuiEventListener)this.githubButton);
            this.m_142416_((GuiEventListener)this.nazaKofiButton);
            this.m_142416_((GuiEventListener)this.clientButton);
            this.commonButton.f_93623_ = this.isWorldLoaded && this.hasSinglePlayerServer || !this.isWorldLoaded;
            this.m_142416_((GuiEventListener)this.commonButton);
            this.worldButton.f_93623_ = this.isWorldLoaded && this.hasSinglePlayerServer;
            this.m_142416_((GuiEventListener)this.worldButton);
            this.m_142416_((GuiEventListener)this.exit);
        }

        public void m_88315_(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
            MutableComponent worldDesc = Component.m_237115_((String)"gui.witherstormmod.screen.serverOptions.notInWorld.info");
            if (this.isWorldLoaded) {
                worldDesc = Component.m_237115_((String)"gui.witherstormmod.screen.serverOptions.inWorld.info");
            }
            this.worldButton.m_257544_(Tooltip.m_257550_((Component)worldDesc));
            this.m_280273_(stack);
            stack.m_280398_(TITLE, this.f_96543_ / 2 - 115, 20, 0, 0.0f, 0.0f, 230, 94, 256, 256);
            super.m_88315_(stack, mouseX, mouseY, partialTicks);
        }

        public void m_7379_() {
            if (this.previous == null) {
                super.m_7379_();
            } else {
                this.f_96541_.m_91152_(this.previous);
            }
        }

        private void openConfigMenu(ModConfig.Type type) {
            this.f_96541_.m_91152_((Screen)new ConfigScreen(type, list -> {
                ConfigHolder config = WitherStormModConfig.getAllConfigs().get(type);
                for (ForgeConfigSpec.ConfigValue<?> value : config.getValues()) {
                    if (config.shouldHideFromGui(value) || !ConfigScreen.canAddConfigToGui(value)) continue;
                    Class<?> clazz = ConfigHolder.getValuesClass(value);
                    if (Integer.class.isAssignableFrom(clazz)) {
                        list.addConfigValue(value, IntegerConfigEntry::new);
                        continue;
                    }
                    if (Double.class.isAssignableFrom(clazz)) {
                        list.addConfigValue(value, DoubleConfigEntry::new);
                        continue;
                    }
                    if (Boolean.class.isAssignableFrom(clazz)) {
                        list.addConfigValue(value, BooleanConfigEntry::new);
                        continue;
                    }
                    if (Enum.class.isAssignableFrom(clazz)) {
                        Home.addEnumEntry(list, value);
                        continue;
                    }
                    LOGGER.warn("Unknown config GUI entry for type '{}'", clazz);
                }
            }, this.isWorldLoaded, this.hasSinglePlayerServer, this.previous));
        }

        private static <T extends Enum<T>> void addEnumEntry(ConfigOptionList list, ForgeConfigSpec.ConfigValue<?> value) {
            list.addConfigValue(value, EnumConfigEntry::new);
        }

        private void openLink(String link) {
            this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(b -> {
                if (b) {
                    Util.m_137581_().m_137646_(link);
                }
                this.f_96541_.m_91152_((Screen)this);
            }, link, true));
        }
    }
}

