/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.client.audio.bosstheme;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import nonamecrackers2.witherstormmod.client.audio.ISoundManager;
import nonamecrackers2.witherstormmod.client.audio.bosstheme.BossThemeLoop;
import nonamecrackers2.witherstormmod.common.entity.BossThemeEntity;
import nonamecrackers2.witherstormmod.common.util.WorldUtil;

public class BossThemeManager
implements ISoundManager {
    public static final int WATERMARK_TIME = 160;
    protected final Minecraft minecraft;
    @Nullable
    protected BossThemeLoop theme;
    protected Component watermark;
    protected int watermarkTime;
    protected int startTime;

    public BossThemeManager(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public BossThemeManager() {
        this(null);
    }

    @Override
    public void tick() {
        ClientLevel world = this.minecraft.f_91073_;
        for (Entity entity : world.m_104735_()) {
            BossThemeEntity bossEntity;
            if (!(entity instanceof BossThemeEntity) || !(bossEntity = (BossThemeEntity)entity).shouldPlayBossTheme() || !BossThemeManager.inRange(bossEntity, this.minecraft.f_91074_) || !BossThemeManager.hasGeneralAccessTo(bossEntity, this.minecraft.f_91074_)) continue;
            BossThemeEntity current = this.getEntity();
            if (current != null) {
                if (!bossEntity.hasPriority(current)) continue;
                if (this.theme != null) {
                    this.theme.stopSound();
                }
                this.playLoop(bossEntity);
                continue;
            }
            this.playLoop(bossEntity);
        }
        if (this.theme != null && (this.theme.m_7801_() || this.theme.isStopping())) {
            this.theme = null;
        }
        if (this.theme != null && !this.theme.event.equals(this.theme.getEntity().getBossTheme())) {
            this.theme.stopSound();
            this.playLoop(this.theme.getEntity());
        }
        if (this.watermarkTime > 0) {
            --this.watermarkTime;
        }
    }

    @Nullable
    public BossThemeEntity getEntity() {
        if (this.theme != null) {
            return this.theme.getEntity();
        }
        return null;
    }

    private void playLoop(BossThemeEntity entity) {
        this.theme = new BossThemeLoop(entity);
        this.minecraft.m_91106_().m_120372_((TickableSoundInstance)this.theme);
        this.watermark = entity.getWatermark();
        this.watermarkTime = 160;
        this.startTime = 160;
    }

    public void forceStop() {
        if (this.theme != null) {
            this.theme.forceStop();
        }
    }

    @Override
    public void refresh() {
        if (this.theme != null && !this.theme.m_7801_() && !this.theme.isStopping()) {
            this.theme.forceStop();
            this.playLoop(this.theme.getEntity());
        }
    }

    public boolean isPlaying() {
        return this.theme != null;
    }

    protected static boolean inRange(BossThemeEntity entity, LocalPlayer player) {
        boolean flag = true;
        if (entity.distanceToPlay() > 0.0) {
            flag = Math.sqrt(player.m_20275_(entity.getPosition().m_7096_(), entity.getPosition().m_7098_(), entity.getPosition().m_7094_())) < entity.distanceToPlay();
        }
        return flag;
    }

    protected static boolean hasGeneralAccessTo(BossThemeEntity theme, LocalPlayer player) {
        if (theme.smartBossMusic()) {
            return WorldUtil.canSeeOrIsNotInASmallArea((Entity)theme, (Entity)player);
        }
        return true;
    }

    @Nullable
    public Component getWatermark() {
        return this.watermark;
    }

    public int getWatermarkTime() {
        return this.watermarkTime;
    }

    public int getWatermarkStartTime() {
        return this.startTime;
    }
}

