/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_totem_of_undying.mixin.entity;

import com.cerbon.better_totem_of_undying.util.BTUUtils;
import com.cerbon.better_totem_of_undying.util.mixin.ILivingEntityMixin;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=1100)
public abstract class LivingEntityMixin
extends Entity
implements ILivingEntityMixin {
    @Unique
    private boolean btu_isFallDamageImmune;
    @Unique
    private long btu_lastBlockPos;

    private LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="HEAD")}, cancellable=true)
    private void btu_checkTotemDeathProtection(DamageSource damageSource, @NotNull CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        cir.setReturnValue((Object)BTUUtils.canSaveFromDeath(livingEntity, damageSource));
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void btu_causeFallDamage(float fallDistance, float multiplier, DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (((ILivingEntityMixin)livingEntity).btu_isFallDamageImmune()) {
            this.btu_setFallDamageImmune(false);
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void btu_tick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        BTUUtils.resetFallDamageImmune(livingEntity);
        BlockPos previousPosition = this.btu_getLastBlockPos();
        BlockPos newPosition = livingEntity.m_20183_();
        Level level = livingEntity.m_9236_();
        boolean isValidBlock = level.m_8055_(newPosition.m_7495_()).m_280296_();
        if (previousPosition != newPosition && isValidBlock) {
            this.btu_lastBlockPos = newPosition.m_121878_();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void btu_addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("BTUIsFallDamageImmune", this.btu_isFallDamageImmune);
        tag.m_128356_("BTULastBlockPos", this.btu_lastBlockPos);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void btu_readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.btu_isFallDamageImmune = tag.m_128471_("BTUIsFallDamageImmune");
        this.btu_lastBlockPos = tag.m_128454_("BTULastBlockPos");
    }

    @Override
    public void btu_setFallDamageImmune(boolean value) {
        this.btu_isFallDamageImmune = value;
    }

    @Override
    public boolean btu_isFallDamageImmune() {
        return this.btu_isFallDamageImmune;
    }

    @Override
    public BlockPos btu_getLastBlockPos() {
        return BlockPos.m_122022_((long)this.btu_lastBlockPos);
    }
}

