/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import tallestegg.guardvillagers.GuardPacketHandler;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.GuardContainer;
import tallestegg.guardvillagers.networking.GuardFollowPacket;
import tallestegg.guardvillagers.networking.GuardSetPatrolPosPacket;

public class GuardInventoryScreen
extends AbstractContainerScreen<GuardContainer> {
    private static final ResourceLocation GUARD_GUI_TEXTURES = new ResourceLocation("guardvillagers", "textures/container/inventory.png");
    private static final ResourceLocation GUARD_FOLLOWING_ICON = new ResourceLocation("guardvillagers", "textures/container/following_icons.png");
    private static final ResourceLocation GUARD_NOT_FOLLOWING_ICON = new ResourceLocation("guardvillagers", "textures/container/not_following_icons.png");
    private static final ResourceLocation PATROL_ICON = new ResourceLocation("guardvillagers", "textures/container/patrollingui.png");
    private static final ResourceLocation NOT_PATROLLING_ICON = new ResourceLocation("guardvillagers", "textures/container/notpatrollingui.png");
    private final Guard guard;
    private Player player;
    private float mousePosX;
    private float mousePosY;
    private boolean buttonPressed;

    public GuardInventoryScreen(GuardContainer container, Inventory playerInventory, Guard guard) {
        super((AbstractContainerMenu)container, playerInventory, guard.m_5446_());
        this.guard = guard;
        this.f_97728_ = 80;
        this.f_97730_ = 100;
        this.player = playerInventory.f_35978_;
    }

    public void m_7856_() {
        super.m_7856_();
        if (GuardConfig.followHero && this.player.m_21023_(MobEffects.f_19595_) || !GuardConfig.followHero) {
            this.m_142416_((GuiEventListener)new GuardGuiButton(this.f_97735_ + 100, this.f_96544_ / 2 - 40, 20, 18, 0, 0, 19, GUARD_FOLLOWING_ICON, GUARD_NOT_FOLLOWING_ICON, true, p_214086_1_ -> GuardPacketHandler.INSTANCE.sendToServer((Object)new GuardFollowPacket(this.guard.m_19879_()))));
        }
        if (GuardConfig.setGuardPatrolHotv && this.player.m_21023_(MobEffects.f_19595_) || !GuardConfig.setGuardPatrolHotv) {
            this.m_142416_((GuiEventListener)new GuardGuiButton(this.f_97735_ + 120, this.f_96544_ / 2 - 40, 20, 18, 0, 0, 19, PATROL_ICON, NOT_PATROLLING_ICON, false, p_214086_1_ -> {
                this.buttonPressed = !this.buttonPressed;
                GuardPacketHandler.INSTANCE.sendToServer((Object)new GuardSetPatrolPosPacket(this.guard.m_19879_(), this.buttonPressed));
            }));
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUARD_GUI_TEXTURES);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(GUARD_GUI_TEXTURES, i, j, 0, 0, this.f_97726_, this.f_97727_);
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(i + 51), (int)(j + 75), (int)30, (float)((float)(i + 51) - this.mousePosX), (float)((float)(j + 75 - 50) - this.mousePosY), (LivingEntity)this.guard);
    }

    protected void m_280003_(GuiGraphics graphics, int x, int y) {
        super.m_280003_(graphics, x, y);
        int health = Mth.m_14167_((float)this.guard.m_21223_());
        int armor = this.guard.m_21230_();
        MutableComponent guardHealthText = Component.m_237110_((String)"guardinventory.health", (Object[])new Object[]{health});
        MutableComponent guardArmorText = Component.m_237110_((String)"guardinventory.armor", (Object[])new Object[]{armor});
        graphics.m_280614_(this.f_96547_, (Component)guardHealthText, 80, 20, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)guardArmorText, 80, 30, 0x404040, false);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.mousePosX = mouseX;
        this.mousePosY = mouseY;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    class GuardGuiButton
    extends ImageButton {
        private ResourceLocation texture;
        private ResourceLocation newTexture;
        private boolean isFollowButton;

        public GuardGuiButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, ResourceLocation newTexture, boolean isFollowButton, Button.OnPress onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, onPressIn);
            this.texture = resourceLocationIn;
            this.newTexture = newTexture;
            this.isFollowButton = isFollowButton;
        }

        public boolean requirementsForTexture() {
            boolean following = GuardInventoryScreen.this.guard.isFollowing();
            boolean patrol = GuardInventoryScreen.this.guard.isPatrolling();
            return this.isFollowButton ? following : patrol;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            ResourceLocation icon = this.requirementsForTexture() ? this.texture : this.newTexture;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
            int i = this.f_94225_;
            if (this.m_198029_()) {
                i += this.f_94226_;
            }
            RenderSystem.enableDepthTest();
            graphics.m_280163_(icon, this.m_252754_(), this.m_252907_(), (float)this.f_94224_, (float)i, this.f_93618_, this.f_93619_, this.f_94227_, this.f_94228_);
        }
    }
}

