/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.common.item.knife.Knives;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DelightfulConfig {
    public static final DelightfulConfig CONFIG;
    public static final ForgeConfigSpec SPEC;
    private final Map<String, ForgeConfigSpec.BooleanValue> stuff = new HashMap<String, ForgeConfigSpec.BooleanValue>();
    public static ForgeConfigSpec.IntValue CHANCE_WILD_SALMONBERRIES;
    public static ForgeConfigSpec.IntValue CHANCE_MINI_MELON;
    public static ForgeConfigSpec.IntValue CHANCE_CANTALOUPE;
    public static ForgeConfigSpec.BooleanValue CRAFT_NUT_MILK;
    public static ForgeConfigSpec.BooleanValue COOK_CLOVER_HONEY;
    public static ForgeConfigSpec.BooleanValue GIVE_SLICED_DIRECTLY;
    public static ForgeConfigSpec.BooleanValue MELON_JUICING;
    public static ForgeConfigSpec.BooleanValue USE_MILK_TAG;
    private static final ImmutableList<String> DEFAULT_DISABLED;

    DelightfulConfig(ForgeConfigSpec.Builder builder) {
        List<String> items = DelightfulItems.ITEMS.getEntries().stream().map(obj -> obj.getId().m_135815_()).sorted().toList();
        builder.comment(" Let's Configure Delightful");
        this.stuff.clear();
        builder.push("Knives");
        items.stream().filter(path -> path.contains("_knife")).forEach(knife -> DelightfulConfig.put(builder, this.stuff, knife, !DEFAULT_DISABLED.contains(knife)));
        builder.pop();
        builder.push("Pie Overhauls");
        items.stream().filter(path -> path.contains("_pie_slice")).forEach(knife -> DelightfulConfig.put(builder, this.stuff, knife, !DEFAULT_DISABLED.contains(knife)));
        builder.pop();
        builder.push("Registry & Recipes");
        items.stream().filter(path -> !path.contains("_knife") && !path.contains("_pie_slice")).forEach(not -> DelightfulConfig.put(builder, this.stuff, not, !DEFAULT_DISABLED.contains(not)));
        USE_MILK_TAG = builder.comment("Force the replacement of forge:cheese item tag in recipes with forge:milk").define("use_milk_tag", false);
        this.stuff.put("use_milk_tag", USE_MILK_TAG);
        CRAFT_NUT_MILK = builder.comment("Allow cooking milk from nuts").define("nut_milk", true);
        this.stuff.put("nut_milk", CRAFT_NUT_MILK);
        COOK_CLOVER_HONEY = builder.comment("Allow cooking honey from honey and clovers").define("clover_honey", true);
        this.stuff.put("clover_honey", COOK_CLOVER_HONEY);
        GIVE_SLICED_DIRECTLY = builder.comment("Give items that are sliced off of blocks directly to player's inventory instead of dropping").define("give_sliced_directly", false);
        MELON_JUICING = builder.comment("Allow sliced melons to be juiced in-world (right click)").define("melon_juicing", true);
        builder.pop();
        builder.push("Generation");
        CHANCE_WILD_SALMONBERRIES = builder.comment("Chance of generating clusters. Smaller value = more frequent (once every ...). To disable, set the item Salmonberries to false above.").defineInRange("chance_wild_salmonberries", 35, 0, Integer.MAX_VALUE);
        CHANCE_MINI_MELON = builder.comment("Chance of generating clusters. Smaller value = more frequent (once every ...). To disable, set the item Mini Melon to false above.").defineInRange("chance_mini_melon", 35, 0, Integer.MAX_VALUE);
        CHANCE_CANTALOUPE = builder.comment("Chance of generating clusters. Smaller value = more frequent (once every ...). To disable, set the item Cantaloupe to false above.").defineInRange("chance_cantaloupe", 55, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    private static void put(ForgeConfigSpec.Builder builder, Map<String, ForgeConfigSpec.BooleanValue> map, String name, boolean def) {
        map.put(name, builder.define(name, def));
    }

    public boolean verify(String item) {
        return (Boolean)DelightfulConfig.CONFIG.stuff.get(item).get();
    }

    static {
        DEFAULT_DISABLED = ImmutableList.of((Object)Util.name(Knives.COPPER), (Object)Util.name(Knives.BONE), (Object)Util.name(Knives.AMETHYST), (Object)Util.name(Knives.EMERALD), (Object)Util.name(Knives.LAPIS_LAZULI), (Object)Util.name(DelightfulItems.RAW_GOAT), (Object)Util.name(DelightfulItems.COOKED_GOAT));
        Pair pair = new ForgeConfigSpec.Builder().configure(DelightfulConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        CONFIG = (DelightfulConfig)pair.getLeft();
    }
}

