/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.events;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.KoboldRascal;
import net.salju.kobolds.worldgen.KoboldData;
import net.salju.kobolds.worldgen.KoboldRascalSpawner;

@Mod.EventBusSubscriber
public class KoboldsEvents {
    private static final Map<ServerLevel, KoboldRascalSpawner> RASCAL_MAP = new HashMap<ServerLevel, KoboldRascalSpawner>();

    @SubscribeEvent
    public static void onEntitySpawned(EntityJoinLevelEvent event) {
        Zombie billy;
        Entity target = event.getEntity();
        if (target instanceof Raider) {
            Raider johnny = (Raider)target;
            johnny.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)johnny, AbstractKoboldEntity.class, false));
        } else if (target instanceof Zombie && !((billy = (Zombie)target) instanceof ZombifiedPiglin)) {
            billy.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)billy, AbstractKoboldEntity.class, false));
        }
    }

    @SubscribeEvent
    public static void onAttackTarget(LivingChangeTargetEvent event) {
        LivingEntity target = event.getNewTarget();
        LivingEntity billy = event.getEntity();
        if (billy instanceof Zombie && target instanceof KoboldRascal && billy.m_21188_() != target) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (!event.level.f_46443_ && (level = event.level) instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            KoboldData info = KoboldData.get((Level)lvl);
            RASCAL_MAP.computeIfAbsent(lvl, k -> new KoboldRascalSpawner(info));
            KoboldRascalSpawner spawner = RASCAL_MAP.get(lvl);
            spawner.tick(lvl);
        }
    }
}

