/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldModel<T extends AbstractKoboldEntity>
extends HumanoidModel<T> {
    public static final ModelLayerLocation KOBOLD_MODEL = new ModelLayerLocation(new ResourceLocation("kobolds", "kobold"), "main");

    public KoboldModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = KoboldModel.createMesh(CubeDeformation.f_171458_, 0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static MeshDefinition createMesh(CubeDeformation cube, float f1) {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(22, 0).m_171488_(-2.5f, -3.0f, -6.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(1, 3).m_171488_(-0.5f, -3.85f, -5.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-0.5f));
        PartDefinition hat = partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.5f)).m_171514_(17, 52).m_171488_(-6.0f, -5.2f, -6.0f, 12.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-0.5f));
        PartDefinition leftHorn = head.m_171599_("left_horn", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-0.5f, -4.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-7.0f, (float)2.0f, (float)-0.6109f, (float)0.3054f, (float)0.1745f));
        PartDefinition rightHorn = head.m_171599_("right_horn", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171488_(-1.5f, -4.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-7.0f, (float)2.0f, (float)-0.6109f, (float)-0.3054f, (float)-0.1745f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(46, 16).m_171488_(-3.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)5.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(33, 16).m_171488_(0.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)5.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(13, 31).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)14.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)14.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(3, 15).m_171488_(-3.0f, 0.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(24, 15).m_171488_(-1.0f, 6.0f, -4.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        return meshdefinition;
    }

    public void setupAnim(T kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = 0.0f;
        this.f_102814_.f_104203_ = 0.0f;
        this.f_102813_.f_104204_ = 0.0f;
        this.f_102814_.f_104204_ = 0.0f;
        this.f_102810_.f_104203_ = 0.0f;
        this.f_102810_.f_104204_ = 0.0f;
        this.f_102810_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.f_102808_.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102809_.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.f_102809_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102811_.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.f_102812_.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        if (this.f_102609_) {
            this.f_102813_.f_104203_ = -1.5708f;
            this.f_102814_.f_104203_ = -1.5708f;
            this.f_102813_.f_104204_ = 0.2618f;
            this.f_102814_.f_104204_ = -0.2618f;
        }
        if (((AbstractKoboldEntity)((Object)kobold)).isPartyKobold()) {
            this.f_102808_.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.4f)) * 0.04f + 0.04f;
            this.f_102809_.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.4f)) * 0.04f + 0.04f;
        }
        if (kobold.m_21033_(EquipmentSlot.MAINHAND)) {
            if (kobold.m_5912_()) {
                if (kobold.m_21526_()) {
                    this.f_102812_.f_104203_ = -2.0944f;
                    this.f_102812_.f_104204_ = -0.1745f;
                } else {
                    this.f_102811_.f_104203_ = -2.0944f;
                    this.f_102811_.f_104204_ = 0.1745f;
                }
            } else if (kobold.m_21205_().m_41720_() instanceof CrossbowItem) {
                if (kobold.m_21526_()) {
                    if (((AbstractKoboldEntity)((Object)kobold)).isCharging()) {
                        this.f_102812_.f_104203_ = -0.6981f;
                        this.f_102812_.f_104204_ = 0.3491f;
                        this.f_102811_.f_104203_ = -1.1345f;
                        this.f_102811_.f_104204_ = -0.5672f;
                    } else if (CrossbowItem.m_40932_((ItemStack)kobold.m_21205_())) {
                        this.f_102812_.f_104203_ = -1.4399f;
                        this.f_102812_.f_104204_ = 0.2618f;
                        this.f_102811_.f_104203_ = -1.3963f;
                        this.f_102811_.f_104204_ = -0.3054f;
                    }
                } else if (((AbstractKoboldEntity)((Object)kobold)).isCharging()) {
                    this.f_102811_.f_104203_ = -0.6981f;
                    this.f_102811_.f_104204_ = -0.3491f;
                    this.f_102812_.f_104203_ = -1.1345f;
                    this.f_102812_.f_104204_ = 0.5672f;
                } else if (CrossbowItem.m_40932_((ItemStack)kobold.m_21205_())) {
                    this.f_102811_.f_104203_ = -1.4399f;
                    this.f_102811_.f_104204_ = -0.2618f;
                    this.f_102812_.f_104203_ = -1.3963f;
                    this.f_102812_.f_104204_ = 0.3054f;
                }
            }
        }
        if (kobold.m_21033_(EquipmentSlot.OFFHAND)) {
            if (kobold.m_21206_().m_41720_() instanceof TridentItem) {
                if (kobold.m_5912_()) {
                    if (kobold.m_21526_()) {
                        this.f_102811_.f_104203_ = 2.8798f;
                        this.f_102812_.f_104203_ = 0.0f;
                    } else {
                        this.f_102812_.f_104203_ = 2.8798f;
                        this.f_102811_.f_104203_ = 0.0f;
                    }
                }
            } else if (kobold.m_21206_().m_41720_() instanceof ShieldItem) {
                if (kobold.m_21254_()) {
                    if (kobold.m_21526_()) {
                        this.f_102811_.f_104203_ = -0.6981f;
                        this.f_102811_.f_104204_ = -0.2618f;
                    } else {
                        this.f_102812_.f_104203_ = -0.6981f;
                        this.f_102812_.f_104204_ = 0.2618f;
                    }
                }
            } else if (kobold.m_21526_()) {
                this.f_102811_.f_104203_ = -0.8727f;
                this.f_102811_.f_104204_ = 0.0873f;
                this.f_102808_.f_104203_ = -0.2618f;
                this.f_102808_.f_104203_ = 0.1745f;
                this.f_102809_.f_104203_ = -0.2618f;
                this.f_102809_.f_104203_ = 0.1745f;
            } else {
                this.f_102812_.f_104203_ = -0.8727f;
                this.f_102812_.f_104204_ = 0.0873f;
                this.f_102808_.f_104203_ = -0.2618f;
                this.f_102808_.f_104203_ = 0.1745f;
                this.f_102809_.f_104203_ = -0.2618f;
                this.f_102809_.f_104203_ = 0.1745f;
            }
        }
        if (this.f_102608_ > 0.0f) {
            if (kobold.m_5912_()) {
                if (kobold.m_21526_()) {
                    float progress = this.f_102608_;
                    progress = 1.0f - this.f_102608_;
                    progress *= progress;
                    progress *= progress;
                    progress = 1.0f - progress;
                    float f2 = Mth.m_14031_((float)(progress * (float)Math.PI));
                    this.f_102812_.f_104203_ = (float)((double)this.f_102812_.f_104203_ - ((double)f2 / 1.2 - 1.0));
                } else {
                    float progress = this.f_102608_;
                    progress = 1.0f - this.f_102608_;
                    progress *= progress;
                    progress *= progress;
                    progress = 1.0f - progress;
                    float f2 = Mth.m_14031_((float)(progress * (float)Math.PI));
                    this.f_102811_.f_104203_ = (float)((double)this.f_102811_.f_104203_ - ((double)f2 / 1.2 - 1.0));
                }
            } else if (kobold.m_21033_(EquipmentSlot.OFFHAND)) {
                float progress = this.f_102608_;
                this.f_102810_.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)progress) * ((float)Math.PI * 2))) * 0.2f;
                this.f_102811_.f_104204_ += this.f_102810_.f_104204_;
                this.f_102812_.f_104204_ += this.f_102810_.f_104204_;
                this.f_102812_.f_104203_ += this.f_102810_.f_104204_;
                progress = 1.0f - this.f_102608_;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.m_14031_((float)(progress * (float)Math.PI));
                float f3 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.f_102808_.f_104203_ - 0.7f) * 0.75f;
                this.f_102811_.f_104203_ = (float)((double)this.f_102811_.f_104203_ - ((double)f2 * 1.2 + (double)f3));
                this.f_102811_.f_104204_ += this.f_102810_.f_104204_ * 2.0f;
                this.f_102811_.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
            }
        }
    }

    public void m_6002_(HumanoidArm Arm, PoseStack poseStack) {
        switch (Arm) {
            case LEFT: {
                this.f_102812_.m_104299_(poseStack);
                poseStack.m_85837_(0.045, 0.096, 0.0);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                break;
            }
            case RIGHT: {
                this.f_102811_.m_104299_(poseStack);
                poseStack.m_85837_(-0.045, 0.096, 0.0);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.f_102808_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102809_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102810_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102811_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102813_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102812_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102814_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

