/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.item;

import com.lion.graveyard.entities.GhoulingEntity;
import com.lion.graveyard.entities.GraveyardMinionEntity;
import com.lion.graveyard.init.TGEntities;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoneStaffItem
extends Item {
    private final byte ghoulVariant;
    public static Map<UUID, UUID> ownerGhoulingMapping = new HashMap<UUID, UUID>();

    public BoneStaffItem(byte ghoulVariant) {
        super(new Item.Properties().m_41487_(1));
        this.ghoulVariant = ghoulVariant;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player != null && !world.m_5776_()) {
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("OwnerUUID") && stack.m_41783_().m_128342_("OwnerUUID").compareTo(player.m_20148_()) != 0) {
                return InteractionResult.PASS;
            }
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("GhoulingUUID") && ownerGhoulingMapping.containsKey(stack.m_41783_().m_128342_("GhoulingUUID"))) {
                return InteractionResult.PASS;
            }
            GhoulingEntity ghouling = (GhoulingEntity)TGEntities.GHOULING.get().m_20615_(world);
            ghouling.m_20035_(blockPos.m_7494_(), 0.0f, 0.0f);
            ghouling.setOwner(player);
            ghouling.setVariant(this.ghoulVariant);
            stack.m_41784_().m_128362_("GhoulingUUID", ghouling.m_20148_());
            if (!stack.m_41783_().m_128441_("OwnerUUID")) {
                stack.m_41784_().m_128362_("OwnerUUID", player.m_20148_());
                player.m_5661_((Component)Component.m_237115_((String)"entity.graveyard.ghouling.spawn"), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"entity.graveyard.ghouling.respawn"), true);
            }
            ownerGhoulingMapping.putIfAbsent(ghouling.m_20148_(), player.m_20148_());
            ghouling.setStaff(stack);
            ghouling.onSummoned();
            world.m_7967_((Entity)ghouling);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21205_();
        CompoundTag nbt = stack.m_41783_();
        if (!world.f_46443_ && nbt != null && nbt.m_128441_("GhoulingUUID") && nbt.m_128441_("OwnerUUID")) {
            if (user.m_20148_().compareTo(nbt.m_128342_("OwnerUUID")) != 0) {
                user.m_5661_((Component)Component.m_237115_((String)"entity.graveyard.ghouling.obey"), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            UUID ghoulingUUID = nbt.m_128342_("GhoulingUUID");
            GhoulingEntity ghouling = world.m_6443_(GhoulingEntity.class, user.m_20191_().m_82400_(100.0), Objects::nonNull).stream().filter(entity -> entity.m_20148_().compareTo(ghoulingUUID) == 0).findFirst().orElse(null);
            if (ghouling != null) {
                if (user.m_6144_()) {
                    ghouling.m_6710_(null);
                    ghouling.m_21561_(false);
                    ghouling.setTeleportTimer(15);
                    ghouling.m_20324_(user.m_20185_(), user.m_20186_(), user.m_20189_());
                } else {
                    Entity entity2;
                    AABB box;
                    Vec3 rot;
                    Vec3 end;
                    Predicate<Entity> predicate = entity -> {
                        if (entity instanceof LivingEntity) {
                            GraveyardMinionEntity minion;
                            if (entity instanceof TamableAnimal) {
                                TamableAnimal tameableEntity = (TamableAnimal)entity;
                                if (tameableEntity.m_21805_() != null) {
                                    return tameableEntity.m_21805_().compareTo(nbt.m_128342_("OwnerUUID")) != 0;
                                }
                            } else if (entity instanceof GraveyardMinionEntity && (minion = (GraveyardMinionEntity)((Object)entity)).getOwnerUuid() != null) {
                                return minion.getOwnerUuid().compareTo(nbt.m_128342_("OwnerUUID")) != 0;
                            }
                            return true;
                        }
                        return false;
                    };
                    int distance = 100;
                    Vec3 start = user.m_146892_();
                    EntityHitResult result = ProjectileUtil.m_37287_((Entity)user, (Vec3)start, (Vec3)(end = start.m_82549_(rot = user.m_20252_(1.0f).m_82490_((double)distance))), (AABB)(box = user.m_20191_().m_82369_(rot).m_82400_(1.0)), predicate, (double)(distance * distance));
                    if (result != null && result.m_6662_() == HitResult.Type.ENTITY && (entity2 = result.m_82443_()) instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity2;
                        user.m_5661_((Component)Component.m_237115_((String)"entity.graveyard.ghouling.kill"), true);
                        ghouling.playAttackSound = true;
                        ghouling.m_6710_(livingEntity);
                        ghouling.m_21561_(true);
                        ghouling.setSitting(false);
                    }
                }
            }
        }
        return super.m_7203_(world, user, hand);
    }
}

