/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities.projectiles;

import com.lion.graveyard.init.TGEntities;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SkullEntity
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(SkullEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public static Packet<ClientGamePacketListener> createPacket(Entity entity) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(BuiltInRegistries.f_256780_.m_7447_((Object)entity.m_6095_()));
        buf.m_130077_(entity.m_20148_());
        buf.m_130130_(entity.m_19879_());
        buf.writeDouble(entity.m_20185_());
        buf.writeDouble(entity.m_20186_());
        buf.writeDouble(entity.m_20189_());
        buf.writeByte(Mth.m_14143_((float)(entity.m_146909_() * 256.0f / 360.0f)));
        buf.writeByte(Mth.m_14143_((float)(entity.m_146908_() * 256.0f / 360.0f)));
        buf.writeFloat(entity.m_146909_());
        buf.writeFloat(entity.m_146908_());
        return new ClientboundAddEntityPacket(entity, buf.arrayOffset());
    }

    public SkullEntity(EntityType<? extends SkullEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SkullEntity(Level world, LivingEntity owner, double directionX, double directionY, double directionZ) {
        super(TGEntities.SKULL.get(), owner, directionX, directionY, directionZ, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return SkullEntity.createPacket((Entity)this);
    }

    protected float m_6884_() {
        return this.isCharged() ? 0.73f : super.m_6884_();
    }

    public float m_213856_() {
        return 0.0f;
    }

    public boolean m_6060_() {
        return false;
    }

    public float m_7077_(Explosion explosion, BlockGetter world, BlockPos pos, BlockState blockState, FluidState fluidState, float max) {
        return this.isCharged() && WitherBoss.m_31491_((BlockState)blockState) ? Math.min(0.8f, max) : max;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (!this.m_20193_().f_46443_) {
            Entity entity = entityHitResult.m_82443_();
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity2;
                boolean bl = entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingEntity), 10.0f);
                if (bl && entity.m_6084_()) {
                    this.m_19970_(livingEntity, entity);
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3d = this.m_20184_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_() + vec3d.f_82479_ * 0.4, this.m_20186_() + vec3d.f_82480_ + 0.5, this.m_20189_() + vec3d.f_82481_ * 0.4, 0.0, 0.0, 0.0);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_20193_().f_46443_) {
            Explosion.BlockInteraction destructionType = Explosion.BlockInteraction.KEEP;
            Level.ExplosionInteraction sourceType = Level.ExplosionInteraction.NONE;
            this.m_20193_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, false, sourceType);
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CHARGED, (Object)false);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.f_19804_.m_135381_(CHARGED, (Object)charged);
    }

    protected boolean m_5931_() {
        return false;
    }
}

