/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.init.TGBlocks;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SkeletonCreeper
extends Creeper {
    private Player closestPlayer;
    private final double explosionRadius = 3.5;

    public SkeletonCreeper(EntityType<? extends Creeper> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createSkeletonCreeperAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.29);
    }

    public boolean canStart() {
        this.closestPlayer = this.m_20193_().m_45930_((Entity)this, 8.0);
        return this.closestPlayer != null;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        Entity entity = source.m_7639_();
        if (entity instanceof Creeper) {
            Creeper creeperEntity = (Creeper)entity;
            if (creeperEntity.m_7090_() && this.f_19796_.m_188499_()) {
                this.m_19998_((ItemLike)TGBlocks.CREEPER_SKELETON.get().m_5456_());
            }
        } else {
            super.m_7472_(source, lootingMultiplier, allowDrops);
        }
    }

    public void explode() {
        if (!this.m_20193_().f_46443_) {
            float f;
            Level.ExplosionInteraction destructionType = Level.ExplosionInteraction.NONE;
            float f2 = f = this.m_7090_() ? 2.0f : 1.0f;
            if (this.canStart()) {
                this.m_5496_(SoundEvents.f_11860_, 1.0f, 10.0f);
                this.closestPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 125));
            }
            this.f_20890_ = true;
            Level level = this.m_20193_();
            double d = this.m_20185_();
            double d2 = this.m_20186_();
            double d3 = this.m_20189_();
            Objects.requireNonNull(this);
            level.m_254849_((Entity)this, d, d2, d3, 3.5f * f, destructionType);
            this.m_146870_();
            this.spawnEffectsCloud();
        }
    }

    private void spawnEffectsCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(this.m_20193_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaEffectCloudEntity.m_19712_(2.5f);
            areaEffectCloudEntity.m_19732_(-0.5f);
            areaEffectCloudEntity.m_19740_(10);
            areaEffectCloudEntity.m_19734_(areaEffectCloudEntity.m_19748_() / 2);
            areaEffectCloudEntity.m_19738_(-areaEffectCloudEntity.m_19743_() / (float)areaEffectCloudEntity.m_19748_());
            for (MobEffectInstance statusEffectInstance : collection) {
                areaEffectCloudEntity.m_19716_(new MobEffectInstance(statusEffectInstance));
            }
            this.m_20193_().m_7967_((Entity)areaEffectCloudEntity);
        }
    }

    public void m_8107_() {
        if (this.f_19796_.m_188503_(7) == 0) {
            this.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.m_20208_(2.0), this.m_20187_() + (double)new Random().nextInt(1), this.m_20262_(2.0), 2.0, 7.0, 2.0);
        }
        super.m_8107_();
    }
}

