/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.config;

import com.lion.graveyard.config.Config;
import com.lion.graveyard.config.annotations.Description;
import com.lion.graveyard.config.entries.CorruptedChampionEntry;
import com.lion.graveyard.config.entries.HordeConfigEntry;
import com.lion.graveyard.config.entries.MobConfigEntry;
import com.lion.graveyard.config.entries.ParticleConfigEntry;
import com.lion.graveyard.config.entries.StructureConfigEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.resources.ResourceLocation;

public class GraveyardConfig
implements Config {
    @Description(value=" Welcome to The Graveyard Config!\n\n Structures:\n Enable or disable structure spawns.\n\n Mobs:\n Configure spawning weight and group size of the spawn (ghoul, revenant, nightmare, skeleton creeper).\n Configure if mobs burn in sunlight and/or if mobs are affected by the wither effect (all graveyard mobs).\n\n Additional:\n Configure graveyard fog particles rising from moss and set the chance of spawning them (higher numbers = lower chance of spawning).\n Configure if hordes of graveyard mobs can spawn and set their size and frequency.\n Configure if urns have a double chest inventory.\n Configure if the wither skeleton spawner in the large graveyard will be replaced by a skeleton spawner.\n\n")
    public final Map<String, StructureConfigEntry> structureConfigEntries = new HashMap<String, StructureConfigEntry>();
    public final Map<String, ParticleConfigEntry> particleConfigEntries = new HashMap<String, ParticleConfigEntry>(1);
    public final Map<String, MobConfigEntry> mobConfigEntries = new HashMap<String, MobConfigEntry>();
    public final Map<String, HordeConfigEntry> hordeConfigEntries = new HashMap<String, HordeConfigEntry>();
    public final Map<String, CorruptedChampionEntry> corruptedChampionConfigEntries = new HashMap<String, CorruptedChampionEntry>();
    public final Map<String, Boolean> booleanEntries = new HashMap<String, Boolean>();

    @Override
    public String getName() {
        return "the-graveyard-3.0-config";
    }

    @Override
    public String getExtension() {
        return "json5";
    }

    @Override
    public String getDirectory() {
        return "graveyard";
    }

    public boolean enabled(ResourceLocation id) {
        return this.getStructure((ResourceLocation)id).enabled;
    }

    public boolean fogSpawn(ResourceLocation id) {
        return this.getParticle((ResourceLocation)id).canGenerate;
    }

    public StructureConfigEntry getStructure(ResourceLocation id) {
        for (Map.Entry<String, StructureConfigEntry> entry : this.structureConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.m_135815_())) continue;
            return entry.getValue();
        }
        throw new NoSuchElementException("The Graveyard Config is not up to date. Please delete the config and restart the game to create the current config.");
    }

    public ParticleConfigEntry getParticle(ResourceLocation id) {
        for (Map.Entry<String, ParticleConfigEntry> entry : this.particleConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.m_135815_())) continue;
            return entry.getValue();
        }
        throw new NoSuchElementException("The Graveyard Config is not up to date. Please delete the config and restart the game to create the current config.");
    }

    public MobConfigEntry getMob(ResourceLocation id) {
        for (Map.Entry<String, MobConfigEntry> entry : this.mobConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.m_135815_())) continue;
            return entry.getValue();
        }
        throw new NoSuchElementException("The Graveyard Config is not up to date. Please delete the config and restart the game to create the current config.");
    }

    public HordeConfigEntry getHorde(ResourceLocation id) {
        for (Map.Entry<String, HordeConfigEntry> entry : this.hordeConfigEntries.entrySet()) {
            if (!entry.getKey().equals(id.m_135815_())) continue;
            return entry.getValue();
        }
        throw new NoSuchElementException("The Graveyard Config is not up to date. Please delete the config and restart the game to create the current config.");
    }

    @Override
    public void save() {
        this.booleanEntries.putIfAbsent("urnHasDoubleInventory", true);
        this.booleanEntries.putIfAbsent("disableWitherSkeletonSpawner", false);
        this.booleanEntries.putIfAbsent("enableBossMusic", true);
        this.particleConfigEntries.putIfAbsent("graveyard_fog_particle", ParticleConfigEntry.of(50));
        this.hordeConfigEntries.putIfAbsent("horde_spawn", HordeConfigEntry.of(40, 24000, 1200));
        this.structureConfigEntries.putIfAbsent("haunted_house", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("large_graveyard", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("altar", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("crypt", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("giant_mushroom", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("medium_graveyard", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("memorial_tree", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("mushroom_grave", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("small_desert_graveyard", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("small_graveyard", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("small_desert_grave", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("small_grave", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("small_mountain_grave", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("small_savanna_grave", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("lich_prison", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("ruins", StructureConfigEntry.of());
        this.structureConfigEntries.putIfAbsent("dead_tree", StructureConfigEntry.of());
        this.mobConfigEntries.putIfAbsent("ghoul", MobConfigEntry.of(true, 25, 2, 5, true, false));
        this.mobConfigEntries.putIfAbsent("revenant", MobConfigEntry.of(true, 25, 5, 8, true, false));
        this.mobConfigEntries.putIfAbsent("nightmare", MobConfigEntry.of(true, 10, 1, 1, false, false));
        this.mobConfigEntries.putIfAbsent("skeleton_creeper", MobConfigEntry.of(true, 25, 1, 4, true, false));
        this.mobConfigEntries.putIfAbsent("acolyte", MobConfigEntry.of(false, false, false));
        this.mobConfigEntries.putIfAbsent("reaper", MobConfigEntry.of(true, 5, 2, 3, true, false));
        this.mobConfigEntries.putIfAbsent("corrupted_vindicator", MobConfigEntry.of(false, true, false));
        this.mobConfigEntries.putIfAbsent("corrupted_pillager", MobConfigEntry.of(false, true, false));
        this.mobConfigEntries.putIfAbsent("wraith", MobConfigEntry.of(false, true, false));
        this.corruptedChampionConfigEntries.putIfAbsent("corrupted_champion", CorruptedChampionEntry.of(400.0f, 200.0f, 30.0, 40.0, 14.0, 12.0, 0.15, 800, 400, 700, 150, 5, 30, 5, 6000, List.of("entity.minecraft.villager"), List.of("item.minecraft.debug_stick"), true, true, true, 400, 600, 400, -15));
        Config.super.save();
    }
}

