/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.blocks;

import com.lion.graveyard.blockentities.SarcophagusBlockEntity;
import com.lion.graveyard.blockentities.enums.SarcophagusPart;
import com.lion.graveyard.entities.WraithEntity;
import com.lion.graveyard.init.TGAdvancements;
import com.lion.graveyard.init.TGBlockEntities;
import com.lion.graveyard.init.TGEntities;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SarcophagusBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty OPEN;
    public static final BooleanProperty PLAYER_PLACED;
    public static final BooleanProperty IS_COFFIN;
    public static final DirectionProperty FACING;
    protected static final VoxelShape DOUBLE_NORTH_SHAPE;
    protected static final VoxelShape DOUBLE_SOUTH_SHAPE;
    protected static final VoxelShape DOUBLE_WEST_SHAPE;
    protected static final VoxelShape DOUBLE_EAST_SHAPE;
    public static final EnumProperty<SarcophagusPart> PART;
    private final Supplier<Item> lid;
    private final Supplier<Item> base;

    public SarcophagusBlock(BlockBehaviour.Properties settings, boolean isCoffin, Supplier<Item> lid, Supplier<Item> base) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)SarcophagusPart.FOOT))).m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_COFFIN, (Comparable)Boolean.valueOf(isCoffin)));
        this.base = base;
        this.lid = lid;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, OPEN, FACING, PART, PLAYER_PLACED, IS_COFFIN});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == SarcophagusBlock.getDirectionTowardsOtherPart((SarcophagusPart)((Object)state.m_61143_(PART)), (Direction)state.m_61143_((Property)FACING))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(PART) != state.m_61143_(PART) ? state : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private static Direction getDirectionTowardsOtherPart(SarcophagusPart part, Direction direction) {
        return part == SarcophagusPart.FOOT ? direction : direction.m_122424_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            default: {
                return DOUBLE_NORTH_SHAPE;
            }
            case SOUTH: {
                return DOUBLE_SOUTH_SHAPE;
            }
            case WEST: {
                return DOUBLE_WEST_SHAPE;
            }
            case EAST: 
        }
        return DOUBLE_EAST_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        Random random = new Random();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos original = pos;
        if (state.m_61143_(PART) == SarcophagusPart.HEAD) {
            pos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        }
        if ((blockEntity = world.m_7702_(pos)) instanceof SarcophagusBlockEntity) {
            player.m_5893_((MenuProvider)((SarcophagusBlockEntity)blockEntity));
        }
        SarcophagusBlock.spawnGhost(state, world, original, player, random);
        return InteractionResult.CONSUME;
    }

    public static void spawnGhost(BlockState state, Level world, BlockPos pos, Player player, Random random) {
        if (!((Boolean)state.m_61143_((Property)PLAYER_PLACED)).booleanValue() && random.nextInt(4) == 0 && pos.m_123342_() < 62) {
            BlockPos entityPos = pos;
            for (int i = 0; !(i >= 10 || world.m_8055_(entityPos = player.m_20183_().m_7918_(-2 + random.nextInt(5), 1, -2 + random.nextInt(5))).m_60795_() && world.m_8055_(entityPos.m_7494_()).m_60795_()); ++i) {
            }
            WraithEntity ghost = (WraithEntity)TGEntities.WRAITH.get().m_20615_(world);
            ghost.m_20035_(entityPos, 0.0f, 0.0f);
            world.m_7967_((Entity)ghost);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(true)), 3);
            BlockPos otherPartPos = pos.m_121945_(SarcophagusBlock.getDirectionTowardsOtherPart((SarcophagusPart)((Object)state.m_61143_(PART)), (Direction)state.m_61143_((Property)FACING)));
            BlockState otherPart = world.m_8055_(otherPartPos);
            if (player instanceof ServerPlayer) {
                TGAdvancements.SPAWN_WRAITH.trigger((ServerPlayer)player);
            }
            world.m_7731_(otherPartPos, (BlockState)otherPart.m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_) {
            BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(true)));
            world.m_7731_(blockPos, (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)SarcophagusPart.HEAD))).m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(true)), 3);
            world.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        BlockPos blockPos = pos.m_5484_((Direction)state.m_61143_((Property)FACING), state.m_61143_(PART) == SarcophagusPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)blockPos.m_123341_(), (int)pos.m_123342_(), (int)blockPos.m_123343_());
    }

    public static DoubleBlockCombiner.BlockType getSarcophagusPart(BlockState state) {
        SarcophagusPart bedPart = (SarcophagusPart)((Object)state.m_61143_(PART));
        return bedPart == SarcophagusPart.HEAD ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        SarcophagusPart part;
        if (!world.f_46443_ && player.m_7500_() && (part = (SarcophagusPart)((Object)state.m_61143_(PART))) == SarcophagusPart.FOOT && (blockState = world.m_8055_(blockPos = pos.m_121945_(SarcophagusBlock.getDirectionTowardsOtherPart(part, (Direction)state.m_61143_((Property)FACING))))).m_60713_((Block)this) && blockState.m_61143_(PART) == SarcophagusPart.HEAD) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SarcophagusBlockEntity) {
            ((SarcophagusBlockEntity)blockEntity).onScheduledTick();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SarcophagusBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction direction = ctx.m_8125_();
        BlockPos blockPos = ctx.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        Level world = ctx.m_43725_();
        return world.m_8055_(blockPos2).m_60629_(ctx) && world.m_6857_().m_61937_(blockPos2) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_)) : null;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static Direction getOppositePartDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return state.m_61143_(PART) == SarcophagusPart.HEAD ? direction.m_122424_() : direction;
    }

    public static DoubleBlockCombiner.Combiner<SarcophagusBlockEntity, Float2FloatFunction> getAnimationProgressRetriever(final LidBlockEntity progress) {
        return new DoubleBlockCombiner.Combiner<SarcophagusBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction getFromBoth(SarcophagusBlockEntity chestBlockEntity, SarcophagusBlockEntity chestBlockEntity2) {
                return tickDelta -> Math.max(chestBlockEntity.m_6683_(tickDelta), chestBlockEntity2.m_6683_(tickDelta));
            }

            public Float2FloatFunction getFrom(SarcophagusBlockEntity chestBlockEntity) {
                Objects.requireNonNull(chestBlockEntity);
                return chestBlockEntity::m_6683_;
            }

            public Float2FloatFunction getFallback() {
                Objects.requireNonNull(progress);
                return arg_0 -> ((LidBlockEntity)progress).m_6683_(arg_0);
            }
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ ? SarcophagusBlock.m_152132_(type, TGBlockEntities.SARCOPHAGUS_BLOCK_ENTITY.get(), SarcophagusBlockEntity::clientTick) : null;
    }

    public Supplier<Item> getLid() {
        return this.lid;
    }

    public Supplier<Item> getBase() {
        return this.base;
    }

    static {
        IS_COFFIN = BooleanProperty.m_61465_((String)"is_coffin");
        PART = EnumProperty.m_61587_((String)"part", SarcophagusPart.class);
        PLAYER_PLACED = BlockStateProperties.f_61444_;
        OPEN = BlockStateProperties.f_61446_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        FACING = BlockStateProperties.f_61374_;
        DOUBLE_NORTH_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        DOUBLE_SOUTH_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        DOUBLE_WEST_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        DOUBLE_EAST_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }
}

