/*
 * Decompiled with CFR 0.152.
 */
package com.lion.villagersplus.blockentities;

import com.lion.villagersplus.VillagersPlus;
import com.lion.villagersplus.blocks.AlchemistTableBlock;
import com.lion.villagersplus.client.screen.AlchemistTableScreenHandler;
import com.lion.villagersplus.init.VPBlockEntities;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class AlchemistTableBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] TOP_SLOTS = new int[]{3};
    private static final int[] BOTTOM_SLOTS = new int[]{0, 1, 2, 3};
    private static final int[] SIDE_SLOTS = new int[]{0, 1, 2, 4};
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private boolean[] slotsEmptyLastTick;
    private Item itemBrewing;
    int brewTime;
    int fuel;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AlchemistTableBlockEntity.this.brewTime;
                case 1 -> AlchemistTableBlockEntity.this.fuel;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AlchemistTableBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    AlchemistTableBlockEntity.this.fuel = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public AlchemistTableBlockEntity(BlockPos pos, BlockState state) {
        super(VPBlockEntities.ALCHEMIST_TABLE_BLOCK_ENTITY.get(), pos, state);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.alchemist_table");
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        ItemStack itemStack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)var1.next()).m_41619_());
        return false;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, AlchemistTableBlockEntity blockEntity) {
        ItemStack itemStack = (ItemStack)blockEntity.inventory.get(4);
        if (blockEntity.fuel <= 0 && itemStack.m_150930_(Items.f_42403_)) {
            blockEntity.fuel = 20;
            itemStack.m_41774_(1);
            AlchemistTableBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
        state = blockEntity.fuel <= 0 ? (BlockState)state.m_61124_((Property)AlchemistTableBlock.HAS_FUEL, (Comparable)Boolean.valueOf(false)) : (BlockState)state.m_61124_((Property)AlchemistTableBlock.HAS_FUEL, (Comparable)Boolean.valueOf(true));
        boolean bl = AlchemistTableBlockEntity.canCraft(blockEntity.inventory);
        boolean bl2 = blockEntity.brewTime > 0;
        ItemStack itemStack2 = (ItemStack)blockEntity.inventory.get(3);
        state = !itemStack2.m_41619_() ? (BlockState)state.m_61124_((Property)AlchemistTableBlock.BOTTLE_PROPERTIES[3], (Comparable)Boolean.valueOf(true)) : (BlockState)state.m_61124_((Property)AlchemistTableBlock.BOTTLE_PROPERTIES[3], (Comparable)Boolean.valueOf(false));
        if (bl2) {
            --blockEntity.brewTime;
            boolean bl3 = blockEntity.brewTime == 0;
            state = (BlockState)state.m_61124_((Property)AlchemistTableBlock.IS_BREWING, (Comparable)Boolean.valueOf(true));
            if (world.f_46441_.m_188503_(8) == 0) {
                world.m_5594_(null, pos, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.5f, 0.5f);
            }
            if (bl3 && bl) {
                AlchemistTableBlockEntity.craft(world, pos, blockEntity.inventory);
                AlchemistTableBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            } else if (!bl || !itemStack2.m_150930_(blockEntity.itemBrewing)) {
                blockEntity.brewTime = 0;
                AlchemistTableBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            }
        } else if (bl && blockEntity.fuel > 0) {
            blockEntity.fuel -= 20;
            blockEntity.brewTime = 400;
            blockEntity.itemBrewing = itemStack2.m_41720_();
            AlchemistTableBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
        if (blockEntity.brewTime <= 0) {
            state = (BlockState)state.m_61124_((Property)AlchemistTableBlock.IS_BREWING, (Comparable)Boolean.valueOf(false));
        }
        world.m_7731_(pos, state, 2);
        boolean[] bls = blockEntity.getSlotsEmpty();
        if (!Arrays.equals(bls, blockEntity.slotsEmptyLastTick)) {
            blockEntity.slotsEmptyLastTick = bls;
            BlockState blockState = state;
            if (!(state.m_60734_() instanceof AlchemistTableBlock)) {
                return;
            }
            for (int i = 0; i < AlchemistTableBlock.BOTTLE_PROPERTIES.length - 1; ++i) {
                blockState = (BlockState)blockState.m_61124_((Property)AlchemistTableBlock.BOTTLE_PROPERTIES[i], (Comparable)Boolean.valueOf(bls[i]));
            }
            world.m_7731_(pos, blockState, 2);
        }
    }

    private boolean[] getSlotsEmpty() {
        boolean[] bls = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            bls[i] = true;
        }
        return bls;
    }

    private static boolean canCraft(NonNullList<ItemStack> slots) {
        ItemStack itemStack = (ItemStack)slots.get(3);
        if (itemStack.m_41619_()) {
            return false;
        }
        if (!(itemStack.m_150930_(Items.f_42739_) || itemStack.m_150930_(Items.f_42736_) || itemStack.m_150930_(Items.f_42589_))) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemStack2 = (ItemStack)slots.get(i);
            if (itemStack2.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private static void craft(Level world, BlockPos pos, NonNullList<ItemStack> slots) {
        ItemStack itemStack = (ItemStack)slots.get(3);
        List potions = BuiltInRegistries.f_256980_.m_6579_().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        int explosionChance = 0;
        if (VillagersPlus.CONFIG.can_explode) {
            explosionChance = world.m_213780_().m_188503_(VillagersPlus.CONFIG.explosion_chance);
        }
        if (explosionChance == 0) {
            for (int i = 0; i < 3; ++i) {
                if (((ItemStack)slots.get(i)).m_41619_()) continue;
                slots.set(i, (Object)(world.f_46441_.m_188499_() ? PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)((Potion)potions.get(world.f_46441_.m_188503_(potions.size())))) : PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)potions.get(world.f_46441_.m_188503_(potions.size()))))));
            }
        } else {
            world.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 3.0f, Level.ExplosionInteraction.NONE);
            slots.set(0, (Object)ItemStack.f_41583_);
            slots.set(1, (Object)ItemStack.f_41583_);
            slots.set(2, (Object)ItemStack.f_41583_);
            slots.set(4, (Object)ItemStack.f_41583_);
        }
        itemStack.m_41774_(1);
        slots.set(3, (Object)itemStack);
        world.m_46796_(1035, pos, 0);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.brewTime = nbt.m_128448_("BrewTime");
        this.fuel = nbt.m_128445_("Fuel");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128376_("BrewTime", (short)this.brewTime);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128344_("Fuel", (byte)this.fuel);
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < this.inventory.size() ? (ItemStack)this.inventory.get(slot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 3) {
            return stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_) || stack.m_150930_(Items.f_42590_);
        }
        if (slot == 4) {
            return stack.m_150930_(Items.f_42403_);
        }
        return stack.m_150930_(Items.f_42590_) && this.m_8020_(slot).m_41619_();
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.UP) {
            return TOP_SLOTS;
        }
        return side == Direction.DOWN ? BOTTOM_SLOTS : SIDE_SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot != 3 || stack.m_150930_(Items.f_42590_);
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new AlchemistTableScreenHandler(syncId, playerInventory, (Container)this, this.propertyDelegate);
    }
}

