/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.villagersrespawn.events;

import com.mactso.villagersrespawn.config.MyConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VillagerDeathEvent {
    private static final int[] xpLevels = new int[]{0, 10, 70, 150, 250};

    @SubscribeEvent
    public void doVillagerRespawn(LivingDeathEvent event) {
        LivingEntity eventEntity = event.getEntity();
        if (event.getEntity() == null) {
            return;
        }
        if (!(eventEntity.m_9236_() instanceof ServerLevel)) {
            return;
        }
        if (eventEntity instanceof Villager) {
            double randomD100Roll = eventEntity.m_9236_().f_46441_.m_188500_() * 100.0;
            randomD100Roll = Math.ceil(randomD100Roll);
            Difficulty difficulty = eventEntity.m_9236_().m_46791_();
            if (difficulty == Difficulty.NORMAL) {
                randomD100Roll += 5.0;
            }
            if (difficulty == Difficulty.HARD) {
                randomD100Roll += 10.0;
            }
            if (randomD100Roll > (double)MyConfig.respawnPercentage) {
                return;
            }
            Villager ve = (Villager)eventEntity;
            if (ve.m_21225_() != null && ve.m_21225_().m_7639_() instanceof Zombie && ve.m_9236_().m_46791_() == Difficulty.HARD && MyConfig.hardModeZombieDeaths) {
                return;
            }
            Brain vb = ve.m_6274_();
            Optional villagerHome = vb.m_21952_(MemoryModuleType.f_26359_);
            if (villagerHome.isPresent()) {
                Optional standupPos;
                GlobalPos gVHP = (GlobalPos)villagerHome.get();
                BlockPos villagerHomePos = gVHP.m_122646_();
                BlockState bs = ve.m_9236_().m_8055_(villagerHomePos);
                if (bs.m_60734_() instanceof BedBlock && (standupPos = BedBlock.m_260958_((EntityType)ve.m_6095_(), (CollisionGetter)ve.m_9236_(), (BlockPos)villagerHomePos, (Direction)((Direction)bs.m_61143_((Property)BedBlock.f_54117_)), (float)0.0f)).isPresent()) {
                    eventEntity.m_6034_(((Vec3)standupPos.get()).f_82479_, ((Vec3)standupPos.get()).f_82480_, ((Vec3)standupPos.get()).f_82481_);
                    ve.m_20095_();
                    ve.m_21219_();
                    ve.m_21153_((float)MyConfig.respawnHealth);
                    this.doRespawnXpLoss(ve);
                    event.setCanceled(true);
                }
            }
        }
    }

    private void doRespawnXpLoss(Villager ve) {
        int level;
        if (MyConfig.respawnXpLoss && (level = ve.m_7141_().m_35576_()) >= 1) {
            ve.m_6621_(xpLevels[level - 1]);
        }
    }
}

