/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class EditConfigScreen
extends BaseScreen {
    public static final Color4I COLOR_BACKGROUND = Color4I.rgba(-1724697805);
    public static Theme THEME = new Theme(){

        @Override
        public void drawScrollBarBackground(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type) {
            Color4I.BLACK.withAlpha(70).draw(graphics, x, y, w, h);
        }

        @Override
        public void drawScrollBar(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type, boolean vertical) {
            this.getContentColor(WidgetType.NORMAL).withAlpha(100).withBorder(Color4I.GRAY.withAlpha(100), false).draw(graphics, x, y, w, h);
        }
    };
    private final ConfigGroup group;
    private final Component title;
    private final List<Widget> allConfigButtons;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;
    private final PanelScrollBar scroll;
    private int groupSize = 0;
    private boolean autoclose = false;
    private int dividerX;

    public EditConfigScreen(ConfigGroup configGroup) {
        this.group = configGroup;
        this.title = configGroup.getName().m_6881_().m_130940_(ChatFormatting.BOLD);
        this.allConfigButtons = new ArrayList<Widget>();
        this.configPanel = new ConfigPanel();
        ArrayList list = new ArrayList();
        this.collectAllConfigValues(this.group, list);
        if (!list.isEmpty()) {
            list.sort(null);
            ConfigGroupButton group = null;
            for (ConfigValue configValue : list) {
                if (group == null || group.group != configValue.getGroup()) {
                    this.allConfigButtons.add(new VerticalSpaceWidget(this.configPanel, 4));
                    group = new ConfigGroupButton(this.configPanel, configValue.getGroup());
                    this.allConfigButtons.add(group);
                    ++this.groupSize;
                }
                ConfigEntryButton btn = new ConfigEntryButton(this.configPanel, group, configValue);
                this.allConfigButtons.add(btn);
                this.dividerX = Math.max(this.dividerX, this.getTheme().getStringWidth((FormattedText)btn.keyText));
            }
            if (this.groupSize == 1) {
                this.allConfigButtons.remove(group);
            }
        }
        this.dividerX += 10;
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, (Component)Component.m_237115_((String)"gui.accept"), Icons.ACCEPT, (widget, button) -> this.doAccept());
        this.buttonCancel = new SimpleButton(this, (Component)Component.m_237115_((String)"gui.cancel"), Icons.CANCEL, (widget, button) -> this.doCancel());
        this.buttonExpandAll = new SimpleButton(this, (Component)Component.m_237115_((String)"gui.expand_all"), Icons.ADD, (widget, button) -> this.toggleAll(false));
        this.buttonCollapseAll = new SimpleButton(this, (Component)Component.m_237115_((String)"gui.collapse_all"), Icons.REMOVE, (widget, button) -> this.toggleAll(true));
    }

    private void toggleAll(boolean collapsed) {
        for (Widget w : this.allConfigButtons) {
            if (!(w instanceof ConfigGroupButton)) continue;
            ConfigGroupButton cgb = (ConfigGroupButton)w;
            cgb.setCollapsed(collapsed);
        }
        this.scroll.setValue(0.0);
        this.getGui().refreshWidgets();
    }

    private void collectAllConfigValues(ConfigGroup group, List<ConfigValue<?>> list) {
        list.addAll(group.getValues());
        for (ConfigGroup subgroup : group.getSubgroups()) {
            this.collectAllConfigValues(subgroup, list);
        }
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        if (this.groupSize > 1) {
            this.add(this.buttonExpandAll);
            this.add(this.buttonCollapseAll);
        }
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
        if (this.groupSize > 1) {
            this.buttonExpandAll.setPos(this.width - 58, 2);
            this.buttonCollapseAll.setPos(this.width - 78, 2);
        }
    }

    public EditConfigScreen setAutoclose(boolean autoclose) {
        this.autoclose = autoclose;
        return this;
    }

    private void doAccept() {
        this.group.save(true);
        if (this.autoclose) {
            this.closeGui();
        }
    }

    private void doCancel() {
        this.group.save(false);
        if (this.autoclose) {
            this.closeGui();
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.group.save(true);
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        COLOR_BACKGROUND.draw(graphics, 0, 0, w, 20);
        theme.drawString(graphics, this.getTitle(), 6, 6, 2);
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public Theme getTheme() {
        return THEME;
    }

    private class ConfigPanel
    extends Panel {
        public ConfigPanel() {
            super(EditConfigScreen.this);
        }

        @Override
        public void addWidgets() {
            for (Widget w : EditConfigScreen.this.allConfigButtons) {
                if (w instanceof ConfigEntryButton) {
                    ConfigEntryButton cgb = (ConfigEntryButton)w;
                    if (cgb.groupButton.collapsed) continue;
                }
                this.add(w);
            }
        }

        @Override
        public void alignWidgets() {
            this.widgets.forEach(w -> w.setWidth(this.width - 16));
            this.align(WidgetLayout.VERTICAL);
        }
    }

    public static class ConfigGroupButton
    extends Button {
        public final ConfigGroup group;
        public MutableComponent title;
        public MutableComponent info;
        public boolean collapsed = false;

        public ConfigGroupButton(Panel panel, ConfigGroup g) {
            super(panel);
            this.setHeight(12);
            this.group = g;
            if (this.group.getParent() != null) {
                ArrayList<ConfigGroup> groups = new ArrayList<ConfigGroup>();
                do {
                    groups.add(g);
                } while ((g = g.getParent()) != null);
                groups.remove(groups.size() - 1);
                this.title = Component.m_237113_((String)"");
                for (int i = groups.size() - 1; i >= 0; --i) {
                    this.title.m_7220_(((ConfigGroup)groups.get(i)).getName());
                    if (i == 0) continue;
                    this.title.m_130946_(" > ");
                }
            } else {
                this.title = Component.m_237115_((String)"stat.generalButton");
            }
            this.title.m_130940_(ChatFormatting.YELLOW);
            String infoKey = this.group.getPath() + ".info";
            this.info = I18n.m_118936_((String)infoKey) ? Component.m_237115_((String)infoKey) : null;
            this.setCollapsed(this.collapsed);
        }

        public void setCollapsed(boolean collapsed) {
            this.collapsed = collapsed;
            this.setTitle((Component)Component.m_237113_((String)(this.collapsed ? "[-] " : "[v] ")).m_130940_(this.collapsed ? ChatFormatting.RED : ChatFormatting.GREEN).m_7220_((Component)this.title));
        }

        @Override
        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            COLOR_BACKGROUND.draw(graphics, x, y, w, h);
            theme.drawString(graphics, this.getTitle(), x + 3, y + 2);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color4I.GRAY.withAlpha(80).draw(graphics, 0, y, this.width, 1);
            Color4I.GRAY.withAlpha(80).draw(graphics, 0, y, 1, this.height);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (this.info != null) {
                list.add((Component)this.info);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.collapsed);
            this.getGui().refreshWidgets();
        }
    }

    private class ConfigEntryButton<T>
    extends Button {
        private final ConfigGroupButton groupButton;
        private final ConfigValue<T> configValue;
        private final Component keyText;

        public ConfigEntryButton(Panel panel, ConfigGroupButton groupButton, ConfigValue<T> configValue) {
            super(panel);
            this.setHeight(EditConfigScreen.this.getTheme().getFontHeight() + 2);
            this.groupButton = groupButton;
            this.configValue = configValue;
            this.keyText = this.configValue.getCanEdit() ? Component.m_237113_((String)this.configValue.getName()) : Component.m_237113_((String)this.configValue.getName()).m_130940_(ChatFormatting.GRAY);
        }

        @Override
        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
            theme.drawString(graphics, this.keyText, 5, y + 2, Bits.setFlag(0, 2, mouseOver));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Component s = this.configValue.getStringForGUI(this.configValue.getValue());
            int slen = theme.getStringWidth((FormattedText)s);
            int maxLen = this.width - EditConfigScreen.this.dividerX - 10;
            if (slen > maxLen) {
                s = Component.m_237113_((String)(theme.trimStringToWidth((FormattedText)s, maxLen).getString().trim() + "..."));
                slen = maxLen + 2;
            }
            MutableColor4I textCol = this.configValue.getColor().mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                if (this.getMouseX() > x + w - slen - 9) {
                    Color4I.WHITE.withAlpha(33).draw(graphics, x + w - slen - 8, y, slen + 8, h);
                }
            }
            theme.drawString(graphics, s, EditConfigScreen.this.dividerX + 5, y + 2, textCol, 0);
            Color4I.GRAY.withAlpha(33).draw(graphics, EditConfigScreen.this.dividerX, y, 1, this.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseY() >= 20) {
                this.playClickSound();
                this.configValue.onClicked(button, accepted -> this.run());
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (this.getMouseY() > 18) {
                list.add((Component)this.keyText.m_6881_().m_130940_(ChatFormatting.UNDERLINE));
                String tooltip = this.configValue.getTooltip();
                if (!tooltip.isEmpty()) {
                    for (String s : tooltip.split("\n")) {
                        list.styledString(s, Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)));
                    }
                }
                list.blankLine();
                this.configValue.addInfo(list);
            }
        }
    }
}

