/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.datagen.assets;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDEffects;
import com.kyanite.deeperdarker.content.DDEnchantments;
import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.content.entities.DDBoat;
import com.kyanite.deeperdarker.content.entities.DDChestBoat;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;

public class ENLanguageProvider
extends LanguageProvider {
    public ENLanguageProvider(PackOutput output) {
        super(output, "deeperdarker", "en_us");
    }

    protected void addTranslations() {
        this.add("item.minecraft.tipped_arrow.effect.sculk_affinity", "Arrow of Sculk Affinity");
        this.add("item.minecraft.tipped_arrow.effect.long_sculk_affinity", "Arrow of Sculk Affinity");
        this.add("item.minecraft.potion.effect.sculk_affinity", "Potion of Sculk Affinity");
        this.add("item.minecraft.potion.effect.long_sculk_affinity", "Potion of Sculk Affinity");
        this.add("item.minecraft.splash_potion.effect.sculk_affinity", "Splash Potion of Sculk Affinity");
        this.add("item.minecraft.splash_potion.effect.long_sculk_affinity", "Splash Potion of Sculk Affinity");
        this.add("item.minecraft.lingering_potion.effect.sculk_affinity", "Lingering Potion of Sculk Affinity");
        this.add("item.minecraft.lingering_potion.effect.long_sculk_affinity", "Lingering Potion of Sculk Affinity");
        this.add("advancements.deeperdarker.root.title", "Sculk Story");
        this.add("advancements.deeperdarker.root.description", "You feel something pulling you towards the source...");
        this.add("advancements.deeperdarker.find_ancient_city.title", "A Metropolis of Restless Souls");
        this.add("advancements.deeperdarker.find_ancient_city.description", "Find an Ancient City");
        this.add("advancements.deeperdarker.kill_warden.title", "Phantom Thief");
        this.add("advancements.deeperdarker.kill_warden.description", "Slay the Warden and take its heart");
        this.add("advancements.deeperdarker.enter_otherside.title", "Below the Bedrock");
        this.add("advancements.deeperdarker.enter_otherside.description", "Deep below the bedrock, the darkness awaits");
        this.add("advancements.deeperdarker.find_ancient_temple.title", "Abyssal Descent");
        this.add("advancements.deeperdarker.find_ancient_temple.description", "Explore the depths for a temple");
        this.add("advancements.deeperdarker.obtain_sculk_transmitter.title", "Remote Storage");
        this.add("advancements.deeperdarker.obtain_sculk_transmitter.description", "Acquire a Sculk Transmitter");
        this.add("advancements.deeperdarker.explore_otherside.title", "Echolocation");
        this.add("advancements.deeperdarker.explore_otherside.description", "Explore all Otherside biomes");
        this.add("advancements.deeperdarker.kill_all_sculk_mobs.title", "Sculk Slayer");
        this.add("advancements.deeperdarker.kill_all_sculk_mobs.description", "Kill one of every Sculk monster");
        this.add("advancements.deeperdarker.obtain_reinforce_echo_shard.title", "Sculk Engineer");
        this.add("advancements.deeperdarker.obtain_reinforce_echo_shard.description", "Reinforce an Echo Shard");
        this.add("advancements.deeperdarker.warden_armor.title", "Cover Me with Sculk");
        this.add("advancements.deeperdarker.warden_armor.description", "Protect yourself with a full set of Warden Armor");
        this.add("itemGroup.deeperdarker", "Deeper and Darker");
        this.add("block.deeperdarker.linked", "Linked transmitter");
        this.add("block.deeperdarker.unlinked", "Unlinked transmitter");
        this.add("block.deeperdarker.not_transmittable", "Cannot link to block");
        this.add("block.deeperdarker.not_found", "The linked block is missing or unloaded");
        this.add("tooltips.deeperdarker.sculk_transmitter.linked", "Linked to %1$s");
        this.add("tooltips.deeperdarker.sculk_transmitter.location", "Located at %1$s, %2$s, %3$s");
        this.add("tooltips.deeperdarker.sculk_transmitter.not_linked", "Unlinked");
        this.add("item.deeperdarker.smithing_template.warden_upgrade.applies_to", "Netherite Equipment");
        this.add("item.deeperdarker.smithing_template.warden_upgrade.ingredients", "Reinforced Echo Shard");
        this.add("item.deeperdarker.smithing_template.warden_upgrade.base_slot_description", "Add netherite armor, weapon, or tool");
        this.add("item.deeperdarker.smithing_template.warden_upgrade.additions_slot_description", "Add Reinforced Echo Shard");
        this.add("upgrade.deeperdarker.warden_upgrade", "Warden Upgrade");
        this.add("subtitles.ambient.otherside.additions", "Warden dreams");
        this.add("subtitles.ambient.portal.groan", "The Otherside forebodes");
        this.add("subtitles.entity.snapper.ambient", "Sculk Snapper breathes");
        this.add("subtitles.entity.snapper.bite", "Sculk Snapper bites");
        this.add("subtitles.entity.snapper.hurt", "Sculk Snapper hurts");
        this.add("subtitles.entity.snapper.sniff", "Sculk Snapper sniffs");
        this.add("subtitles.entity.shattered.ambient", "Shattered growls");
        this.add("subtitles.entity.shattered.death", "Shattered dies");
        this.add("subtitles.entity.shattered.hurt", "Shattered hurts");
        this.add("subtitles.entity.shriek_worm.ambient", "Shriek Worm cries");
        this.add("subtitles.entity.shriek_worm.death", "Shriek Worm dies");
        this.add("subtitles.entity.shriek_worm.hurt", "Shriek Worm hurts");
        this.add("subtitles.entity.stalker.ambient", "Stalker chirps");
        this.add("subtitles.entity.stalker.death", "Stalker dies");
        this.add("subtitles.entity.stalker.hurt", "Stalker hurts");
        this.add("subtitles.item.transmitter.error", "Transmitter fails");
        this.add("subtitles.item.transmitter.link", "Transmitter links");
        this.add("subtitles.item.transmitter.open", "Transmitter transmits");
        this.add("subtitles.item.transmitter.unlink", "Transmitter unlinks");
        DDBlocks.BLOCKS.getEntries().forEach(block -> this.add((RegistryObject<?>)block, "block"));
        DDItems.ITEMS.getEntries().stream().filter((? super T item) -> !(item.get() instanceof BlockItem)).forEach(item -> this.add((RegistryObject<?>)item, "item"));
        DDEntities.ENTITIES.getEntries().forEach(entity -> this.add((RegistryObject<?>)entity, "entity"));
        DDEffects.EFFECTS.getEntries().forEach(effect -> this.add((RegistryObject<?>)effect, "effect"));
        DDEnchantments.ENCHANTMENTS.getEntries().forEach(effect -> this.add((RegistryObject<?>)effect, "enchantment"));
    }

    private void add(RegistryObject<?> entry, String prefix) {
        if (this.filter(entry)) {
            return;
        }
        String key = entry.getId().m_135815_();
        this.add(prefix + ".deeperdarker." + key, this.convertToName(key));
    }

    private boolean filter(RegistryObject<?> entry) {
        return entry.get() instanceof WallSignBlock || entry.get() instanceof WallHangingSignBlock || entry.get() instanceof DDBoat || entry.get() instanceof DDChestBoat || entry.get() instanceof SmithingTemplateItem;
    }

    private String convertToName(String key) {
        StringBuilder builder = new StringBuilder(key.substring(0, 1).toUpperCase() + key.substring(1));
        for (int i = 1; i < builder.length(); ++i) {
            if (builder.charAt(i) != '_') continue;
            builder.deleteCharAt(i);
            builder.replace(i, i + 1, " " + Character.toUpperCase(builder.charAt(i)));
        }
        Object name = builder.toString();
        if (((String)name).contains("Chest ")) {
            name = ((String)name).replace("Chest ", "") + " With Chest";
        }
        if (((String)name).contains("Lapis")) {
            name = ((String)name).replace("Lapis", "Lapis Lazuli");
        }
        if (((String)name).contains("Of The")) {
            name = ((String)name).replace("Of The", "of the");
        }
        if (((String)name).contains("With")) {
            name = ((String)name).replace("With", "with");
        }
        return name;
    }
}

