/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.datagen.assets;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDItems;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class DDItemModelProvider
extends ItemModelProvider {
    private final ModelFile GENERATED = this.getExistingFile(this.mcLoc("item/generated"));
    private final ModelFile HANDHELD = this.getExistingFile(this.mcLoc("item/handheld"));

    public DDItemModelProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "deeperdarker", exFileHelper);
    }

    protected void registerModels() {
        this.blockModel(DDBlocks.ECHO_LOG);
        this.blockModel(DDBlocks.ECHO_WOOD);
        this.blockModel(DDBlocks.STRIPPED_ECHO_LOG);
        this.blockModel(DDBlocks.STRIPPED_ECHO_WOOD);
        this.blockModel(DDBlocks.ECHO_PLANKS);
        this.blockModel(DDBlocks.ECHO_STAIRS);
        this.blockModel(DDBlocks.ECHO_SLAB);
        this.blockModel(DDBlocks.ECHO_FENCE, "inventory");
        this.blockModel(DDBlocks.ECHO_FENCE_GATE);
        this.itemModel(DDBlocks.ECHO_DOOR, this.GENERATED).renderType("translucent");
        this.blockModel(DDBlocks.ECHO_TRAPDOOR, "bottom");
        this.blockModel(DDBlocks.ECHO_PRESSURE_PLATE);
        this.blockModel(DDBlocks.ECHO_BUTTON, "inventory");
        this.blockModel(DDBlocks.ECHO_LEAVES);
        this.blockItemModel(DDBlocks.ECHO_SAPLING, DDBlocks.ECHO_SAPLING, this.GENERATED);
        this.blockModel(DDBlocks.SCULK_STONE);
        this.blockModel(DDBlocks.SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.COBBLED_SCULK_STONE);
        this.blockModel(DDBlocks.COBBLED_SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.COBBLED_SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.COBBLED_SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.POLISHED_SCULK_STONE);
        this.blockModel(DDBlocks.POLISHED_SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.POLISHED_SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.POLISHED_SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.SCULK_STONE_BRICKS);
        this.blockModel(DDBlocks.SCULK_STONE_BRICK_STAIRS);
        this.blockModel(DDBlocks.SCULK_STONE_BRICK_SLAB);
        this.blockModel(DDBlocks.SCULK_STONE_BRICK_WALL, "inventory");
        this.blockModel(DDBlocks.SCULK_STONE_TILES);
        this.blockModel(DDBlocks.SCULK_STONE_TILE_STAIRS);
        this.blockModel(DDBlocks.SCULK_STONE_TILE_SLAB);
        this.blockModel(DDBlocks.SCULK_STONE_TILE_WALL, "inventory");
        this.blockModel(DDBlocks.SMOOTH_SCULK_STONE);
        this.blockModel(DDBlocks.SMOOTH_SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.SMOOTH_SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.SMOOTH_SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.CUT_SCULK_STONE);
        this.blockModel(DDBlocks.CUT_SCULK_STONE_STAIRS);
        this.blockModel(DDBlocks.CUT_SCULK_STONE_SLAB);
        this.blockModel(DDBlocks.CUT_SCULK_STONE_WALL, "inventory");
        this.blockModel(DDBlocks.CHISELED_SCULK_STONE);
        this.blockModel(DDBlocks.GLOOMSLATE);
        this.blockModel(DDBlocks.GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.COBBLED_GLOOMSLATE);
        this.blockModel(DDBlocks.COBBLED_GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.COBBLED_GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.COBBLED_GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.POLISHED_GLOOMSLATE);
        this.blockModel(DDBlocks.POLISHED_GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.POLISHED_GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.POLISHED_GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.GLOOMSLATE_BRICKS);
        this.blockModel(DDBlocks.GLOOMSLATE_BRICK_STAIRS);
        this.blockModel(DDBlocks.GLOOMSLATE_BRICK_SLAB);
        this.blockModel(DDBlocks.GLOOMSLATE_BRICK_WALL, "inventory");
        this.blockModel(DDBlocks.GLOOMSLATE_TILES);
        this.blockModel(DDBlocks.GLOOMSLATE_TILE_STAIRS);
        this.blockModel(DDBlocks.GLOOMSLATE_TILE_SLAB);
        this.blockModel(DDBlocks.GLOOMSLATE_TILE_WALL, "inventory");
        this.blockModel(DDBlocks.SMOOTH_GLOOMSLATE);
        this.blockModel(DDBlocks.SMOOTH_GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.SMOOTH_GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.SMOOTH_GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.CUT_GLOOMSLATE);
        this.blockModel(DDBlocks.CUT_GLOOMSLATE_STAIRS);
        this.blockModel(DDBlocks.CUT_GLOOMSLATE_SLAB);
        this.blockModel(DDBlocks.CUT_GLOOMSLATE_WALL, "inventory");
        this.blockModel(DDBlocks.CHISELED_GLOOMSLATE);
        this.blockModel(DDBlocks.SCULK_GRIME);
        this.blockModel(DDBlocks.SCULK_GRIME_BRICKS);
        this.blockModel(DDBlocks.SCULK_GRIME_BRICK_STAIRS);
        this.blockModel(DDBlocks.SCULK_GRIME_BRICK_SLAB);
        this.blockModel(DDBlocks.SCULK_GRIME_BRICK_WALL, "inventory");
        this.blockModel(DDBlocks.ECHO_SOIL);
        this.blockModel(DDBlocks.GLOOMY_SCULK);
        this.blockModel(DDBlocks.GLOOMY_GEYSER);
        this.blockModel(DDBlocks.CRYSTALLIZED_AMBER);
        this.blockModel(DDBlocks.SCULK_GLEAM);
        this.blockModel(DDBlocks.SCULK_STONE_COAL_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_IRON_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_COPPER_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_GOLD_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_REDSTONE_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_EMERALD_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_LAPIS_ORE);
        this.blockModel(DDBlocks.SCULK_STONE_DIAMOND_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_COAL_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_IRON_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_COPPER_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_GOLD_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_REDSTONE_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_EMERALD_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_LAPIS_ORE);
        this.blockModel(DDBlocks.GLOOMSLATE_DIAMOND_ORE);
        this.blockItemModel(DDBlocks.GLOOMY_GRASS, DDBlocks.GLOOMY_GRASS, this.GENERATED);
        this.blockModel(DDBlocks.GLOOMY_CACTUS);
        this.blockItemModel(DDBlocks.SCULK_TENDRILS, DDBlocks.SCULK_TENDRILS_PLANT, this.GENERATED);
        this.blockItemModel(DDBlocks.SCULK_VINES, DDBlocks.SCULK_VINES_PLANT, this.GENERATED);
        this.blockModel(DDBlocks.ANCIENT_VASE);
        this.withExistingParent(DDBlocks.INFESTED_SCULK.getId().m_135815_(), this.mcLoc("block/sculk"));
        this.blockModel(DDBlocks.SCULK_JAW);
        this.itemModelWithSuffix(DDItems.SOUL_ELYTRA, this.GENERATED, "broken");
        this.itemModel(DDItems.ECHO_SIGN, this.GENERATED);
        this.itemModel(DDItems.ECHO_HANGING_SIGN, this.GENERATED);
        this.itemModel(DDItems.ECHO_BOAT, this.GENERATED);
        this.itemModel(DDItems.ECHO_CHEST_BOAT, this.GENERATED);
        this.itemModel(DDItems.GRIME_BALL, this.GENERATED);
        this.itemModel(DDItems.GRIME_BRICK, this.GENERATED);
        this.itemModel(DDItems.WARDEN_SHOVEL, this.HANDHELD);
        this.itemModel(DDItems.WARDEN_PICKAXE, this.HANDHELD);
        this.itemModel(DDItems.WARDEN_AXE, this.HANDHELD);
        this.itemModel(DDItems.WARDEN_HOE, this.HANDHELD);
        this.itemModel(DDItems.WARDEN_SWORD, this.HANDHELD);
        this.itemModel(DDItems.WARDEN_HELMET, this.GENERATED);
        this.itemModel(DDItems.WARDEN_CHESTPLATE, this.GENERATED);
        this.itemModel(DDItems.WARDEN_LEGGINGS, this.GENERATED);
        this.itemModel(DDItems.WARDEN_BOOTS, this.GENERATED);
        this.itemModel(DDItems.SCULK_BONE, this.GENERATED);
        this.itemModel(DDItems.SOUL_DUST, this.GENERATED);
        this.itemModel(DDItems.SOUL_CRYSTAL, this.GENERATED);
        this.itemModel(DDItems.HEART_OF_THE_DEEP, this.GENERATED);
        this.itemModel(DDItems.WARDEN_CARAPACE, this.GENERATED);
        this.itemModel(DDItems.REINFORCED_ECHO_SHARD, this.GENERATED);
        this.itemModelWithSuffix(DDItems.SCULK_TRANSMITTER, this.GENERATED, "on");
        this.itemModel(DDItems.WARDEN_UPGRADE_SMITHING_TEMPLATE, this.GENERATED);
        this.spawnEggModel(DDItems.SCULK_CENTIPEDE_SPAWN_EGG);
        this.spawnEggModel(DDItems.SCULK_LEECH_SPAWN_EGG);
        this.spawnEggModel(DDItems.SCULK_SNAPPER_SPAWN_EGG);
        this.spawnEggModel(DDItems.SHATTERED_SPAWN_EGG);
        this.spawnEggModel(DDItems.SHRIEK_WORM_SPAWN_EGG);
        this.spawnEggModel(DDItems.STALKER_SPAWN_EGG);
    }

    private void spawnEggModel(RegistryObject<Item> egg) {
        this.withExistingParent(egg.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
    }

    public void blockModel(RegistryObject<? extends Block> block) {
        this.withExistingParent(block.getId().m_135815_(), this.modLoc("block/" + block.getId().m_135815_()));
    }

    public void blockModel(RegistryObject<? extends Block> block, String suffix) {
        this.withExistingParent(block.getId().m_135815_(), this.modLoc("block/" + block.getId().m_135815_() + "_" + suffix));
    }

    public void blockItemModel(RegistryObject<?> block, RegistryObject<?> textureBlock, ModelFile modelFile) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(block.getId().m_135815_())).parent(modelFile)).texture("layer0", "block/" + textureBlock.getId().m_135815_());
    }

    public ItemModelBuilder itemModel(RegistryObject<?> item, ModelFile modelFile) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent(modelFile)).texture("layer0", "item/" + item.getId().m_135815_());
    }

    public void itemModelWithSuffix(RegistryObject<?> item, ModelFile modelFile, String suffix) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_() + "_" + suffix)).parent(modelFile)).texture("layer0", "item/" + item.getId().m_135815_() + "_" + suffix);
    }
}

