/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker;

import com.kyanite.deeperdarker.client.model.SculkCentipedeModel;
import com.kyanite.deeperdarker.client.model.SculkLeechModel;
import com.kyanite.deeperdarker.client.model.SculkSnapperModel;
import com.kyanite.deeperdarker.client.model.ShatteredModel;
import com.kyanite.deeperdarker.client.model.ShriekWormModel;
import com.kyanite.deeperdarker.client.model.StalkerModel;
import com.kyanite.deeperdarker.client.model.WardenHelmetModel;
import com.kyanite.deeperdarker.client.render.DDBoatRenderer;
import com.kyanite.deeperdarker.client.render.SculkCentipedeRenderer;
import com.kyanite.deeperdarker.client.render.SculkLeechRenderer;
import com.kyanite.deeperdarker.client.render.SculkSnapperRenderer;
import com.kyanite.deeperdarker.client.render.ShatteredRenderer;
import com.kyanite.deeperdarker.client.render.ShriekWormRenderer;
import com.kyanite.deeperdarker.client.render.SoulElytraRenderer;
import com.kyanite.deeperdarker.client.render.StalkerRenderer;
import com.kyanite.deeperdarker.client.render.WardenHelmetRenderer;
import com.kyanite.deeperdarker.content.DDBlockEntities;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDEffects;
import com.kyanite.deeperdarker.content.DDEnchantments;
import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.content.DDLootModifiers;
import com.kyanite.deeperdarker.content.DDPotions;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.content.entities.SculkCentipede;
import com.kyanite.deeperdarker.content.entities.SculkLeech;
import com.kyanite.deeperdarker.content.entities.SculkSnapper;
import com.kyanite.deeperdarker.content.entities.Shattered;
import com.kyanite.deeperdarker.content.entities.ShriekWorm;
import com.kyanite.deeperdarker.content.entities.Stalker;
import com.kyanite.deeperdarker.content.items.SoulElytraItem;
import com.kyanite.deeperdarker.datagen.assets.DDBlockStateProvider;
import com.kyanite.deeperdarker.datagen.assets.DDItemModelProvider;
import com.kyanite.deeperdarker.datagen.assets.DDSoundDefinitions;
import com.kyanite.deeperdarker.datagen.assets.ENLanguageProvider;
import com.kyanite.deeperdarker.datagen.data.DDAdvancements;
import com.kyanite.deeperdarker.datagen.data.DDBlockTagsProvider;
import com.kyanite.deeperdarker.datagen.data.DDItemTagsProvider;
import com.kyanite.deeperdarker.datagen.data.DDRecipeProvider;
import com.kyanite.deeperdarker.datagen.data.DDWorldGeneration;
import com.kyanite.deeperdarker.datagen.data.loot.DDLootModifierProvider;
import com.kyanite.deeperdarker.datagen.data.loot.DDLootTableProvider;
import com.kyanite.deeperdarker.util.DDCreativeTab;
import com.kyanite.deeperdarker.world.DDFeatures;
import com.kyanite.deeperdarker.world.otherside.OthersideDimension;
import java.util.List;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="deeperdarker")
public class DeeperDarker {
    public static final String MOD_ID = "deeperdarker";

    public DeeperDarker() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DDCreativeTab.CREATIVE_MODE_TABS.register(eventBus);
        DDItems.ITEMS.register(eventBus);
        DDSounds.SOUND_EVENTS.register(eventBus);
        DDBlocks.BLOCKS.register(eventBus);
        DDBlockEntities.BLOCK_ENTITIES.register(eventBus);
        DDEntities.ENTITIES.register(eventBus);
        DDEffects.EFFECTS.register(eventBus);
        DDPotions.POTIONS.register(eventBus);
        DDEnchantments.ENCHANTMENTS.register(eventBus);
        DDFeatures.FEATURES.register(eventBus);
        OthersideDimension.POI.register(eventBus);
        DDLootModifiers.LOOT_MODIFIERS.register(eventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        eventBus.addListener(DDCreativeTab::buildCreativeTab);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::generateData);
        eventBus.addListener(this::registerAttributes);
        eventBus.addListener(this::registerSpawnPlacements);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.f_50276_).addPlant(DDBlocks.ECHO_SAPLING.getId(), DDBlocks.POTTED_ECHO_SAPLING));
        PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)DDItems.SOUL_CRYSTAL.get()), (Potion)((Potion)DDPotions.SCULK_AFFINITY.get()));
        PotionBrewing.m_43513_((Potion)Potions.f_43605_, (Item)((Item)DDItems.SOUL_DUST.get()), (Potion)((Potion)DDPotions.SCULK_AFFINITY.get()));
        PotionBrewing.m_43513_((Potion)((Potion)DDPotions.SCULK_AFFINITY.get()), (Item)Items.f_42451_, (Potion)((Potion)DDPotions.LONG_SCULK_AFFINITY.get()));
        PotionBrewing.m_43513_((Potion)Potions.f_43606_, (Item)((Item)DDItems.SOUL_DUST.get()), (Potion)((Potion)DDPotions.LONG_SCULK_AFFINITY.get()));
    }

    private void generateData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ENLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new DDBlockStateProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new DDItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new DDSoundDefinitions(packOutput, fileHelper));
        DDBlockTagsProvider blockTags = new DDBlockTagsProvider(packOutput, event.getLookupProvider(), fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new DDItemTagsProvider(packOutput, event.getLookupProvider(), (TagsProvider<Block>)blockTags, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(packOutput, event.getLookupProvider(), fileHelper, List.of(new DDAdvancements())));
        generator.addProvider(event.includeServer(), (DataProvider)new DDWorldGeneration(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new DDLootTableProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new DDLootModifierProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new DDRecipeProvider(packOutput));
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DDEntities.SCULK_CENTIPEDE.get(), SculkCentipede.createAttributes());
        event.put((EntityType)DDEntities.SCULK_LEECH.get(), SculkLeech.createAttributes());
        event.put((EntityType)DDEntities.SCULK_SNAPPER.get(), SculkSnapper.createAttributes());
        event.put((EntityType)DDEntities.SHATTERED.get(), Shattered.createAttributes());
        event.put((EntityType)DDEntities.SHRIEK_WORM.get(), ShriekWorm.createAttributes());
        event.put((EntityType)DDEntities.STALKER.get(), Stalker.createAttributes());
    }

    private void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)DDEntities.SCULK_CENTIPEDE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)DDEntities.SCULK_SNAPPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)DDEntities.SHATTERED.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    @Mod.EventBusSubscriber(modid="deeperdarker", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class DeeperDarkerClient {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                Sheets.addWoodType((WoodType)DDBlocks.ECHO);
                ItemProperties.register((Item)((Item)DDItems.SOUL_ELYTRA.get()), (ResourceLocation)new ResourceLocation("broken"), (pStack, pLevel, pEntity, pSeed) -> SoulElytraItem.m_41140_((ItemStack)pStack) ? 0.0f : 1.0f);
                ItemProperties.register((Item)((Item)DDItems.SCULK_TRANSMITTER.get()), (ResourceLocation)new ResourceLocation(DeeperDarker.MOD_ID, "linked"), (pStack, pLevel, pEntity, pSeed) -> pStack.m_41782_() ? 1.0f : 0.0f);
            });
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)DDBlockEntities.DEEPER_DARKER_SIGNS.get()), SignRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)DDBlockEntities.DEEPER_DARKER_HANGING_SIGNS.get()), HangingSignRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.BOAT.get()), context -> new DDBoatRenderer(context, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.CHEST_BOAT.get()), context -> new DDBoatRenderer(context, true));
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SCULK_CENTIPEDE.get()), SculkCentipedeRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SCULK_LEECH.get()), SculkLeechRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SCULK_SNAPPER.get()), SculkSnapperRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SHATTERED.get()), ShatteredRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.SHRIEK_WORM.get()), ShriekWormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)DDEntities.STALKER.get()), StalkerRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(DDBoatRenderer.ECHO_BOAT_MODEL, BoatModel::m_246613_);
            event.registerLayerDefinition(DDBoatRenderer.ECHO_CHEST_BOAT_MODEL, ChestBoatModel::m_247175_);
            event.registerLayerDefinition(SculkCentipedeRenderer.MODEL, SculkCentipedeModel::createBodyModel);
            event.registerLayerDefinition(SculkLeechRenderer.MODEL, SculkLeechModel::createBodyModel);
            event.registerLayerDefinition(SculkSnapperRenderer.MODEL, SculkSnapperModel::createBodyModel);
            event.registerLayerDefinition(ShatteredRenderer.MODEL, ShatteredModel::createBodyModel);
            event.registerLayerDefinition(ShriekWormRenderer.MODEL, ShriekWormModel::createBodyModel);
            event.registerLayerDefinition(StalkerRenderer.MODEL, StalkerModel::createBodyModel);
            event.registerLayerDefinition(WardenHelmetRenderer.MODEL, WardenHelmetModel::createBodyModel);
        }

        @SubscribeEvent
        public static void addLayers(EntityRenderersEvent.AddLayers event) {
            event.getSkins().forEach(name -> {
                LivingEntityRenderer patt12039$temp = event.getSkin(name);
                if (patt12039$temp instanceof PlayerRenderer) {
                    PlayerRenderer renderer = (PlayerRenderer)patt12039$temp;
                    renderer.m_115326_(new SoulElytraRenderer(renderer, event.getEntityModels()));
                    renderer.m_115326_(new WardenHelmetRenderer(renderer, event.getEntityModels()));
                }
            });
            LivingEntityRenderer livingEntityRenderer = event.getRenderer(EntityType.f_20529_);
            if (livingEntityRenderer instanceof ArmorStandRenderer) {
                ArmorStandRenderer renderer = (ArmorStandRenderer)livingEntityRenderer;
                renderer.m_115326_(new SoulElytraRenderer(renderer, event.getEntityModels()));
                renderer.m_115326_(new WardenHelmetRenderer(renderer, event.getEntityModels()));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="deeperdarker")
    public static class DeeperDarkerEvents {
        @SubscribeEvent
        public static void breakEvent(BlockEvent.BreakEvent event) {
            ServerLevel level;
            RandomSource random;
            if (!event.getState().m_60713_((Block)DDBlocks.ANCIENT_VASE.get())) {
                return;
            }
            if (event.getPlayer().m_21205_().getEnchantmentLevel(Enchantments.f_44985_) > 0) {
                return;
            }
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel && (random = (level = (ServerLevel)levelAccessor).m_213780_()).m_188501_() < 0.1f) {
                if (random.m_188501_() < 0.953f) {
                    for (int i = 0; i < random.m_216339_(1, 4); ++i) {
                        ((EntityType)DDEntities.SCULK_LEECH.get()).m_262496_(level, event.getPos(), MobSpawnType.TRIGGERED);
                    }
                } else {
                    ((EntityType)DDEntities.STALKER.get()).m_262496_(level, event.getPos(), MobSpawnType.TRIGGERED);
                }
            }
        }
    }
}

