/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.function.Predicate;
import mc.craig.software.angels.common.CatacombTracker;
import mc.craig.software.angels.common.WAEntities;
import mc.craig.software.angels.common.entity.angel.WeepingAngel;
import mc.craig.software.angels.common.entity.angel.ai.AngelVariant;
import mc.craig.software.angels.donators.DonationChecker;
import mc.craig.software.angels.donators.Donator;
import mc.craig.software.angels.util.WATags;
import mc.craig.software.angels.util.forge.WAHelperImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WAHelper {
    public static Predicate<? super Entity> ANOMALY_ENTITIES = input -> input.m_6095_().m_204039_(WATags.ANOMALYS);

    public static List<Entity> getAnomaliesAroundEntity(Entity entity, int radius) {
        return entity.m_9236_().m_6249_((Entity)null, entity.m_20191_().m_82377_((double)radius, (double)radius, (double)radius), ANOMALY_ENTITIES);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Packet<ClientGamePacketListener> spawnPacket(Entity livingEntity) {
        return WAHelperImpl.spawnPacket(livingEntity);
    }

    public static void onPlayerTick(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!player.m_9236_().f_46443_) {
                boolean isInCatacomb = CatacombTracker.isInCatacomb((LivingEntity)player);
                RandomSource randomSource = serverPlayer.m_9236_().m_213780_();
                if (player.f_19797_ % 40 == 0) {
                    CatacombTracker.tellClient(serverPlayer, isInCatacomb);
                }
                if (isInCatacomb && serverPlayer.f_19797_ % 200 == 0) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)WAHelper.getRandomSounds(randomSource)), SoundSource.AMBIENT, player.m_20185_() + (double)randomSource.m_188503_(18), player.m_20186_() + (double)randomSource.m_188503_(18), player.m_20189_() + (double)randomSource.m_188503_(18), 0.25f, 1.0f, serverPlayer.m_9236_().f_46441_.m_188505_()));
                }
            }
            if (player.m_9236_().m_5776_()) {
                for (Donator donator : DonationChecker.getModDonators()) {
                    if (!player.m_20149_().equals(donator.getUuid())) continue;
                    donator.tick(player);
                }
            }
        }
    }

    public static boolean spawnWeepingAngel(ServerLevel serverLevel, BlockPos blockPos, AngelVariant angelVariant, boolean dropsLoot, float rotation) {
        WeepingAngel weepingAngel = (WeepingAngel)WAEntities.WEEPING_ANGEL.get().m_20615_((Level)serverLevel);
        weepingAngel.setVariant(angelVariant);
        weepingAngel.setDrops(dropsLoot);
        weepingAngel.m_19890_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, rotation, 0.0f);
        return serverLevel.m_7967_((Entity)weepingAngel);
    }

    public static Vec3 fogColor() {
        return new Vec3((double)0.14f, (double)0.15f, (double)0.22f);
    }

    public static boolean intersects(AABB bb, Vec3 min, Vec3 max) {
        return bb.m_82314_(Math.min(min.f_82479_, max.f_82479_), Math.min(min.f_82480_, max.f_82480_), Math.min(min.f_82481_, max.f_82481_), Math.max(min.f_82479_, max.f_82479_), Math.max(min.f_82480_, max.f_82480_), Math.max(min.f_82481_, max.f_82481_));
    }

    public static Structure getConfigured(ServerLevel level, ResourceLocation resourceLocation) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_256944_);
        return (Structure)registry.m_7745_(resourceLocation);
    }

    public static SoundEvent getRandomSounds(RandomSource randomSource) {
        SoundEvent[] soundEvents = new SoundEvent[]{(SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundEvents.f_12084_, SoundEvents.f_215750_};
        return soundEvents[randomSource.m_188503_(soundEvents.length)];
    }
}

