/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Predicate;
import mc.craig.software.angels.common.entity.angel.AbstractWeepingAngel;
import mc.craig.software.angels.util.forge.ViewUtilImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class ViewUtil {
    private static final float headSize = 0.15f;

    public static boolean isInFrontOfEntity(LivingEntity entity, Entity target, boolean vr) {
        Vec3 vecTargetsPos = target.m_20182_();
        Vec3 vecLook = entity.m_20154_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (vr) {
                vecLook = ViewUtil.manipulateVrRotation(player, entity.m_20154_());
            }
        }
        Vec3 vecFinal = vecTargetsPos.m_82505_(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())).m_82541_();
        vecFinal = new Vec3(vecFinal.f_82479_, 0.0, vecFinal.f_82481_);
        return vecFinal.m_82526_(vecLook) < 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Vec3 manipulateVrRotation(Player player, Vec3 vec3) {
        void var1_1;
        return ViewUtilImpl.manipulateVrRotation(player, (Vec3)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Vec3 manipulateVrPosition(Player player, Vec3 vec3) {
        void var1_1;
        return ViewUtilImpl.manipulateVrPosition(player, (Vec3)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isVrPlayer(Player player) {
        return ViewUtilImpl.isVrPlayer(player);
    }

    public static boolean isInSight(LivingEntity livingBase, AbstractWeepingAngel angel) {
        if (ViewUtil.isPlayerBlind(livingBase)) {
            return false;
        }
        if (ViewUtil.viewBlocked(livingBase, (LivingEntity)angel)) {
            return false;
        }
        if (livingBase instanceof Player) {
            Player player = (Player)livingBase;
            return ViewUtil.isInFrontOfEntity(livingBase, (Entity)angel, ViewUtil.isVrPlayer(player));
        }
        return ViewUtil.isInFrontOfEntity(livingBase, (Entity)angel, false);
    }

    public static boolean viewBlocked(LivingEntity viewer, LivingEntity angel) {
        AABB viewerBoundBox = viewer.m_20191_();
        AABB angelBoundingBox = angel.m_20191_();
        Vec3[] viewerPoints = new Vec3[]{new Vec3(viewerBoundBox.f_82288_, viewerBoundBox.f_82289_, viewerBoundBox.f_82290_), new Vec3(viewerBoundBox.f_82288_, viewerBoundBox.f_82289_, viewerBoundBox.f_82293_), new Vec3(viewerBoundBox.f_82288_, viewerBoundBox.f_82292_, viewerBoundBox.f_82290_), new Vec3(viewerBoundBox.f_82288_, viewerBoundBox.f_82292_, viewerBoundBox.f_82293_), new Vec3(viewerBoundBox.f_82291_, viewerBoundBox.f_82292_, viewerBoundBox.f_82290_), new Vec3(viewerBoundBox.f_82291_, viewerBoundBox.f_82292_, viewerBoundBox.f_82293_), new Vec3(viewerBoundBox.f_82291_, viewerBoundBox.f_82289_, viewerBoundBox.f_82293_), new Vec3(viewerBoundBox.f_82291_, viewerBoundBox.f_82289_, viewerBoundBox.f_82290_)};
        if (viewer instanceof Player) {
            Player player = (Player)viewer;
            Vec3 pos2 = new Vec3(viewer.m_20185_(), viewer.m_20186_() + (double)1.62f, viewer.m_20189_());
            if (ViewUtil.isVrPlayer(player)) {
                pos2 = ViewUtil.manipulateVrPosition(player, pos2);
            }
            viewerPoints[0] = pos2.m_82520_((double)-0.15f, (double)-0.15f, (double)-0.15f);
            viewerPoints[1] = pos2.m_82520_((double)-0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[2] = pos2.m_82520_((double)-0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[3] = pos2.m_82520_((double)-0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[4] = pos2.m_82520_((double)0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[5] = pos2.m_82520_((double)0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[6] = pos2.m_82520_((double)0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[7] = pos2.m_82520_((double)0.15f, (double)-0.15f, (double)-0.15f);
        }
        Vec3[] angelPoints = new Vec3[]{new Vec3(angelBoundingBox.f_82288_, angelBoundingBox.f_82289_, angelBoundingBox.f_82290_), new Vec3(angelBoundingBox.f_82288_, angelBoundingBox.f_82289_, angelBoundingBox.f_82293_), new Vec3(angelBoundingBox.f_82288_, angelBoundingBox.f_82292_, angelBoundingBox.f_82290_), new Vec3(angelBoundingBox.f_82288_, angelBoundingBox.f_82292_, angelBoundingBox.f_82293_), new Vec3(angelBoundingBox.f_82291_, angelBoundingBox.f_82292_, angelBoundingBox.f_82290_), new Vec3(angelBoundingBox.f_82291_, angelBoundingBox.f_82292_, angelBoundingBox.f_82293_), new Vec3(angelBoundingBox.f_82291_, angelBoundingBox.f_82289_, angelBoundingBox.f_82293_), new Vec3(angelBoundingBox.f_82291_, angelBoundingBox.f_82289_, angelBoundingBox.f_82290_)};
        for (int i = 0; i < viewerPoints.length; ++i) {
            if (viewer.m_9236_().m_45547_(new ClipContext(viewerPoints[i], angelPoints[i], ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)viewer)).m_6662_() == HitResult.Type.MISS) {
                return false;
            }
            if (ViewUtil.rayTraceBlocks(viewer, viewer.m_9236_(), viewerPoints[i], angelPoints[i], pos -> {
                BlockState state = viewer.m_9236_().m_8055_(pos);
                return !ViewUtil.canSeeThrough(state, viewer.m_9236_(), pos);
            }) != null) continue;
            return false;
        }
        if (angel.f_19797_ % 1200 == 0 && angel.m_20270_((Entity)viewer) < 15.0f) {
            viewer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 15));
        }
        return true;
    }

    public static boolean isDarkForPlayer(AbstractWeepingAngel angel, LivingEntity living) {
        return !living.m_21023_(MobEffects.f_19611_) && angel.m_9236_().m_7146_(angel.m_20183_()) <= 0 && !angel.m_9236_().m_6042_().f_63856_();
    }

    public static boolean isPlayerBlind(LivingEntity living) {
        return living.m_21023_(MobEffects.f_19610_);
    }

    private static HitResult rayTraceBlocks(LivingEntity livingEntity, Level world, Vec3 startVec, Vec3 endVec, Predicate<BlockPos> stopOn) {
        BlockHitResult result;
        if (ViewUtil.hasNaN(startVec) || ViewUtil.hasNaN(endVec)) {
            return null;
        }
        int startX = Mth.m_14107_((double)startVec.f_82479_);
        int startY = Mth.m_14107_((double)startVec.f_82480_);
        int startZ = Mth.m_14107_((double)startVec.f_82481_);
        int endX = Mth.m_14107_((double)endVec.f_82479_);
        int endY = Mth.m_14107_((double)endVec.f_82480_);
        int endZ = Mth.m_14107_((double)endVec.f_82481_);
        BlockPos currentPos = new BlockPos(startX, startY, startZ);
        if (stopOn.test(currentPos) && (result = world.m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity))) != null) {
            return result;
        }
        int maxIterations = 200;
        while (maxIterations-- >= 0) {
            BlockHitResult result2;
            Direction direction;
            double ratioZ;
            if (startX == endX && startY == endY && startZ == endZ) {
                return null;
            }
            boolean stepX = true;
            boolean stepY = true;
            boolean stepZ = true;
            double nextX = Double.POSITIVE_INFINITY;
            double nextY = Double.POSITIVE_INFINITY;
            double nextZ = Double.POSITIVE_INFINITY;
            if (endX > startX) {
                nextX = (double)startX + 1.0;
            } else if (endX < startX) {
                nextX = (double)startX + 0.0;
            } else {
                stepX = false;
            }
            if (endY > startY) {
                nextY = (double)startY + 1.0;
            } else if (endY < startY) {
                nextY = (double)startY + 0.0;
            } else {
                stepY = false;
            }
            if (endZ > startZ) {
                nextZ = (double)startZ + 1.0;
            } else if (endZ < startZ) {
                nextZ = (double)startZ + 0.0;
            } else {
                stepZ = false;
            }
            double deltaX = endVec.f_82479_ - startVec.f_82479_;
            double deltaY = endVec.f_82480_ - startVec.f_82480_;
            double deltaZ = endVec.f_82481_ - startVec.f_82481_;
            double ratioX = stepX ? (nextX - startVec.f_82479_) / deltaX : Double.POSITIVE_INFINITY;
            double ratioY = stepY ? (nextY - startVec.f_82480_) / deltaY : Double.POSITIVE_INFINITY;
            double d = ratioZ = stepZ ? (nextZ - startVec.f_82481_) / deltaZ : Double.POSITIVE_INFINITY;
            if (ratioX == -0.0) {
                ratioX = -1.0E-4;
            }
            if (ratioY == -0.0) {
                ratioY = -1.0E-4;
            }
            if (ratioZ == -0.0) {
                ratioZ = -1.0E-4;
            }
            if (ratioX < ratioY && ratioX < ratioZ) {
                direction = endX > startX ? Direction.WEST : Direction.EAST;
                startVec = new Vec3(nextX, startVec.f_82480_ + deltaY * ratioX, startVec.f_82481_ + deltaZ * ratioX);
            } else if (ratioY < ratioZ) {
                direction = endY > startY ? Direction.DOWN : Direction.UP;
                startVec = new Vec3(startVec.f_82479_ + deltaX * ratioY, nextY, startVec.f_82481_ + deltaZ * ratioY);
            } else {
                direction = endZ > startZ ? Direction.NORTH : Direction.SOUTH;
                startVec = new Vec3(startVec.f_82479_ + deltaX * ratioZ, startVec.f_82480_ + deltaY * ratioZ, nextZ);
            }
            if (!stopOn.test(currentPos = new BlockPos(startX = Mth.m_14107_((double)startVec.f_82479_) - (direction == Direction.EAST ? 1 : 0), startY = Mth.m_14107_((double)startVec.f_82480_) - (direction == Direction.UP ? 1 : 0), startZ = Mth.m_14107_((double)startVec.f_82481_) - (direction == Direction.SOUTH ? 1 : 0))) || (result2 = world.m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity))) == null) continue;
            return result2;
        }
        return null;
    }

    private static boolean hasNaN(Vec3 vec) {
        return Double.isNaN(vec.f_82479_) || Double.isNaN(vec.f_82480_) || Double.isNaN(vec.f_82481_);
    }

    public static boolean canSeeThrough(BlockState blockState, Level world, BlockPos pos) {
        if (!blockState.m_60815_() || !blockState.m_60804_((BlockGetter)world, pos)) {
            return true;
        }
        Block block = blockState.m_60734_();
        if (block instanceof DoorBlock) {
            return blockState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER;
        }
        if (!block.m_49966_().m_60815_()) {
            return true;
        }
        return blockState.m_60812_((BlockGetter)world, pos) == Shapes.m_83040_();
    }
}

