/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mc.craig.software.angels.WAConfiguration;
import mc.craig.software.angels.WeepingAngels;
import mc.craig.software.angels.common.WASounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class Teleporter {
    public static ServerLevel getRandomDimension(RandomSource rand, ServerLevel serverLevel) {
        MinecraftServer server = serverLevel.m_7654_();
        Iterable dimensions = server.m_129785_();
        ArrayList allowedDimensions = Lists.newArrayList((Iterable)dimensions);
        for (ServerLevel dimension : dimensions) {
            for (String dimName : (List)WAConfiguration.CONFIG.bannedDimensions.get()) {
                if (!dimension.m_46472_().m_135782_().toString().equalsIgnoreCase(dimName)) continue;
                allowedDimensions.remove(dimension);
            }
        }
        allowedDimensions.remove(server.m_129880_(Level.f_46429_));
        return (ServerLevel)allowedDimensions.get(rand.m_188503_(allowedDimensions.size()));
    }

    private static boolean canTeleportTo(BlockPos pPos, Level level, Entity entity) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)level, (BlockPos.MutableBlockPos)pPos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockpos = pPos.m_121996_((Vec3i)entity.m_20183_());
        return level.m_45756_(entity, entity.m_20191_().m_82338_(blockpos));
    }

    public static boolean performTeleport(Entity pEntity, ServerLevel pLevel, int pX, int pY, int pZ, float pYaw, float pPitch, boolean playSound) {
        WeepingAngels.LOGGER.debug("Teleported {} to {} {} {}", new Object[]{pEntity.m_5446_().getString(), pX, pY, pZ});
        BlockPos blockpos = new BlockPos(pX, pY, pZ);
        if (!Teleporter.canTeleportTo(blockpos, (Level)pLevel, pEntity)) {
            return false;
        }
        if (!Level.m_46741_((BlockPos)blockpos)) {
            return false;
        }
        float f = Mth.m_14177_((float)pYaw);
        float f1 = Mth.m_14177_((float)pPitch);
        if (pEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pEntity;
            if (playSound) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)WASounds.TELEPORT.get()), SoundSource.MASTER, (double)pX, (double)pY, (double)pZ, 0.25f, 1.0f, serverPlayer.m_9236_().f_46441_.m_188505_()));
            }
            ChunkPos chunkpos = new ChunkPos(new BlockPos(pX, pY, pZ));
            pLevel.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)pEntity.m_19879_());
            pEntity.m_8127_();
            if (serverPlayer.m_5803_()) {
                serverPlayer.m_6145_(true, true);
            }
            if (pLevel == pEntity.m_9236_()) {
                serverPlayer.f_8906_.m_9774_((double)pX, (double)pY, (double)pZ, f, f1);
            } else {
                serverPlayer.m_8999_(pLevel, (double)pX, (double)pY, (double)pZ, f, f1);
            }
            pEntity.m_5616_(f);
        } else {
            float f2 = Mth.m_14036_((float)f1, (float)-90.0f, (float)90.0f);
            if (pLevel == pEntity.m_9236_()) {
                pEntity.m_7678_((double)pX, (double)pY, (double)pZ, f, f2);
                pEntity.m_5616_(f);
            } else {
                pEntity.m_19877_();
                Entity entity = pEntity;
                pEntity = pEntity.m_6095_().m_20615_((Level)pLevel);
                if (pEntity == null) {
                    return false;
                }
                pEntity.m_20361_(entity);
                pEntity.m_7678_((double)pX, (double)pY, (double)pZ, f, f2);
                pEntity.m_5616_(f);
                entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                pLevel.m_143334_(pEntity);
            }
        }
        if (!(pEntity instanceof LivingEntity) || !((LivingEntity)pEntity).m_21255_()) {
            pEntity.m_20256_(pEntity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            pEntity.m_6853_(true);
        }
        if (pEntity instanceof PathfinderMob) {
            ((PathfinderMob)pEntity).m_21573_().m_26573_();
        }
        return true;
    }
}

