/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.util;

import java.util.function.Predicate;
import mc.craig.software.angels.WAConfiguration;
import mc.craig.software.angels.common.WASounds;
import mc.craig.software.angels.common.entity.angel.WeepingAngel;
import mc.craig.software.angels.util.WADamageSources;
import mc.craig.software.angels.util.WATags;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HurtHelper {
    public static boolean validatePickaxe(Player player, WeepingAngel weepingAngel, Predicate<ItemStack> predicate) {
        ItemStack heldItem = player.m_6844_(EquipmentSlot.MAINHAND);
        Item item = weepingAngel.getVariant().getDrops().m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return predicate.test(heldItem) && heldItem.m_41720_().m_8096_(blockItem.m_40614_().m_49966_());
        }
        return heldItem.m_204117_(WATags.ATTACK_OVERRIDES);
    }

    public static boolean handleAngelHurt(WeepingAngel weepingAngel, DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268724_)) {
            return true;
        }
        HurtType hurtType = (HurtType)((Object)WAConfiguration.CONFIG.hurtType.get());
        switch (hurtType) {
            case NONE: {
                return false;
            }
            case PICKAXE: {
                return HurtHelper.hasPickAxe(weepingAngel, pSource, itemStack -> true);
            }
            case GENERATOR: {
                return pSource.m_276093_(WADamageSources.GENERATOR);
            }
            case PICKAXE_AND_GENERATOR: {
                return pSource.m_276093_(WADamageSources.GENERATOR) || HurtHelper.hasPickAxe(weepingAngel, pSource, itemStack -> true);
            }
            case ANYTHING: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasPickAxe(WeepingAngel weepingAngel, DamageSource pSource, Predicate<ItemStack> predicate) {
        Entity entity = pSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean hasPickAxe = HurtHelper.validatePickaxe(player, weepingAngel, predicate);
            if (!hasPickAxe) {
                Level level;
                if (weepingAngel.m_9236_().f_46441_.m_188503_(100) <= 10) {
                    weepingAngel.m_216990_(WASounds.ANGEL_MOCKING.get());
                }
                if ((level = player.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    player.m_6469_(WADamageSources.getSource(serverLevel, WADamageSources.PUNCH_STONE), (float)weepingAngel.m_9236_().f_46441_.m_188503_(5));
                }
                return false;
            }
            ItemStack stack = player.m_6844_(EquipmentSlot.MAINHAND);
            stack.m_41622_(weepingAngel.m_9236_().f_46441_.m_188503_(4), (LivingEntity)weepingAngel, livingEntity -> {
                weepingAngel.m_216990_(WASounds.ANGEL_MOCKING.get());
                livingEntity.m_21190_(InteractionHand.MAIN_HAND);
            });
            return true;
        }
        return false;
    }

    public static enum HurtType {
        PICKAXE,
        PICKAXE_AND_GENERATOR,
        NONE,
        GENERATOR,
        ANYTHING;

    }
}

