/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.registry.forge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import mc.craig.software.angels.registry.DeferredRegistry;
import mc.craig.software.angels.registry.RegistrySupplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class DeferredRegistryImpl {
    public static <T> DeferredRegistry<T> create(String modid, ResourceKey<? extends Registry<T>> resourceKey) {
        return new Impl(modid, resourceKey);
    }

    public static class Impl<T>
    extends DeferredRegistry<T> {
        private final DeferredRegister<T> register;
        private final List<RegistrySupplier<T>> entries;

        public Impl(String modid, ResourceKey<? extends Registry<T>> resourceKey) {
            this.register = DeferredRegister.create(resourceKey, (String)modid);
            this.entries = new ArrayList<RegistrySupplier<T>>();
        }

        @Override
        public void register() {
            this.register.register(FMLJavaModLoadingContext.get().getModEventBus());
        }

        @Override
        public <R extends T> RegistrySupplier<R> register(String id, Supplier<R> supplier) {
            RegistryObject orig = this.register.register(id, supplier);
            RegistrySupplier<RegistryObject> registrySupplier = new RegistrySupplier<RegistryObject>(orig.getId(), orig);
            this.entries.add(registrySupplier);
            return registrySupplier;
        }

        @Override
        public Collection<RegistrySupplier<T>> getEntries() {
            return this.entries;
        }
    }
}

