/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.forge.handlers;

import java.util.List;
import java.util.stream.Stream;
import mc.craig.software.angels.client.models.ModelRegistration;
import mc.craig.software.angels.client.models.forge.ModelRegistrationImpl;
import mc.craig.software.angels.client.render.blockentity.CoffinRenderer;
import mc.craig.software.angels.client.render.blockentity.GeneratorRenderer;
import mc.craig.software.angels.client.render.blockentity.SnowAngelRenderer;
import mc.craig.software.angels.client.render.blockentity.StatueRenderer;
import mc.craig.software.angels.client.render.entity.ThrowableGeneratorRenderer;
import mc.craig.software.angels.client.render.entity.WeepingAngelRenderer;
import mc.craig.software.angels.client.render.entity.layers.DonationWingsLayer;
import mc.craig.software.angels.common.WAEntities;
import mc.craig.software.angels.common.WATabs;
import mc.craig.software.angels.common.blockentity.WABlockEntities;
import mc.craig.software.angels.common.blocks.WABlocks;
import mc.craig.software.angels.common.items.WAItems;
import mc.craig.software.angels.forge.overlays.TimeyWimeyOverlay;
import mc.craig.software.angels.util.WAHelper;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="weeping_angels", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModBus {
    @SubscribeEvent
    public static void on(BuildCreativeModeTabContentsEvent event) {
        Stream<Item> values = ForgeRegistries.ITEMS.getValues().stream().filter(item -> ForgeRegistries.ITEMS.getKey(item).m_135827_().matches("weeping_angels"));
        if (event.getTab() == WATabs.MAIN_TAB.get()) {
            for (Item item2 : values.toList()) {
                event.m_246326_((ItemLike)item2);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("angel", (IGuiOverlay)new TimeyWimeyOverlay());
    }

    @SubscribeEvent
    public static void renderLayers(EntityRenderersEvent.AddLayers addLayers) {
        addLayers.getSkins().forEach(skin -> {
            LivingEntityRenderer renderer = addLayers.getSkin(skin);
            renderer.m_115326_(new DonationWingsLayer(renderer));
        });
    }

    @SubscribeEvent
    public static void event(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ModelRegistration.init();
        ModelRegistrationImpl.register(event);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_(WABlockEntities.COFFIN.get(), CoffinRenderer::new);
        BlockEntityRenderers.m_173590_(WABlockEntities.STATUE.get(), StatueRenderer::new);
        BlockEntityRenderers.m_173590_(WABlockEntities.GENERATOR.get(), GeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(WABlockEntities.SNOW_ANGEL.get(), SnowAngelRenderer::new);
        ItemBlockRenderTypes.setRenderLayer((Block)WABlocks.COFFIN.get(), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)WABlocks.STATUE.get(), (RenderType)RenderType.m_110463_());
        ItemProperties.register((Item)WAItems.TIMEY_WIMEY_DETECTOR.get(), (ResourceLocation)new ResourceLocation("weeping_angels", "time"), (ItemPropertyFunction)new CompassItemPropertyFunction((clientLevel, itemStack, entity) -> {
            List<Entity> anomaliesAround = WAHelper.getAnomaliesAroundEntity(entity, 64);
            if (anomaliesAround.isEmpty()) {
                return null;
            }
            return GlobalPos.m_122643_((ResourceKey)entity.m_9236_().m_46472_(), (BlockPos)anomaliesAround.get(0).m_20183_());
        }));
    }

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(WAEntities.WEEPING_ANGEL.get(), WeepingAngelRenderer::new);
        event.registerEntityRenderer(WAEntities.GENERATOR.get(), ThrowableGeneratorRenderer::new);
    }
}

