/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.forge;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import mc.craig.software.angels.WAConfiguration;
import mc.craig.software.angels.WeepingAngels;
import mc.craig.software.angels.common.WAEntities;
import mc.craig.software.angels.common.entity.angel.WeepingAngel;
import mc.craig.software.angels.common.entity.angel.ai.AngelVariant;
import mc.craig.software.angels.data.forge.BiomeTagsProvider;
import mc.craig.software.angels.data.forge.BlockTags;
import mc.craig.software.angels.data.forge.EnglishLang;
import mc.craig.software.angels.data.forge.EntityTypeTags;
import mc.craig.software.angels.data.forge.LootProvider;
import mc.craig.software.angels.data.forge.ModelProviderBlock;
import mc.craig.software.angels.data.forge.ModelProviderItem;
import mc.craig.software.angels.data.forge.RecipeProvider;
import mc.craig.software.angels.data.forge.SoundProvider;
import mc.craig.software.angels.data.forge.WAItemTags;
import mc.craig.software.angels.data.forge.WorldGenProvider;
import mc.craig.software.angels.data.forge.biome.AddAngelSpawns;
import mc.craig.software.angels.forge.compat.vivecraft.ServerReflector;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="weeping_angels")
public class WeepingAngelsForge {
    public static final ServerReflector VR_REFLECTOR = new ServerReflector();

    public WeepingAngelsForge() {
        WeepingAngels.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WAConfiguration.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WAConfiguration.SPAWNS_SPEC, "weeping-angels-spawns.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)WAConfiguration.CLIENT_SPEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onAttributeAssign);
        modEventBus.addListener(this::onGatherData);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DeferredRegister serializers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"weeping_angels");
        serializers.register(modEventBus);
        serializers.register(AddAngelSpawns.WEEPING_ANGEL_SPAWNS.m_135815_(), AddAngelSpawns::makeCodec);
        StartupMessageManager.addModMessage((String)"Don't Blink!");
    }

    public void onGatherData(GatherDataEvent e) {
        DataGenerator generator = e.getGenerator();
        ExistingFileHelper existingFileHelper = e.getExistingFileHelper();
        CompletableFuture lookup = e.getLookupProvider();
        generator.addProvider(e.includeClient(), (DataProvider)new EnglishLang(generator));
        generator.addProvider(e.includeClient(), (DataProvider)new ModelProviderItem(generator, existingFileHelper));
        generator.addProvider(e.includeClient(), (DataProvider)new ModelProviderBlock(generator, existingFileHelper));
        generator.addProvider(e.includeClient(), (DataProvider)new SoundProvider(generator, existingFileHelper));
        generator.addProvider(e.includeServer(), (DataProvider)new LootProvider(generator.getPackOutput(), BuiltInLootTables.m_78766_(), List.of(new LootTableProvider.SubProviderEntry(LootProvider.ModBlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(LootProvider.ModChestLoot::new, LootContextParamSets.f_81411_))));
        generator.addProvider(e.includeServer(), (DataProvider)new BiomeTagsProvider(generator.getPackOutput(), lookup, existingFileHelper));
        generator.addProvider(e.includeServer(), (DataProvider)new WorldGenProvider(generator.getPackOutput(), e.getLookupProvider()));
        generator.addProvider(e.includeServer(), (DataProvider)new RecipeProvider(generator.getPackOutput()));
        generator.addProvider(e.includeServer(), (DataProvider)new BlockTags(generator.getPackOutput(), lookup, existingFileHelper));
        generator.addProvider(e.includeServer(), (DataProvider)new EntityTypeTags(generator.getPackOutput(), lookup, existingFileHelper));
        BlockTags blocktags = new BlockTags(generator.getPackOutput(), lookup, existingFileHelper);
        generator.addProvider(e.includeServer(), (DataProvider)new WAItemTags(generator.getPackOutput(), lookup, blocktags.m_274426_(), existingFileHelper));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        VR_REFLECTOR.init();
        AngelVariant.init();
        SpawnPlacements.m_21754_(WAEntities.WEEPING_ANGEL.get(), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
    }

    public void onAttributeAssign(EntityAttributeCreationEvent event) {
        event.put(WAEntities.WEEPING_ANGEL.get(), WeepingAngel.createAttributes().m_22265_());
    }
}

