/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.donators;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.player.Player;

public class Donator {
    private String name;
    public String uuid;
    public String variant;
    public String wings;
    public boolean perked;
    public int animationTime = 0;
    public AnimationState openState = new AnimationState();
    public AnimationState closeState = new AnimationState();

    public Donator(JsonObject jsonObject) {
        this.uuid = jsonObject.get("uuid").getAsString();
        JsonObject wingData = jsonObject.getAsJsonObject("wings");
        this.variant = wingData.get("variant").getAsString();
        this.wings = wingData.get("model").getAsString();
        this.perked = wingData.get("perked").getAsBoolean();
        this.name = jsonObject.get("mc_name").getAsString();
    }

    public String getName() {
        return this.name;
    }

    public void tick(Player player) {
        ++this.animationTime;
        if (player.m_21255_()) {
            this.closeState.m_216973_();
            if (!this.openState.m_216984_()) {
                this.openState.m_216977_(player.f_19797_);
            }
        }
        if (player.m_20096_()) {
            this.openState.m_216973_();
            if (!this.closeState.m_216984_()) {
                this.closeState.m_216977_(player.f_19797_);
            }
        }
    }

    public int getAnimationTime() {
        return this.animationTime;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVariant() {
        return this.variant;
    }

    public String getWings() {
        return this.wings;
    }

    public boolean isPerked() {
        return this.perked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Donator donator = (Donator)o;
        return this.perked == donator.perked && this.name.equals(donator.name) && this.uuid.equals(donator.uuid) && this.variant.equals(donator.variant) && this.wings.equals(donator.wings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uuid, this.variant, this.wings, this.perked);
    }

    public String toString() {
        return "Donator{name='" + this.name + "', uuid=" + this.uuid + ", variant='" + this.variant + "', wings='" + this.wings + "', perked=" + this.perked + "}";
    }
}

