/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.data.forge.level;

import java.util.List;
import mc.craig.software.angels.data.forge.level.ProviderConfiguredFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ProviderPlacedFeatures {
    public static final ResourceKey<PlacedFeature> SNOW_ANGEL = ProviderPlacedFeatures.createKey("snow_angel");
    public static final ResourceKey<PlacedFeature> ORE_KONTRON = ProviderPlacedFeatures.createKey("ore_kontron");
    public static final ResourceKey<PlacedFeature> ORE_KONTRON_SMALL = ProviderPlacedFeatures.createKey("ore_kontron_small");

    public static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("weeping_angels", name));
    }

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        ProviderPlacedFeatures.register(context, SNOW_ANGEL, configuredFeatures.m_255043_(ProviderConfiguredFeatures.SNOW_ANGEL_CONFIGURED), List.of(NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)0, (int)4), RarityFilter.m_191900_((int)300), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        ProviderPlacedFeatures.register(context, ORE_KONTRON, configuredFeatures.m_255043_(ProviderConfiguredFeatures.ORE_KONTRON), List.copyOf(ProviderPlacedFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-24), (VerticalAnchor)VerticalAnchor.m_158922_((int)56)))));
        ProviderPlacedFeatures.register(context, ORE_KONTRON_SMALL, configuredFeatures.m_255043_(ProviderConfiguredFeatures.ORE_KONTRON_SMALL), List.copyOf(ProviderPlacedFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)72)))));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier plMod, PlacementModifier plMod2) {
        return List.of(plMod, InSquarePlacement.m_191715_(), plMod2, BiomeFilter.m_191561_());
    }

    public static List<PlacementModifier> commonOrePlacement(int amt, PlacementModifier plMod) {
        return ProviderPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)amt), plMod);
    }

    public static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    public static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        ProviderPlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }
}

