/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.data.forge;

import java.util.Objects;
import mc.craig.software.angels.common.blocks.WABlocks;
import mc.craig.software.angels.common.items.DetectorItem;
import mc.craig.software.angels.common.items.WAItems;
import mc.craig.software.angels.registry.RegistrySupplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModelProviderItem
extends ItemModelProvider {
    public ModelProviderItem(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "weeping_angels", existingFileHelper);
    }

    protected void registerModels() {
        for (RegistrySupplier<Item> entry : WAItems.ITEMS.getEntries()) {
            if (entry.get() instanceof DetectorItem || entry.get() == WAItems.CHRONODYNE_GENERATOR.get()) continue;
            if (entry.get() == WABlocks.COFFIN.get().m_5456_() || entry.get() == WABlocks.STATUE.get().m_5456_()) {
                this.basicItem(entry.get());
                continue;
            }
            if (entry.get() == WAItems.CHISEL.get()) {
                this.toolItem(entry.get());
                continue;
            }
            Item item = entry.get();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (blockItem.m_40614_() == WABlocks.SNOW_ANGEL.get()) {
                    this.basicItem(entry.get());
                    continue;
                }
                this.blockItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)entry.get())));
                continue;
            }
            this.basicItem(entry.get());
        }
    }

    public ItemModelBuilder toolItem(Item item) {
        return this.toolItem(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)));
    }

    public ItemModelBuilder toolItem(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", new ResourceLocation(item.m_135827_(), "item/" + item.m_135815_()));
    }

    public ItemModelBuilder blockItem(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(item.m_135827_(), "block/" + item.m_135815_())));
    }

    public ItemModelBuilder layeredItem(ResourceLocation destination, ResourceLocation item, ResourceLocation resourceLocation) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(destination.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(item.m_135827_(), "item/" + item.m_135815_()))).texture("layer1", new ResourceLocation(resourceLocation.m_135827_(), "item/" + resourceLocation.m_135815_()));
    }

    public ItemModelBuilder layeredItem(ResourceLocation item, ResourceLocation resourceLocation) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(item.m_135827_(), "item/" + item.m_135815_()))).texture("layer1", new ResourceLocation(resourceLocation.m_135827_(), "item/" + resourceLocation.m_135815_()));
    }
}

