/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.entity.angel.ai;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import mc.craig.software.angels.WeepingAngels;
import mc.craig.software.angels.common.entity.angel.WeepingAngel;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class AngelVariant {
    public static final Map<ResourceLocation, AngelVariant> ORE_VARIANTS = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), objectOpenHashMap -> objectOpenHashMap.defaultReturnValue((Object)IRON));
    public static AngelVariant STONE;
    public static AngelVariant BASALT;
    public static AngelVariant DIRT;
    public static AngelVariant COPPER;
    public static AngelVariant MOSSY;
    public static AngelVariant RUSTED;
    public static AngelVariant RUSTED_NO_ARM;
    public static AngelVariant RUSTED_NO_WING;
    public static AngelVariant RUSTED_NO_HEAD;
    public static AngelVariant QUARTZ;
    public static AngelVariant LAPIS_LAZULI;
    public static AngelVariant IRON;
    public static AngelVariant GOLD;
    public static AngelVariant EMERALD;
    public static AngelVariant DIAMOND;
    public static final Map<ResourceLocation, AngelVariant> VARIANTS;
    public static AngelVariant GAS_STONE;
    public static AngelVariant GAS_RUSTED;
    public static AngelVariant A_DIZZLE;
    public static AngelVariant DOCTOR;
    private final ItemStack drops;
    private final ResourceLocation regName;

    public static void init() {
        STONE = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "normal"), new ItemStack((ItemLike)Blocks.f_50069_), false);
        DOCTOR = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "doctor"), new ItemStack((ItemLike)Blocks.f_50069_), false);
        BASALT = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "basalt"), new ItemStack((ItemLike)Blocks.f_50137_), false);
        COPPER = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "copper"), new ItemStack((ItemLike)Blocks.f_152505_), true);
        DIRT = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "dirt"), new ItemStack((ItemLike)Blocks.f_50493_), false);
        MOSSY = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "mossy"), new ItemStack((ItemLike)Blocks.f_50079_), false);
        RUSTED = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "rusted"), new ItemStack((ItemLike)Blocks.f_50079_), false);
        RUSTED_NO_ARM = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "rusted_no_arm"), new ItemStack((ItemLike)Blocks.f_50122_), false);
        RUSTED_NO_WING = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "rusted_no_wing"), new ItemStack((ItemLike)Blocks.f_50122_), false);
        RUSTED_NO_HEAD = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "rusted_no_head"), new ItemStack((ItemLike)Blocks.f_50122_), false);
        QUARTZ = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "quartz"), new ItemStack((ItemLike)Blocks.f_50283_), false);
        LAPIS_LAZULI = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "lapis_lazuli"), new ItemStack((ItemLike)Blocks.f_50059_), true);
        IRON = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "iron"), new ItemStack((ItemLike)Blocks.f_49996_), true);
        GOLD = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "gold"), new ItemStack((ItemLike)Blocks.f_49995_), true);
        EMERALD = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "emerald"), new ItemStack((ItemLike)Blocks.f_50264_), true);
        DIAMOND = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "diamond"), new ItemStack((ItemLike)Blocks.f_50089_), true);
        GAS_RUSTED = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "gas_rusted"), new ItemStack((ItemLike)Blocks.f_50069_), false);
        GAS_STONE = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "gas_stone"), new ItemStack((ItemLike)Blocks.f_50122_), false);
        A_DIZZLE = AngelVariant.registerVariant(new ResourceLocation("weeping_angels", "a_dizzle"), new ItemStack((ItemLike)Blocks.f_50122_), false);
    }

    public AngelVariant(ResourceLocation resourceLocation, ItemStack drops) {
        this.drops = drops;
        this.regName = resourceLocation;
    }

    public ResourceLocation location() {
        return this.regName;
    }

    public ItemStack getDrops() {
        return this.drops;
    }

    public static AngelVariant getVariantForPos(WeepingAngel weepingAngel) {
        Level level = weepingAngel.m_9236_();
        RandomSource randomSource = level.f_46441_;
        boolean isOrePosition = weepingAngel.m_20183_().m_123342_() < 50 && !level.m_45527_(weepingAngel.m_20183_());
        Holder currentBiome = level.m_204166_(weepingAngel.m_20183_());
        boolean isNether = currentBiome.m_203656_(BiomeTags.f_207612_);
        boolean isJungle = currentBiome.m_203656_(BiomeTags.f_207610_);
        if (isJungle) {
            return MOSSY;
        }
        if (isNether) {
            return randomSource.m_188499_() ? QUARTZ : BASALT;
        }
        if (isOrePosition && randomSource.m_188503_(100) < 10) {
            return AngelVariant.getRandomVariant(ORE_VARIANTS, randomSource);
        }
        Collection<AngelVariant> variants = VARIANTS.values();
        variants.removeIf(angelTextureVariant -> angelTextureVariant == QUARTZ || angelTextureVariant == MOSSY || angelTextureVariant == BASALT || ORE_VARIANTS.containsKey(angelTextureVariant.regName));
        return variants.stream().skip((int)((double)variants.size() * Math.random())).findFirst().get();
    }

    public static AngelVariant getRandomVariant(Map<ResourceLocation, AngelVariant> variantMap, RandomSource randomSource) {
        int index = randomSource.m_188503_(variantMap.size());
        return variantMap.values().toArray(new AngelVariant[0])[index];
    }

    public static AngelVariant getVariant(ResourceLocation resourceLocation) {
        if (VARIANTS.containsKey(resourceLocation)) {
            return VARIANTS.get(resourceLocation);
        }
        return STONE;
    }

    public static AngelVariant registerVariant(ResourceLocation resourceLocation, ItemStack itemStack, boolean isOre) {
        WeepingAngels.LOGGER.info("Registered: {}", (Object)resourceLocation);
        return AngelVariant.registerVariant(resourceLocation, new AngelVariant(resourceLocation, itemStack), isOre);
    }

    public static AngelVariant registerVariant(ResourceLocation resourceLocation, AngelVariant angelVariant, boolean isOre) {
        if (isOre) {
            ORE_VARIANTS.put(resourceLocation, angelVariant);
        }
        if (VARIANTS.containsKey(resourceLocation)) {
            VARIANTS.replace(resourceLocation, angelVariant);
        }
        VARIANTS.put(resourceLocation, angelVariant);
        return angelVariant;
    }

    static {
        VARIANTS = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), objectOpenHashMap -> objectOpenHashMap.defaultReturnValue((Object)STONE));
    }
}

