/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.entity.angel;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import mc.craig.software.angels.WAConfiguration;
import mc.craig.software.angels.common.CatacombTracker;
import mc.craig.software.angels.common.WAEntities;
import mc.craig.software.angels.common.WASounds;
import mc.craig.software.angels.common.entity.angel.AbstractWeepingAngel;
import mc.craig.software.angels.common.entity.angel.BlockReactions;
import mc.craig.software.angels.common.entity.angel.ai.AngelEmotion;
import mc.craig.software.angels.common.entity.angel.ai.AngelVariant;
import mc.craig.software.angels.common.items.WAItems;
import mc.craig.software.angels.util.HurtHelper;
import mc.craig.software.angels.util.Teleporter;
import mc.craig.software.angels.util.WADamageSources;
import mc.craig.software.angels.util.WATags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeepingAngel
extends AbstractWeepingAngel {
    public AnimationState POSE_ANIMATION_STATE = new AnimationState();
    private int fakeAnimation = -1;

    public int getFakeAnimation() {
        return this.fakeAnimation;
    }

    public void setFakeAnimation(int fakeAnimation) {
        this.fakeAnimation = fakeAnimation;
    }

    public WeepingAngel(Level worldIn) {
        super(worldIn, WAEntities.WEEPING_ANGEL.get());
        int id = 0;
        this.f_21345_.m_25352_(id++, (Goal)new OpenDoorGoal((Mob)this, false));
        this.f_21345_.m_25352_(id++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, true));
        this.f_21345_.m_25352_(id++, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21346_.m_25352_(id++, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(id++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{WeepingAngel.class}));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant(AngelVariant.getVariantForPos(this));
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)WAItems.ANGEL_SPAWNER.get());
    }

    public boolean m_7327_(Entity pEntity) {
        ServerLevel serverLevel;
        if (!(pEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)pEntity;
        float attackDamage = (float)this.m_21133_(Attributes.f_22281_);
        ServerLevel serverLevel2 = serverLevel = pEntity.m_9236_() instanceof ServerLevel ? (ServerLevel)pEntity.m_9236_() : null;
        if (serverLevel != null) {
            boolean shouldTeleport;
            boolean bl = shouldTeleport = this.f_19796_.m_188503_(100) < (Integer)WAConfiguration.CONFIG.teleportChance.get();
            if (shouldTeleport) {
                ServerLevel chosenDimension = Teleporter.getRandomDimension(this.f_19796_, serverLevel);
                int teleportRange = (Integer)WAConfiguration.CONFIG.teleportRange.get();
                int xCoord = (int)(this.m_20185_() + (double)this.f_19796_.m_188503_(teleportRange));
                int zCoord = (int)(this.m_20189_() + (double)this.f_19796_.m_188503_(teleportRange));
                for (int i = 0; i < 10; ++i) {
                    int destinationY = chosenDimension.m_6924_(Heightmap.Types.MOTION_BLOCKING, xCoord, zCoord);
                    boolean successfulTeleport = Teleporter.performTeleport(pEntity, chosenDimension, xCoord, destinationY, zCoord, pEntity.m_146908_(), pEntity.m_146909_(), true);
                    if (!successfulTeleport) continue;
                    return true;
                }
                return false;
            }
        }
        this.stealItems(player);
        if (serverLevel != null) {
            boolean didHurt = pEntity.m_6469_(WADamageSources.getSource(serverLevel, WADamageSources.SNAPPED_NECK), attackDamage);
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
            return didHurt;
        }
        return false;
    }

    public boolean m_214076_(ServerLevel serverLevel, LivingEntity livingEntity) {
        boolean wasKilled = super.m_214076_(serverLevel, livingEntity);
        if (wasKilled) {
            this.m_216990_(WASounds.NECK_SNAP.get());
        }
        return wasKilled;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!state.m_278721_()) {
            BlockState blockState = Blocks.f_50069_.m_49966_();
            SoundType soundType = blockState.m_60827_();
            this.m_5496_(soundType.m_56776_(), soundType.m_56773_() * 0.15f, soundType.m_56774_());
        }
    }

    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        this.m_7327_(entity);
    }

    protected void m_7324_(Entity entity) {
        super.m_7324_(entity);
        this.m_7327_(entity);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (!level.m_5776_() && CatacombTracker.isInCatacomb((LivingEntity)this)) {
            Warden.m_219375_((ServerLevel)((ServerLevel)level), (Vec3)this.m_20182_(), (Entity)this, (int)20);
        }
        if (!this.POSE_ANIMATION_STATE.m_216984_()) {
            this.POSE_ANIMATION_STATE.m_216977_(this.f_19797_ - this.f_19796_.m_188503_(10000));
        }
        if (this.isSeen() && (!this.m_20096_() || level.m_46855_(this.m_20191_())) && !this.isHooked()) {
            this.setSeenTime(0);
            this.m_21557_(false);
        }
        if (this.f_19797_ % 400 == 0) {
            if (this.isHooked()) {
                this.setHooked(false);
            }
            if (this.isSeen()) {
                this.investigateBlocks();
            }
        }
    }

    public void stealItems(Player player) {
        if (!this.m_21205_().m_41619_()) {
            return;
        }
        Inventory playerInv = player.m_150109_();
        for (int i = 0; i < playerInv.f_35974_.size(); ++i) {
            ItemStack item = (ItemStack)playerInv.f_35974_.get(i);
            if (!item.m_204117_(WATags.STEALABLE_ITEMS) || !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) continue;
            this.m_21008_(InteractionHand.MAIN_HAND, item.m_41777_());
            this.m_21508_(EquipmentSlot.MAINHAND);
            playerInv.m_6836_(i, ItemStack.f_41583_);
            return;
        }
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level worldIn) {
        WallClimberNavigation navigator = new WallClimberNavigation((Mob)this, worldIn);
        navigator.m_7008_(false);
        navigator.m_26477_(true);
        navigator.m_26490_(false);
        navigator.m_26517_(1.0);
        return navigator;
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_6147_() {
        return this.f_19862_;
    }

    @Override
    public void invokeSeen(Player player) {
        super.invokeSeen(player);
        if (this.getSeenTime() == 1 && System.currentTimeMillis() - this.timeSincePlayedSound > 5000L) {
            this.setEmotion(AngelEmotion.randomEmotion(this.f_19796_));
            this.m_216990_(SoundEvents.f_12447_);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (player.m_20270_((Entity)this) < 15.0f) {
                    this.setTimeSincePlayedSound(System.currentTimeMillis());
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)this.getSeenSound()), SoundSource.BLOCKS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.25f, 1.0f, this.f_19796_.m_188505_()));
                }
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12446_;
    }

    protected SoundEvent m_5592_() {
        return WASounds.CRUMBLING.get();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Level level = this.m_9236_();
        if (!level.m_5776_()) {
            boolean isHurt = HurtHelper.handleAngelHurt(this, pSource, pAmount);
            ServerLevel serverLevel = (ServerLevel)level;
            if (isHurt) {
                Item item = this.getVariant().getDrops().m_41720_();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    BlockState defaultState = blockItem.m_40614_().m_49966_();
                    this.m_216990_(defaultState.m_60827_().m_56778_());
                }
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 5, 0.1, 0.0, 0.1, 0.2);
                return super.m_6469_(pSource, pAmount);
            }
        }
        return false;
    }

    protected void m_6153_() {
        Level level = this.m_9236_();
        ++this.f_20919_;
        if (this.f_20919_ == 20 && !level.m_5776_()) {
            if (this.m_6125_()) {
                ItemEntity itemEntity = new ItemEntity(EntityType.f_20461_, level);
                itemEntity.m_32045_(this.getVariant().getDrops());
                itemEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                level.m_7967_((Entity)itemEntity);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void investigateBlocks() {
        Level level = this.m_9236_();
        if (level.m_5776_() || !level.m_46469_().m_46207_(GameRules.f_46132_) || !((Boolean)WAConfiguration.CONFIG.blockBreaking.get()).booleanValue()) {
            return;
        }
        Iterator iterator = BlockPos.m_121985_((BlockPos)this.m_20183_(), (int)25, (int)3, (int)25).iterator();
        while (iterator.hasNext()) {
            BlockPos pos = (BlockPos)iterator.next();
            BlockState blockState = level.m_8055_(pos);
            BlockReactions.BlockReaction blockBehaviour = BlockReactions.BLOCK_BEHAVIOUR.get(blockState.m_60734_());
            boolean completed = blockBehaviour.interact(this, blockState, level, pos);
            if (!completed) continue;
            Warden.m_219375_((ServerLevel)((ServerLevel)level), (Vec3)Vec3.m_82539_((Vec3i)this.m_20183_()), (Entity)this, (int)64);
            return;
        }
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        private final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(crackiness -> crackiness.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

