/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.entity.angel;

import java.util.List;
import mc.craig.software.angels.WAConfiguration;
import mc.craig.software.angels.common.entity.angel.ai.AngelEmotion;
import mc.craig.software.angels.common.entity.angel.ai.AngelVariant;
import mc.craig.software.angels.common.entity.angel.ai.BodyRotationAngel;
import mc.craig.software.angels.util.ViewUtil;
import mc.craig.software.angels.util.WAHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWeepingAngel
extends Monster
implements Enemy {
    private static final EntityDataAccessor<Integer> TIME_VIEWED = SynchedEntityData.m_135353_(AbstractWeepingAngel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> EMOTION = SynchedEntityData.m_135353_(AbstractWeepingAngel.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_HOOKED = SynchedEntityData.m_135353_(AbstractWeepingAngel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.m_135353_(AbstractWeepingAngel.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> SHOULD_DROP_LOOT = SynchedEntityData.m_135353_(AbstractWeepingAngel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public long timeSincePlayedSound = 0L;

    public AbstractWeepingAngel(Level worldIn, EntityType<? extends Monster> entityType) {
        super(entityType, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractWeepingAngel.m_33035_().m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.8).m_22268_(Attributes.f_22284_, 2.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getSeenTime() == 0) {
            this.m_21557_(false);
        }
    }

    public void m_8107_() {
        if (!this.m_21205_().m_41619_()) {
            this.m_21530_();
        }
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_((double)((Integer)WAConfiguration.CONFIG.stalkRange.get()).intValue()));
            players.removeIf(player -> player.m_5833_() || player.m_20145_() || player.m_5803_() || player.m_9236_() != this.m_9236_());
            if (players.isEmpty()) {
                this.setSeenTime(0);
                this.m_7910_(0.5f);
                return;
            }
            Player targetPlayer = null;
            for (Player player2 : players) {
                if (ViewUtil.isInSight((LivingEntity)player2, this)) {
                    this.setSeenTime(this.getSeenTime() + 1);
                    this.invokeSeen(player2);
                    return;
                }
                if (targetPlayer != null) continue;
                targetPlayer = player2;
                this.setSeenTime(0);
                this.m_7910_(0.5f);
            }
            if (this.isSeen()) {
                return;
            }
            this.snapLookToPlayer(targetPlayer);
            this.moveTowards((LivingEntity)targetPlayer);
        }
    }

    public void m_7601_(BlockState state, @NotNull Vec3 motionMultiplierIn) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplierIn);
        }
    }

    private void snapLookToPlayer(Player targetPlayer) {
        Vec3 vecPos = this.m_20182_();
        Vec3 vecPlayerPos = targetPlayer.m_20182_();
        float angle = (float)Math.toDegrees((float)Math.atan2(vecPos.f_82481_ - vecPlayerPos.f_82481_, vecPos.f_82479_ - vecPlayerPos.f_82479_));
        this.f_20883_ = angle > 180.0f ? angle : angle + 90.0f;
        this.f_20885_ = this.f_20883_;
    }

    public void moveTowards(LivingEntity targetPlayer) {
        this.m_21573_().m_5624_((Entity)targetPlayer, (double)this.m_6113_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TIME_VIEWED, (Object)0);
        this.m_20088_().m_135372_(EMOTION, (Object)AngelEmotion.IDLE.getId());
        this.m_20088_().m_135372_(IS_HOOKED, (Object)false);
        this.m_20088_().m_135372_(VARIANT, (Object)AngelVariant.BASALT.location().toString());
        this.m_20088_().m_135372_(SHOULD_DROP_LOOT, (Object)true);
    }

    protected boolean m_6125_() {
        return (Boolean)this.m_20088_().m_135370_(SHOULD_DROP_LOOT);
    }

    public AngelVariant getVariant() {
        return AngelVariant.getVariant(new ResourceLocation((String)this.m_20088_().m_135370_(VARIANT)));
    }

    public void setVariant(AngelVariant angelVariant) {
        this.m_20088_().m_135381_(VARIANT, (Object)angelVariant.location().toString());
    }

    public AngelEmotion getEmotion() {
        String emotion = (String)this.m_20088_().m_135370_(EMOTION);
        for (AngelEmotion angelEmotion : AngelEmotion.values()) {
            if (!emotion.equalsIgnoreCase(angelEmotion.getId())) continue;
            return angelEmotion;
        }
        return AngelEmotion.IDLE;
    }

    public void setEmotion(AngelEmotion angelEmotion) {
        this.m_20088_().m_135381_(EMOTION, (Object)angelEmotion.getId());
    }

    public boolean isHooked() {
        return (Boolean)this.m_20088_().m_135370_(IS_HOOKED);
    }

    public void setHooked(boolean hooked) {
        this.m_20088_().m_135381_(IS_HOOKED, (Object)hooked);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("timeSeen")) {
            this.setSeenTime(compound.m_128451_("timeSeen"));
        }
        if (compound.m_128441_("emotion")) {
            this.setEmotion(AngelEmotion.find(compound.m_128461_("emotion").toUpperCase()));
        }
        if (compound.m_128441_("isHooked")) {
            this.setEmotion(AngelEmotion.find(compound.m_128461_("emotion").toUpperCase()));
        }
        if (compound.m_128441_("dropsLoot")) {
            this.setDrops(compound.m_128471_("dropsLoot"));
        }
        if (compound.m_128441_("angelVariant")) {
            this.setVariant(AngelVariant.getVariant(new ResourceLocation(compound.m_128461_("angelVariant"))));
        }
    }

    public void setDrops(boolean drops) {
        this.m_20088_().m_135381_(SHOULD_DROP_LOOT, (Object)drops);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isSeen", this.isSeen());
        compound.m_128405_("timeSeen", this.getSeenTime());
        compound.m_128359_("emotion", this.getEmotion().getId());
        compound.m_128379_("dropsLoot", this.m_6125_());
        compound.m_128359_("angelVariant", this.getVariant().location().toString());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return WAHelper.spawnPacket((Entity)this);
    }

    public SoundEvent getSeenSound() {
        AngelVariant angelVariant = this.getVariant();
        ItemStack itemStack = angelVariant.getDrops();
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            return block.m_49966_().m_60827_().m_56775_();
        }
        return SoundEvents.f_12447_;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public long getTimeSincePlayedSound() {
        return this.timeSincePlayedSound;
    }

    public void setTimeSincePlayedSound(long timeSincePlayedSound) {
        this.timeSincePlayedSound = timeSincePlayedSound;
    }

    public boolean isSeen() {
        return this.getSeenTime() > 0;
    }

    public int getSeenTime() {
        return (Integer)this.m_20088_().m_135370_(TIME_VIEWED);
    }

    public void setSeenTime(int time) {
        this.m_20088_().m_135381_(TIME_VIEWED, (Object)time);
    }

    public void m_147240_(double strength, double x, double z) {
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new BodyRotationAngel((Mob)this);
    }

    public void invokeSeen(Player player) {
        this.m_21573_().m_26536_((Path)null, 0.0);
        this.m_21557_(true);
    }

    protected boolean m_6107_() {
        return this.getSeenTime() > 0;
    }
}

