/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.blocks;

import java.util.function.Supplier;
import mc.craig.software.angels.common.blocks.CoffinBlock;
import mc.craig.software.angels.common.blocks.GeneratorBlock;
import mc.craig.software.angels.common.blocks.MineableBlock;
import mc.craig.software.angels.common.blocks.SnowAngelBlock;
import mc.craig.software.angels.common.blocks.StatueBaseBlock;
import mc.craig.software.angels.common.items.WAItems;
import mc.craig.software.angels.registry.DeferredRegistry;
import mc.craig.software.angels.registry.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class WABlocks {
    public static final DeferredRegistry<Block> BLOCKS = DeferredRegistry.create("weeping_angels", Registries.f_256747_);
    public static final RegistrySupplier<Block> KONTRON_ORE = WABlocks.register("kontron_ore", () -> new MineableBlock(BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(3.0f, 3.0f)));
    public static final RegistrySupplier<Block> KONTRON_ORE_DEEPSLATE = WABlocks.register("deepslate_kontron_ore", () -> new MineableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)KONTRON_ORE.get())).m_60913_(4.5f, 3.0f).m_60918_(SoundType.f_154677_)));
    public static final RegistrySupplier<Block> CHRONODYNE_GENERATOR = WABlocks.register("chronodyne_generator", () -> new GeneratorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283744_).m_60918_(SoundType.f_56743_)), false);
    public static final RegistrySupplier<Block> COFFIN = WABlocks.register("coffin", () -> new CoffinBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283744_).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> STATUE = WABlocks.register("statue", () -> new StatueBaseBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283744_).m_60918_(SoundType.f_56742_)));
    public static final RegistrySupplier<Block> PLINTH = WABlocks.register("plinth", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283744_).m_60918_(SoundType.f_56742_)));
    public static final RegistrySupplier<Block> SNOW_ANGEL = WABlocks.register("snow_angel", SnowAngelBlock::new);

    private static <T extends Block> RegistrySupplier<T> register(String id, Supplier<T> blockSupplier, boolean needsItem) {
        RegistrySupplier registryObject = BLOCKS.register(id, blockSupplier);
        if (needsItem) {
            WAItems.ITEMS.register(id, () -> new BlockItem((Block)registryObject.get(), new Item.Properties()));
        }
        return registryObject;
    }

    private static <T extends Block> RegistrySupplier<T> register(String id, Supplier<T> blockSupplier) {
        return WABlocks.register(id, blockSupplier, true);
    }
}

