/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.blockentity;

import mc.craig.software.angels.common.blockentity.Plinth;
import mc.craig.software.angels.common.blockentity.WABlockEntities;
import mc.craig.software.angels.common.blocks.StatueBaseBlock;
import mc.craig.software.angels.common.entity.angel.ai.AngelEmotion;
import mc.craig.software.angels.common.entity.angel.ai.AngelVariant;
import mc.craig.software.angels.util.WAHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StatueBlockEntity
extends BlockEntity
implements BlockEntityTicker<StatueBlockEntity>,
Plinth {
    private AngelVariant currentVariant = null;
    private int animation = 1;
    private AngelEmotion emotion = AngelEmotion.IDLE;

    public StatueBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(WABlockEntities.STATUE.get(), blockPos, blockState);
    }

    @Override
    public void changeVariant(Plinth plinth) {
        this.setSpecificVariant(AngelVariant.getRandomVariant(AngelVariant.VARIANTS, this.f_58857_.f_46441_));
    }

    @Override
    public void setSpecificVariant(AngelVariant angelVariant) {
        this.currentVariant = angelVariant;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public AngelVariant getVariant() {
        if (this.currentVariant == null) {
            return AngelVariant.STONE;
        }
        return this.currentVariant;
    }

    @Override
    public void setAnimation(int animation) {
        this.animation = animation;
    }

    @Override
    public int getAnimation() {
        return this.animation;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeNbt(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readNbt(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public void sendUpdates() {
        if (this.f_58857_ != null && this.m_58900_() != null && this.m_58900_().m_60734_() != null) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        this.m_6596_();
    }

    @Override
    public void setEmotion(AngelEmotion value) {
        this.emotion = value;
    }

    @Override
    public AngelEmotion getEmotion() {
        return this.emotion;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, StatueBlockEntity blockEntity) {
        if (!this.getAnimationState().m_216984_()) {
            this.getAnimationState().m_216977_(level.m_183326_().m_183574_());
        }
        if (!level.m_5776_() && level.m_276867_(blockPos)) {
            WAHelper.spawnWeepingAngel((ServerLevel)level, blockPos, this.currentVariant, false, (float)Math.toRadians(22.5f * (float)((Integer)blockState.m_61143_((Property)StatueBaseBlock.ROTATION)).intValue()));
            level.m_7471_(blockPos, false);
        }
    }
}

