/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.blockentity;

import java.util.Locale;
import mc.craig.software.angels.common.blockentity.WABlockEntities;
import mc.craig.software.angels.common.entity.angel.WeepingAngel;
import mc.craig.software.angels.common.entity.angel.ai.AngelVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SnowAngelBlockEntity
extends BlockEntity
implements BlockEntityTicker<SnowAngelBlockEntity> {
    private final AABB collisionAabb = new AABB(0.2, 0.0, 0.0, 0.8, 2.0, 0.1);
    private SnowStage snowAngelStages = SnowStage.ARM;
    private boolean isSetup = false;

    public void sendUpdates() {
        if (this.f_58857_ != null && this.m_58900_() != null && this.m_58900_().m_60734_() != null) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        this.m_6596_();
    }

    public SnowAngelBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(WABlockEntities.SNOW_ANGEL.get(), blockPos, blockState);
    }

    public void setSetup(boolean setup) {
        this.isSetup = setup;
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, SnowAngelBlockEntity blockEntity) {
        if (!this.isSetup) {
            this.setSnowAngelStages(SnowStage.randomStage(level.m_213780_()));
            this.setSetup(true);
            blockEntity.sendUpdates();
        }
        if (this.snowAngelStages == SnowStage.ARM) {
            return;
        }
        if (!level.m_45976_(Player.class, this.collisionAabb.m_82338_(this.m_58899_())).isEmpty() && !level.f_46443_) {
            WeepingAngel angel = new WeepingAngel(level);
            angel.setVariant(AngelVariant.STONE);
            BlockPos newPos = this.m_58899_();
            angel.m_6034_((double)newPos.m_123341_() + 0.5, newPos.m_123342_(), (double)newPos.m_123343_() + 0.5);
            level.m_7967_((Entity)angel);
            Integer layers = (Integer)level.m_8055_(this.f_58858_).m_61143_((Property)SnowLayerBlock.f_56581_);
            level.m_46597_(this.f_58858_, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)layers));
        }
    }

    public SnowStage getSnowAngelStages() {
        return this.snowAngelStages;
    }

    public void setSnowAngelStages(SnowStage snowAngelStages) {
        this.snowAngelStages = snowAngelStages;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("snowStage", this.getSnowAngelStages().getId());
        tag.m_128379_("needsBox", this.isSetup);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setSnowAngelStages(SnowStage.find(tag.m_128461_("snowStage")));
        this.isSetup = tag.m_128471_("needsBox");
    }

    public static enum SnowStage {
        ARM,
        HEAD,
        BODY,
        WINGS;


        public String getId() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static SnowStage randomStage(RandomSource randomSource) {
            int pick = randomSource.m_188503_(SnowStage.values().length);
            return SnowStage.values()[pick];
        }

        public static SnowStage find(String id) {
            for (SnowStage value : SnowStage.values()) {
                if (!value.getId().equalsIgnoreCase(id)) continue;
                return value;
            }
            return HEAD;
        }
    }
}

