/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.blockentity;

import mc.craig.software.angels.common.blockentity.WABlockEntities;
import mc.craig.software.angels.common.entity.angel.WeepingAngel;
import mc.craig.software.angels.util.WADamageSources;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GeneratorBlockEntity
extends BlockEntity
implements BlockEntityTicker<GeneratorBlockEntity> {
    public final AnimationState ANIMATION = new AnimationState();
    private int tickCount = 0;
    private boolean activated = false;
    private boolean hasSpawned = false;

    public GeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(WABlockEntities.GENERATOR.get(), blockPos, blockState);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("tickCount", this.getTickCount());
        tag.m_128379_("activated", this.isActivated());
        tag.m_128379_("hasSpawned", this.hasSpawned());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setTickCount(tag.m_128451_("tickCount"));
        this.setActivated(tag.m_128471_("activated"));
        this.setHasSpawned(tag.m_128471_("hasSpawned"));
    }

    public void sendUpdates() {
        if (this.f_58857_ != null && this.m_58900_() != null && this.m_58900_().m_60734_() != null) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        this.m_6596_();
    }

    public boolean hasSpawned() {
        return this.hasSpawned;
    }

    public void setHasSpawned(boolean hasSpawned) {
        this.hasSpawned = hasSpawned;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, GeneratorBlockEntity blockEntity) {
        if (!this.ANIMATION.m_216984_()) {
            this.ANIMATION.m_216977_(this.tickCount);
        }
        if (this.isActivated()) {
            ++this.tickCount;
        }
        if (this.tickCount > 100 && !this.hasSpawned()) {
            this.setHasSpawned(true);
            level.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_11860_, SoundSource.PLAYERS, 1.0f, 1.0f / level.m_213780_().m_188501_());
            this.tickCount = 0;
            this.sendUpdates();
        }
        if (this.hasSpawned()) {
            this.dragEntitiesAround(level);
        }
        if (this.tickCount > 200) {
            level.m_7471_(blockPos, false);
        }
    }

    private void dragEntitiesAround(Level level) {
        for (Entity entity : level.m_45976_(LivingEntity.class, GeneratorBlockEntity.createBoundingBox(this.f_58858_).m_82400_(32.0))) {
            WeepingAngel weepingAngel;
            if (entity instanceof WeepingAngel) {
                weepingAngel = (WeepingAngel)entity;
                weepingAngel.m_21557_(false);
                weepingAngel.setHooked(true);
            }
            if (entity.m_20275_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()) <= 4.0) {
                if (entity instanceof WeepingAngel) {
                    weepingAngel = (WeepingAngel)entity;
                    weepingAngel.m_142687_(Entity.RemovalReason.KILLED);
                } else {
                    Holder.Reference damageType = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(WADamageSources.GENERATOR);
                    entity.m_6469_(new DamageSource((Holder)damageType), 5.0f);
                }
            }
            BlockPos pos = this.f_58858_.m_121996_((Vec3i)entity.m_20183_());
            Vec3 vec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82541_();
            entity.m_20256_(vec.m_82490_(0.25));
            for (int i = 0; i < 2; ++i) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_175830_, entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public static AABB createBoundingBox(BlockPos tilePos) {
        int i = tilePos.m_123341_();
        int j = tilePos.m_123342_();
        int k = tilePos.m_123343_();
        return new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k);
    }
}

