/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.screen;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.Collection;
import mc.craig.software.angels.common.WAConstants;
import mc.craig.software.angels.common.blockentity.StatueBlockEntity;
import mc.craig.software.angels.common.entity.angel.WeepingAngel;
import mc.craig.software.angels.common.entity.angel.ai.AngelEmotion;
import mc.craig.software.angels.common.entity.angel.ai.AngelVariant;
import mc.craig.software.angels.network.messages.UpdateStatueMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChiselScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("weeping_angels", "textures/ui/menubg.png");
    private static final WeepingAngel weepingAngelFake = new WeepingAngel((Level)Minecraft.m_91087_().f_91073_);
    public static AnimationState POSE_ANIMATION_STATE = new AnimationState();
    private final BlockPos blockPos;
    private final ResourceKey<Level> level;
    public int guiLeft;
    public int guiTop;
    public int xSize = 200;
    public int ySize = 222;

    public ChiselScreen(Component component, BlockPos blockPos, ResourceKey<Level> levelResourceKey) {
        super(component);
        this.blockPos = blockPos;
        this.level = levelResourceKey;
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        CycleButton emotionButton = CycleButton.m_168894_(o -> Component.m_237113_((String)o.getId())).m_168961_((Object[])AngelEmotion.values()).m_168948_((Object)AngelEmotion.ANGRY).m_168936_(this.f_96543_ / 2 + 4 - 20, this.f_96544_ / 4 + 72 + -16, 130, 20, (Component)Component.m_237115_((String)WAConstants.ANGEL_EMOTION), (cycleButton, angelEmotion) -> weepingAngelFake.setEmotion((AngelEmotion)((Object)angelEmotion)));
        CycleButton variantCycleButton = CycleButton.m_168894_(o -> Component.m_237115_((String)("variant.weeping_angels." + o.location().m_135815_()))).m_232502_(AngelVariant.VARIANTS.values()).m_168948_((Object)AngelVariant.BASALT).m_168936_(this.f_96543_ / 2 + 4 - 20, this.f_96544_ / 4 + 48 + -16, 130, 20, (Component)Component.m_237115_((String)WAConstants.ANGEL_VARIANT), (cycleButton, angelVariant) -> weepingAngelFake.setVariant((AngelVariant)angelVariant));
        CycleButton poseCycleButton = CycleButton.m_168894_(o -> Component.m_237113_((String)o.toString())).m_232502_((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12})).m_168948_((Object)0).m_168936_(this.f_96543_ / 2 + 4 - 20, this.f_96544_ / 4 + 72 + 25 + -16, 130, 20, (Component)Component.m_237115_((String)WAConstants.ANGEL_POSES), (cycleButton, angelVariant) -> weepingAngelFake.setFakeAnimation((int)angelVariant));
        this.m_142416_((GuiEventListener)emotionButton);
        this.m_142416_((GuiEventListener)variantCycleButton);
        this.m_142416_((GuiEventListener)poseCycleButton);
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.blockPos);
        if (blockEntity instanceof StatueBlockEntity) {
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
            weepingAngelFake.setVariant(statueBlockEntity.getVariant());
            weepingAngelFake.setEmotion(statueBlockEntity.getEmotion());
            weepingAngelFake.setFakeAnimation(statueBlockEntity.getAnimation());
            variantCycleButton.m_168892_((Object)statueBlockEntity.getVariant());
            emotionButton.m_168892_((Object)statueBlockEntity.getEmotion());
            poseCycleButton.m_168892_((Object)statueBlockEntity.getAnimation());
        } else {
            Minecraft.m_91087_().m_91152_(null);
        }
        Button quitButton = Button.m_253074_((Component)Component.m_237115_((String)"Chisel"), button -> {
            new UpdateStatueMessage((AngelVariant)variantCycleButton.m_168883_(), (AngelEmotion)((Object)((Object)emotionButton.m_168883_())), (Integer)poseCycleButton.m_168883_(), this.blockPos, this.level).send();
            Minecraft.m_91087_().m_91152_(null);
        }).m_253136_();
        this.m_7787_((GuiEventListener)quitButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280163_(BACKGROUND, this.guiLeft - 30, this.guiTop, 0.0f, 0.0f, 256, 256, 256, 256);
        if (!POSE_ANIMATION_STATE.m_216984_()) {
            POSE_ANIMATION_STATE.m_216977_(12);
        }
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(this.guiLeft + 25), (int)(this.guiTop + 160), (int)55, (float)-90.0f, (float)-45.0f, (LivingEntity)weepingAngelFake);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"Statue appearance"), this.guiLeft - 20, this.guiTop + 8, Color.BLACK.getRGB());
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }
}

