/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.crafting;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CraftingUpgradeContainer
extends UpgradeContainerBase<CraftingUpgradeWrapper, CraftingUpgradeContainer>
implements ICraftingContainer {
    private static final String DATA_SHIFT_CLICK_INTO_STORAGE = "shiftClickIntoStorage";
    private final ResultContainer craftResult = new ResultContainer();
    private final CraftingItemHandler craftMatrix;
    private final ResultSlot craftingResultSlot;
    @Nullable
    private CraftingRecipe lastRecipe = null;

    public CraftingUpgradeContainer(final Player player, int upgradeContainerId, CraftingUpgradeWrapper upgradeWrapper, UpgradeContainerType<CraftingUpgradeWrapper, CraftingUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        int slot;
        for (slot = 0; slot < upgradeWrapper.getInventory().getSlots(); ++slot) {
            this.slots.add(new SlotSuppliedHandler(upgradeWrapper::getInventory, slot, -100, -100){

                public void m_6654_() {
                    super.m_6654_();
                    CraftingUpgradeContainer.this.updateCraftingResult(player.m_9236_(), player, (CraftingContainer)CraftingUpgradeContainer.this.craftMatrix, CraftingUpgradeContainer.this.craftResult, CraftingUpgradeContainer.this.craftingResultSlot);
                    CraftingUpgradeContainer.this.craftMatrix.m_6596_();
                }
            });
        }
        this.craftMatrix = new CraftingItemHandler(upgradeWrapper::getInventory, this::onCraftMatrixChanged);
        this.craftingResultSlot = new ResultSlot(player, (CraftingContainer)this.craftMatrix, (Container)this.craftResult, slot, -100, -100){

            public void m_142406_(Player thePlayer, ItemStack stack) {
                ItemStack remainingStack = this.m_7993_();
                this.m_5845_(stack);
                ForgeHooks.setCraftingPlayer((Player)thePlayer);
                NonNullList items = CraftingUpgradeContainer.this.lastRecipe != null && CraftingUpgradeContainer.this.lastRecipe.m_5818_((Container)CraftingUpgradeContainer.this.craftMatrix, player.m_9236_()) ? CraftingUpgradeContainer.this.lastRecipe.m_7457_((Container)CraftingUpgradeContainer.this.craftMatrix) : CraftingUpgradeContainer.this.craftMatrix.m_280657_();
                ForgeHooks.setCraftingPlayer(null);
                for (int i = 0; i < items.size(); ++i) {
                    AbstractContainerMenu abstractContainerMenu;
                    ItemStack itemstack = CraftingUpgradeContainer.this.craftMatrix.m_8020_(i);
                    ItemStack itemstack1 = (ItemStack)items.get(i);
                    if (!itemstack.m_41619_()) {
                        CraftingUpgradeContainer.this.craftMatrix.m_7407_(i, 1);
                        itemstack = CraftingUpgradeContainer.this.craftMatrix.m_8020_(i);
                    }
                    if (!itemstack1.m_41619_()) {
                        if (itemstack.m_41619_()) {
                            CraftingUpgradeContainer.this.craftMatrix.m_6836_(i, itemstack1);
                        } else if (ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)itemstack1)) {
                            itemstack1.m_41769_(itemstack.m_41613_());
                            CraftingUpgradeContainer.this.craftMatrix.m_6836_(i, itemstack1);
                        } else if (!player.m_150109_().m_36054_(itemstack1)) {
                            player.m_36176_(itemstack1, false);
                        }
                    }
                    if (!((abstractContainerMenu = thePlayer.f_36096_) instanceof StorageContainerMenuBase)) continue;
                    StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)abstractContainerMenu;
                    Slot slot = (Slot)CraftingUpgradeContainer.this.slots.get(i);
                    storageContainerMenu.setSlotStackToUpdate(slot.f_40219_, slot.m_7993_());
                }
                if (!remainingStack.m_41619_()) {
                    player.m_36176_(remainingStack, false);
                }
            }
        };
        this.slots.add(this.craftingResultSlot);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.onCraftMatrixChanged((Container)this.craftMatrix);
    }

    private void onCraftMatrixChanged(Container iInventory) {
        this.updateCraftingResult(this.player.m_9236_(), this.player, (CraftingContainer)this.craftMatrix, this.craftResult, this.craftingResultSlot);
    }

    private void updateCraftingResult(Level level, Player player, CraftingContainer inventory, ResultContainer inventoryResult, ResultSlot craftingResultSlot) {
        if (!level.f_46443_) {
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            if (this.lastRecipe != null && this.lastRecipe.m_5818_((Container)inventory, level)) {
                itemstack = this.lastRecipe.m_5874_((Container)inventory, level.m_9598_());
            } else {
                Optional optional = RecipeHelper.safeGetRecipeFor(RecipeType.f_44107_, inventory, level);
                if (optional.isPresent()) {
                    CraftingRecipe craftingRecipe = (CraftingRecipe)optional.get();
                    if (inventoryResult.m_40135_(level, serverplayerentity, (Recipe)craftingRecipe)) {
                        this.lastRecipe = craftingRecipe;
                        itemstack = this.lastRecipe.m_5874_((Container)inventory, level.m_9598_());
                    } else {
                        this.lastRecipe = null;
                    }
                }
            }
            craftingResultSlot.m_5852_(itemstack);
            AbstractContainerMenu abstractContainerMenu = serverplayerentity.f_36096_;
            if (abstractContainerMenu instanceof StorageContainerMenuBase) {
                StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)abstractContainerMenu;
                storageContainerMenu.setSlotStackToUpdate(craftingResultSlot.f_40219_, itemstack);
            }
        }
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SHIFT_CLICK_INTO_STORAGE)) {
            this.setShiftClickIntoStorage(data.m_128471_(DATA_SHIFT_CLICK_INTO_STORAGE));
        }
    }

    @Override
    public ItemStack getSlotStackToTransfer(Slot slot) {
        if (slot == this.craftingResultSlot) {
            ItemStack slotStack = slot.m_7993_();
            slotStack.m_41720_().m_7836_(slotStack, this.player.m_9236_(), this.player);
            return slotStack;
        }
        return super.getSlotStackToTransfer(slot);
    }

    @Override
    public List<Slot> getRecipeSlots() {
        return this.slots.subList(0, 9);
    }

    @Override
    public Container getCraftMatrix() {
        return this.craftMatrix;
    }

    public boolean shouldShiftClickIntoStorage() {
        return ((CraftingUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoStorage();
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        ((CraftingUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoStorage(shiftClickIntoStorage);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHIFT_CLICK_INTO_STORAGE, shiftClickIntoStorage));
    }

    @Override
    public boolean mergeIntoStorageFirst(Slot slot) {
        return !(slot instanceof ResultSlot) || this.shouldShiftClickIntoStorage();
    }

    @Override
    public boolean allowsPickupAll(Slot slot) {
        return slot != this.craftingResultSlot;
    }
}

