/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.common.transfer.TransferOperation;
import mezz.jei.common.util.StringUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.TransferRecipeMessage;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;

public abstract class CraftingContainerRecipeTransferHandlerBase<C extends StorageContainerMenuBase<?>>
implements IRecipeTransferHandler<C, CraftingRecipe> {
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IStackHelper stackHelper;

    protected CraftingContainerRecipeTransferHandlerBase(IRecipeTransferHandlerHelper handlerHelper, IStackHelper stackHelper) {
        this.handlerHelper = handlerHelper;
        this.stackHelper = stackHelper;
    }

    public Optional<MenuType<C>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        List<Object> list;
        Optional potentialCraftingContainer = ((StorageContainerMenuBase)container).getOpenOrFirstCraftingContainer();
        if (potentialCraftingContainer.isEmpty()) {
            return this.handlerHelper.createInternalError();
        }
        UpgradeContainerBase openOrFirstCraftingContainer = (UpgradeContainerBase)potentialCraftingContainer.get();
        if (openOrFirstCraftingContainer instanceof ICraftingContainer) {
            ICraftingContainer cc = (ICraftingContainer)((Object)openOrFirstCraftingContainer);
            list = cc.getRecipeSlots();
        } else {
            list = Collections.emptyList();
        }
        List<Slot> craftingSlots = Collections.unmodifiableList(list);
        List<Slot> inventorySlots = ((StorageContainerMenuBase)container).realInventorySlots.stream().filter(s -> s.m_8010_(player)).toList();
        if (!this.validateTransferInfo(container, craftingSlots, inventorySlots)) {
            return this.handlerHelper.createInternalError();
        }
        List inputItemSlotViews = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
        if (!this.validateRecipeView(container, craftingSlots, inputItemSlotViews)) {
            return this.handlerHelper.createInternalError();
        }
        InventoryState inventoryState = this.getInventoryState(craftingSlots, inventorySlots, player, container);
        if (inventoryState == null) {
            return this.handlerHelper.createInternalError();
        }
        int inputCount = inputItemSlotViews.size();
        if (!inventoryState.hasRoom(inputCount)) {
            MutableComponent message = Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip((Component)message);
        }
        RecipeTransferOperationsResult transferOperations = RecipeTransferUtil.getRecipeTransferOperations((IStackHelper)this.stackHelper, inventoryState.availableItemStacks, (List)inputItemSlotViews, craftingSlots);
        if (transferOperations.missingItems.size() > 0) {
            MutableComponent message = Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.missing");
            return this.handlerHelper.createUserErrorForMissingSlots((Component)message, (Collection)transferOperations.missingItems);
        }
        if (!RecipeTransferUtil.validateSlots((Player)player, (Collection)transferOperations.results, craftingSlots, inventorySlots)) {
            return this.handlerHelper.createInternalError();
        }
        List<Integer> craftingSlotIndexes = craftingSlots.stream().map(s -> s.f_40219_).sorted().toList();
        List<Integer> inventorySlotIndexes = inventorySlots.stream().map(s -> s.f_40219_).sorted().toList();
        if (doTransfer) {
            if (!openOrFirstCraftingContainer.isOpen()) {
                ((StorageContainerMenuBase)container).getOpenContainer().ifPresent(c -> {
                    c.setIsOpen(false);
                    container.setOpenTabId(-1);
                });
                openOrFirstCraftingContainer.setIsOpen(true);
                ((StorageContainerMenuBase)container).setOpenTabId(openOrFirstCraftingContainer.getUpgradeContainerId());
            }
            TransferRecipeMessage message = new TransferRecipeMessage(this.toMap(transferOperations.results), craftingSlotIndexes, inventorySlotIndexes, maxTransfer);
            PacketHandler.INSTANCE.sendToServer(message);
        }
        return null;
    }

    private Map<Integer, Integer> toMap(List<TransferOperation> transferOperations) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        transferOperations.forEach(to -> ret.put(to.craftingSlot().f_40219_, to.inventorySlot().f_40219_));
        return ret;
    }

    private boolean validateTransferInfo(C container, List<Slot> craftingSlots, List<Slot> inventorySlots) {
        Set<Integer> craftingSlotIndexes = this.slotIndexes(craftingSlots);
        Set<Integer> inventorySlotIndexes = this.slotIndexes(inventorySlots);
        ArrayList<Slot> allSlots = new ArrayList<Slot>(((StorageContainerMenuBase)container).realInventorySlots);
        allSlots.addAll(((StorageContainerMenuBase)container).upgradeSlots);
        Set<Integer> containerSlotIndexes = this.slotIndexes(allSlots);
        if (!containerSlotIndexes.containsAll(craftingSlotIndexes)) {
            SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Recipes Transfer Helper references crafting slot indexes [{}] that are not found in the inventory container slots [{}]", this.getClass(), container.getClass(), (Object)StringUtil.intsToString(craftingSlotIndexes), (Object)StringUtil.intsToString(containerSlotIndexes));
            return false;
        }
        if (!containerSlotIndexes.containsAll(inventorySlotIndexes)) {
            SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Recipes Transfer Helper references inventory slot indexes [{}] that are not found in the inventory container slots [{}]", this.getClass(), container.getClass(), (Object)StringUtil.intsToString(inventorySlotIndexes), (Object)StringUtil.intsToString(containerSlotIndexes));
            return false;
        }
        return true;
    }

    private boolean validateRecipeView(C container, List<Slot> craftingSlots, List<IRecipeSlotView> inputSlots) {
        if (inputSlots.size() > craftingSlots.size()) {
            SophisticatedCore.LOGGER.error("Recipe View {} does not work for container {}. The Recipe View has more input slots ({}) than the number of inventory crafting slots ({})", this.getClass(), container.getClass(), (Object)inputSlots.size(), (Object)craftingSlots.size());
            return false;
        }
        return true;
    }

    @Nullable
    private InventoryState getInventoryState(Collection<Slot> craftingSlots, Collection<Slot> inventorySlots, Player player, C container) {
        ItemStack stack;
        HashMap<Slot, ItemStack> availableItemStacks = new HashMap<Slot, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots) {
            stack = slot.m_7993_();
            if (stack.m_41619_()) continue;
            if (!slot.m_8010_(player)) {
                SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Player is not able to move items out of Crafting Slot number {}", this.getClass(), container.getClass(), (Object)slot.f_40219_);
                return null;
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot, stack.m_41777_());
        }
        for (Slot slot : inventorySlots) {
            stack = slot.m_7993_();
            if (!stack.m_41619_()) {
                if (!slot.m_8010_(player)) {
                    SophisticatedCore.LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Player is not able to move items out of Inventory Slot number {}", this.getClass(), container.getClass(), (Object)slot.f_40219_);
                    return null;
                }
                availableItemStacks.put(slot, stack.m_41777_());
                continue;
            }
            ++emptySlotCount;
        }
        return new InventoryState(availableItemStacks, filledCraftSlotCount, emptySlotCount);
    }

    private Set<Integer> slotIndexes(Collection<Slot> slots) {
        return slots.stream().map(s -> s.f_40219_).collect(Collectors.toSet());
    }

    private int getEmptySlotCount(Map<Integer, Slot> inventorySlots, Map<Integer, ItemStack> availableItemStacks) {
        int emptySlotCount = 0;
        for (Slot slot : inventorySlots.values()) {
            ItemStack stack = slot.m_7993_();
            if (!stack.m_41619_()) {
                availableItemStacks.put(slot.f_40219_, stack.m_41777_());
                continue;
            }
            ++emptySlotCount;
        }
        return emptySlotCount;
    }

    public record InventoryState(Map<Slot, ItemStack> availableItemStacks, int filledCraftSlotCount, int emptySlotCount) {
        public boolean hasRoom(int inputCount) {
            return this.filledCraftSlotCount - inputCount <= this.emptySlotCount;
        }
    }
}

