/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.chesttypes;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.utils.FileUtils;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.GsonHelper;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.api.chesttype.ChestUpgradeType;
import tech.thatgravyboat.ironchests.common.chesttypes.LoaderConfig;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestTypeRegistry;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestUpgradeTypeRegistry;
import tech.thatgravyboat.ironchests.common.utils.ModPaths;
import tech.thatgravyboat.ironchests.common.utils.ModUtils;

public class ChestTypeLoader {
    private static final Gson GSON = new Gson();

    public static void setupChest() {
        LoaderConfig.load();
        ChestTypeLoader.setupDefaultFiles("/data/ironchests/chests", ModPaths.CHESTS, "chests");
        ChestTypeLoader.setupDefaultFiles("/data/ironchests/barrels", ModPaths.BARRELS, "barrels");
        ChestTypeLoader.setupDefaultFiles("/data/ironchests/upgrade_types", ModPaths.UPGRADE_TYPES, "chest_upgrades");
        FileUtils.streamFilesAndParse((Path)ModPaths.CHESTS, ChestTypeLoader::parseChest, FileUtils::isJson);
        FileUtils.streamFilesAndParse((Path)ModPaths.UPGRADE_TYPES, ChestTypeLoader::parseChestUpgrade, FileUtils::isJson);
        ChestTypeLoader.runChestChecks();
        LoaderConfig.save();
    }

    private static void runChestChecks() {
        ChestTypeRegistry.INSTANCE.getChests().values().stream().map(ChestType::oxidizedChest).filter(Objects::nonNull).forEach(ChestUpgradeType::get);
    }

    private static void parseChest(Reader reader, String name) {
        JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
        ChestType.codec(name).parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().ifPresent(ChestTypeRegistry.INSTANCE::register);
    }

    private static void parseChestUpgrade(Reader reader, String name) {
        JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
        ChestUpgradeType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().ifPresent(ChestUpgradeTypeRegistry.INSTANCE::register);
    }

    private static void setupDefaultFiles(String dataPath, Path targetPath, String id) {
        if (LoaderConfig.get(id)) {
            return;
        }
        LoaderConfig.set(id, true);
        ChestTypeLoader.setupDefaultFiles(dataPath, targetPath);
    }

    private static void setupDefaultFiles(String dataPath, Path targetPath) {
        List<Path> roots = ModUtils.getModFilePath("ironchests");
        if (roots.isEmpty()) {
            throw new RuntimeException("Failed to load defaults.");
        }
        for (Path modRoot : roots) {
            FileUtils.copyDefaultFiles((String)dataPath, (Path)targetPath, (Path)modRoot, FileUtils::isJson);
        }
    }
}

